/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.shelve;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4ShelveFile;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.changelists.PendingCombo;
import com.perforce.team.ui.dialogs.P4StatusDialog;
import com.perforce.team.ui.shelve.FileShelfWidget;
import com.perforce.team.ui.shelve.Messages;
import com.perforce.team.ui.shelve.UnshelveDialog;
import java.text.MessageFormat;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class FileShelfDialog
extends P4StatusDialog {
    private FileShelfWidget widget;
    private PendingCombo combo;
    private IP4File file;
    private IP4ShelveFile[] shelves;
    private IP4ShelveFile selected;
    private boolean revert = false;
    private boolean forceWritable = false;
    private int changelist = -1;
    private String description = null;

    public FileShelfDialog(Shell parent, IP4File file, IP4ShelveFile[] shelves) {
        super(parent);
        this.setTitle(MessageFormat.format(Messages.FileShelfDialog_UnshelveFile, file.getName()));
        this.setModalResizeStyle();
        this.file = file;
        this.shelves = shelves;
    }

    @Override
    protected String getSectionName() {
        return "FILE_SHELF_WIDGET";
    }

    public boolean revert() {
        return this.revert;
    }

    public int getChangelist() {
        return this.changelist;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean overwrite() {
        return this.forceWritable;
    }

    public IP4ShelveFile getSelected() {
        return this.selected;
    }

    protected void okPressed() {
        this.selected = this.widget.getSelectedFile();
        this.revert = this.widget.isRevert();
        this.changelist = this.combo.getSelected();
        this.description = this.combo.getDescription();
        super.okPressed();
    }

    private void validate() {
        if (this.widget.getViewer().getSelection().isEmpty()) {
            this.setErrorMessage(Messages.FileShelfDialog_MustSelectFileToUnshelve);
        } else {
            this.setErrorMessage(null);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        this.combo = new PendingCombo(Messages.FileShelfDialog_AddToChangelist, (IP4Resource)this.file);
        this.combo.createControl(c, UnshelveDialog.UNSHELVE_DEFAULT_DESCRIPTION);
        this.widget = new FileShelfWidget(this.shelves, this.file, MessageFormat.format(Messages.FileShelfDialog_UnshelvingFile, this.file.getRemotePath()));
        this.widget.createControl(c);
        this.widget.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                FileShelfDialog.this.okPressed();
            }
        });
        this.widget.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FileShelfDialog.this.validate();
            }
        });
        final Button forceButton = new Button(c, 32);
        this.forceWritable = PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean("com.perforce.team.ui.shelve.FORCE_WRITABLE");
        forceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileShelfDialog.this.forceWritable = forceButton.getSelection();
                PerforceUIPlugin.getPlugin().getPreferenceStore().setValue("com.perforce.team.ui.shelve.FORCE_WRITABLE", FileShelfDialog.this.forceWritable);
            }
        });
        forceButton.setSelection(this.forceWritable);
        forceButton.setText(Messages.FileShelfDialog_OverwriteFilesCurrentlyWriteable);
        this.validate();
        return c;
    }
}

