/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.shelve;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4ShelveFile;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.editor.CompareUtils;
import com.perforce.team.ui.shelve.BaseShelveAction;
import com.perforce.team.ui.shelve.DiffShelveDialog;
import com.perforce.team.ui.shelve.Messages;
import com.perforce.team.ui.shelve.ShelveAction;
import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;

public class DiffShelveAction
extends BaseShelveAction {
    @Override
    protected void runAction() {
        IP4Resource resource = this.getSingleOnlineResourceSelection();
        if (resource instanceof IP4File) {
            final IP4File file = (IP4File)resource;
            P4Runnable runnable = new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    if (file.getConnection().isShelvingSupported()) {
                        final IP4ShelveFile[] shelves = file.getShelvedVersions();
                        PerforceUIPlugin.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (shelves.length > 0) {
                                    DiffShelveDialog dialog = new DiffShelveDialog(P4UIUtils.getDialogShell(), file, shelves);
                                    if (dialog.open() == 0) {
                                        DiffShelveAction.this.compare(file, dialog.getSelected());
                                    }
                                } else {
                                    DiffShelveAction.showNoVersions(file);
                                }
                            }
                        });
                    } else {
                        ShelveAction.showNotSupported(file.getConnection());
                    }
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
    }

    public void compare(final IP4File file, final IP4ShelveFile shelveFile) {
        if (file != null && shelveFile != null) {
            P4Runnable runnable = new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    File shelveLocalFile = P4CoreUtils.createFile((InputStream)shelveFile.getRemoteContents());
                    CompareUtils.openLocalCompare(file, shelveLocalFile, MessageFormat.format(Messages.DiffShelveAction_ShelvedFile, String.valueOf(shelveFile.getName()) + shelveFile.getRevision()));
                }

                public String getTitle() {
                    return Messages.DiffShelveAction_OpeningCompareEditor;
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
    }

    public void compareRevision(final IP4File file, final int revision, final IP4ShelveFile shelveFile) {
        if (file != null && shelveFile != null) {
            P4Runnable runnable = new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    File shelveLocalFile = P4CoreUtils.createFile((InputStream)shelveFile.getRemoteContents());
                    CompareUtils.openLocalCompare(file, revision, shelveLocalFile, MessageFormat.format(Messages.DiffShelveAction_ShelvedFile, String.valueOf(file.getName()) + shelveFile.getRevision()));
                }

                public String getTitle() {
                    return Messages.DiffShelveAction_OpeningCompareEditor;
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
    }
}

