/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.resource;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.dialogs.P4StatusDialog;
import com.perforce.team.ui.labels.VersionWidget;
import com.perforce.team.ui.p4java.dialogs.PopulateDialog;
import com.perforce.team.ui.resource.Messages;
import com.perforce.team.ui.resource.ResourceBrowserWidget;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class VersionedResourceBrowserDialog
extends P4StatusDialog {
    private String initialPath;
    private String version;
    private IP4Resource[] resources = null;
    private IP4Resource selected = null;
    private ResourceBrowserWidget treeWidget = null;
    private VersionWidget versionWidget = null;

    public VersionedResourceBrowserDialog(Shell parent, IP4Resource[] resources, String initial) {
        super(parent);
        this.setTitle(Messages.ResourceBrowserDialog_SelectAResource);
        this.setModalResizeStyle();
        this.resources = resources;
        this.initialPath = initial;
    }

    public IP4Resource getSelectedResource() {
        return this.selected;
    }

    public String getVersion() {
        return this.version;
    }

    protected void okPressed() {
        IP4Resource selection = this.treeWidget.getSelectedResource();
        if (selection == null || StringUtils.isEmpty((CharSequence)selection.getActionPath())) {
            this.setErrorMessage("You must select a folder or file!");
            return;
        }
        this.selected = selection;
        this.version = this.versionWidget.getVersion();
        super.okPressed();
    }

    public TreeViewer getViewer() {
        return this.treeWidget != null ? this.treeWidget.getViewer() : null;
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        this.treeWidget = new ResourceBrowserWidget(this.resources);
        this.treeWidget.createControl(c);
        this.treeWidget.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (VersionedResourceBrowserDialog.this.treeWidget.getSelectedResource() != null) {
                    VersionedResourceBrowserDialog.this.okPressed();
                }
            }
        });
        this.treeWidget.setErrorDisplay(this);
        this.versionWidget = new VersionWidget();
        this.versionWidget.createControl(c).setLayoutData((Object)new GridData(4, 4, true, false));
        this.versionWidget.setErrorDisplay(this);
        this.init();
        return c;
    }

    private void init() {
        PopulateDialog.FileVersion v = new PopulateDialog.FileVersion(this.initialPath);
        if (!StringUtils.isEmpty((CharSequence)this.initialPath)) {
            this.expandElement(this.treeWidget.getViewer(), this.resources[0].getConnection(), v.getPath());
        }
        if (!StringUtils.isEmpty((CharSequence)v.getRevision())) {
            this.versionWidget.setVersion(v.getRevision());
        }
    }

    private Object expandElement(TreeViewer viewer, IP4Connection connection, String path) {
        if (path == null) {
            return null;
        }
        IP4Connection curr = connection;
        if (curr == null || curr.getConnection().isOffline()) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(path, "/");
        IP4Resource targetFile = null;
        while (tokens.hasMoreTokens()) {
            String name = tokens.nextToken();
            System.out.println("expand  " + name);
            viewer.setExpandedState((Object)curr, true);
            IP4Resource[] children = curr.members();
            boolean found = false;
            int i = 0;
            while (i < children.length) {
                IP4Resource child = children[i];
                if (name.equals(child.getName())) {
                    if (child instanceof IP4Container) {
                        curr = (IP4Container)child;
                        found = true;
                        break;
                    }
                    targetFile = child;
                }
                ++i;
            }
            if (!found) break;
        }
        viewer.setExpandedState((Object)curr, true);
        if (targetFile != null) {
            viewer.setSelection((ISelection)new StructuredSelection(targetFile), true);
        } else {
            viewer.setSelection((ISelection)new StructuredSelection((Object)curr), true);
        }
        return curr;
    }
}

