/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.refactor;

import com.perforce.team.core.PerforceProviderPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class MoveSession {
    private List<Pair> folders;
    private List<Pair> unmoved;
    private List<Pair> moved;
    private IResourceTree tree;
    private int flags;
    private IProgressMonitor monitor;

    public MoveSession(IResourceTree tree, int flags, IProgressMonitor monitor) {
        this.tree = tree;
        this.flags = flags;
        this.monitor = monitor;
        this.folders = new ArrayList<Pair>();
        this.unmoved = new ArrayList<Pair>();
        this.moved = new ArrayList<Pair>();
    }

    public void moved(IFile source, IFile destination, boolean success) {
        if (success) {
            this.moved.add(new Pair((IResource)source, (IResource)destination));
        } else {
            this.unmoved.add(new Pair((IResource)source, (IResource)destination));
        }
    }

    public void moved(IFolder source, IFolder destination) {
        this.folders.add(new Pair((IResource)source, (IResource)destination));
    }

    private boolean exists(IResource resource) {
        IPath location = resource.getLocation();
        return location != null ? location.toFile().exists() : false;
    }

    public void finish() {
        for (Pair pair : this.folders) {
            if (this.exists(pair.destination)) {
                this.tree.movedFolderSubtree((IFolder)pair.source, (IFolder)pair.destination);
                continue;
            }
            try {
                pair.source.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                pair.destination.getParent().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                this.tree.standardMoveFolder((IFolder)pair.source, (IFolder)pair.destination, this.flags, this.monitor);
            }
            catch (CoreException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
        this.folders.clear();
        for (Pair pair : this.moved) {
            if (pair.destination.exists()) continue;
            this.tree.movedFile((IFile)pair.source, (IFile)pair.destination);
        }
        this.moved.clear();
        for (Pair pair : this.unmoved) {
            if (this.exists(pair.destination)) continue;
            try {
                pair.source.refreshLocal(1, this.monitor);
                pair.destination.refreshLocal(1, this.monitor);
                this.tree.standardMoveFile((IFile)pair.source, (IFile)pair.destination, this.flags, this.monitor);
            }
            catch (CoreException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
        this.unmoved.clear();
    }

    private static class Pair {
        IResource source;
        IResource destination;

        Pair(IResource source, IResource destination) {
            this.source = source;
            this.destination = destination;
        }
    }
}

