/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.refactor;

import com.perforce.team.core.p4java.ChangelistSelection;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.ui.InfiniteProgressMonitor;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.dialogs.RefactorDialog;
import com.perforce.team.ui.refactor.IMoveManager;
import com.perforce.team.ui.refactor.Messages;
import com.perforce.team.ui.refactor.MoveSession;
import com.perforce.team.ui.refactor.RefactorManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;

public abstract class MoveManager
extends RefactorManager
implements IMoveManager {
    public static final int PROGRESS = 100;
    private boolean useSession = false;
    private boolean firePostEvent = false;

    public MoveManager() {
        this(false, false);
    }

    public MoveManager(boolean useSession, boolean firePostEvent) {
        this.useSession = useSession;
        this.firePostEvent = firePostEvent;
    }

    protected boolean caseOnlyChange(String from, String to) {
        if (from != null && to != null) {
            return from.equalsIgnoreCase(to);
        }
        return false;
    }

    protected boolean sameParent(IResource resource1, IResource resource2) {
        if (resource1 != null && resource2 != null) {
            resource1 = resource1.getParent();
            resource2 = resource2.getParent();
            if (resource1 != null) {
                return resource1.equals((Object)resource2);
            }
            return resource2 == null;
        }
        return false;
    }

    protected boolean validateMove(IResource from, IResource to) {
        boolean moveable = false;
        if (from != null && to != null) {
            IP4Connection fromConnection = P4ConnectionManager.getManager().getConnection(from.getProject());
            IP4Connection toConnection = P4ConnectionManager.getManager().getConnection(to.getProject());
            if (fromConnection != null && fromConnection.equals(toConnection)) {
                moveable = true;
                if (!fromConnection.isCaseSensitive()) {
                    if (from instanceof IContainer && to instanceof IContainer) {
                        if (this.caseOnlyChange(from.getFullPath().toOSString(), to.getFullPath().toOSString())) {
                            this.showCaseRenameError(fromConnection);
                        }
                    } else if (from instanceof IFile && to instanceof IFile && this.sameParent(from, to) && this.caseOnlyChange(from.getName(), to.getName())) {
                        this.showCaseRenameError(fromConnection);
                    }
                }
            }
        }
        return moveable;
    }

    protected void showCaseRenameError(IP4Connection connection) throws OperationCanceledException {
        final String title = MessageFormat.format(Messages.MoveManager_CaseRenamesTitle, connection.getParameters().getPort());
        PerforceUIPlugin.syncExec(new Runnable(){

            @Override
            public void run() {
                P4ConnectionManager.getManager().openError(P4UIUtils.getShell(), title, Messages.MoveManager_CaseRenamesMessage);
            }
        });
        throw new OperationCanceledException(title);
    }

    private boolean canMoveFiles(IP4Resource fromResource, IP4Resource toResource) {
        return fromResource instanceof IP4File && toResource instanceof IP4File && fromResource.getConnection() == toResource.getConnection();
    }

    protected void internalMoveFile(IFile source, IFile destination, Collection<IP4File> files, ChangelistSelection changelistSelection, IProgressMonitor monitor, MoveSession session) {
        IP4Resource toResource;
        IP4Resource fromResource = P4ConnectionManager.getManager().getResource((IResource)source);
        if (this.canMoveFiles(fromResource, toResource = P4ConnectionManager.getManager().getResource((IResource)destination))) {
            IP4File fromFile = (IP4File)fromResource;
            IP4File toFile = (IP4File)toResource;
            boolean moved = this.moveFile(fromFile, toFile, changelistSelection);
            if (session != null) {
                session.moved(source, destination, moved);
            }
            if (files != null) {
                IP4Resource finalSource = P4ConnectionManager.getManager().getResource((IResource)source);
                IP4Resource finalDest = P4ConnectionManager.getManager().getResource((IResource)destination);
                if (finalSource instanceof IP4File) {
                    files.add((IP4File)finalSource);
                }
                if (finalDest instanceof IP4File) {
                    files.add((IP4File)finalDest);
                }
            }
            monitor.worked(1);
        }
    }

    protected abstract void moveFolder(IFolder var1, IFolder var2, List<IP4File> var3, ChangelistSelection var4, IProgressMonitor var5, MoveSession var6);

    protected abstract boolean moveFile(IP4File var1, IP4File var2, ChangelistSelection var3);

    protected void preUpdateTree(IResourceTree tree, IFolder source, IFolder destination, int flags, IProgressMonitor monitor) {
    }

    protected void postUpdateTree(IResourceTree tree, IFolder source, IFolder destination, int flags, IProgressMonitor monitor) {
    }

    protected void preUpdateTree(IResourceTree tree, IFile source, IFile destination, int flags, IProgressMonitor monitor) {
    }

    protected void postUpdateTree(IResourceTree tree, IFile source, IFile destination, int flags, IProgressMonitor monitor) {
    }

    @Override
    public boolean move(IResourceTree tree, IFolder source, IFolder destination, int flags, IProgressMonitor monitor) {
        if (this.isEnabled()) {
            if (!this.validateMove((IResource)source, (IResource)destination)) {
                return true;
            }
            InfiniteProgressMonitor subMonitor = new InfiniteProgressMonitor(monitor, 2);
            subMonitor.beginTask("", 100);
            ChangelistSelection selection = this.getRefactorId((IResource)source, (IResource)destination, (IProgressMonitor)subMonitor);
            MoveSession session = this.useSession ? new MoveSession(tree, flags, monitor) : null;
            ArrayList<IP4File> files = this.firePostEvent ? new ArrayList<IP4File>() : null;
            this.preUpdateTree(tree, source, destination, flags, monitor);
            this.moveFolder(source, destination, files, selection, (IProgressMonitor)subMonitor, session);
            this.postUpdateTree(tree, source, destination, flags, monitor);
            if (session != null) {
                session.finish();
            }
            if (files != null) {
                this.firePostEvent(files);
                this.firePostAddEvent((IResource)destination);
            }
            subMonitor.done();
        } else {
            tree.standardMoveFolder(source, destination, flags, monitor);
        }
        return true;
    }

    @Override
    public boolean move(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
        tree.standardMoveProject(source, description, updateFlags, monitor);
        return true;
    }

    @Override
    public boolean move(IResourceTree tree, IFile source, IFile destination, int flags, IProgressMonitor monitor) {
        if (this.isEnabled()) {
            if (!this.validateMove((IResource)source, (IResource)destination)) {
                return true;
            }
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
            subMonitor.beginTask("", 2);
            ChangelistSelection selection = this.getRefactorId((IResource)source, (IResource)destination, (IProgressMonitor)subMonitor);
            subMonitor.worked(1);
            MoveSession session = this.useSession ? new MoveSession(tree, flags, monitor) : null;
            ArrayList<IP4File> files = this.firePostEvent ? new ArrayList<IP4File>() : null;
            this.preUpdateTree(tree, source, destination, flags, monitor);
            this.internalMoveFile(source, destination, files, selection, (IProgressMonitor)subMonitor, session);
            this.postUpdateTree(tree, source, destination, flags, monitor);
            if (session != null) {
                session.finish();
            }
            if (files != null) {
                this.firePostEvent(files);
                this.firePostAddEvent((IResource)destination);
            }
            subMonitor.done();
        } else {
            tree.standardMoveFile(source, destination, flags, monitor);
        }
        return true;
    }

    private boolean showDialog(IResource source, IResource destination) {
        boolean show = true;
        if (source instanceof IFile) {
            IP4File p4File;
            IP4Resource resource = P4ConnectionManager.getManager().getResource(source);
            show = resource instanceof IP4File ? (p4File = (IP4File)resource).openedForAdd() || !p4File.openedForDelete() && p4File.getHaveRevision() > 0 : false;
        }
        return show;
    }

    protected void firePostEvent(List<IP4File> files) {
        if (!files.isEmpty()) {
            P4Event event = new P4Event(P4Event.EventType.REFRESHED, (IP4Resource[])files.toArray(new IP4File[0]));
            P4Workspace.getWorkspace().notifyListeners(event);
        }
    }

    private void firePostAddEvent(IResource resource) {
        IP4Resource p4resource = P4ConnectionManager.getManager().getResource(resource);
        P4Event event = new P4Event(P4Event.EventType.MOVE_ADDED, p4resource);
        P4Workspace.getWorkspace().notifyListeners(event);
    }

    protected ChangelistSelection getRefactorId(final IResource source, final IResource destination, IProgressMonitor monitor) {
        IP4Connection connection;
        final int[] id = new int[]{this.getActiveId(source)};
        final String[] comment = new String[1];
        final boolean[] canceled = new boolean[1];
        if (id[0] < 0 && this.isEnabled("com.perforce.team.ui.preferences.REFACTOR_DIALOG") && (connection = P4ConnectionManager.getManager().getConnection(source.getProject())) != null && this.showDialog(source, destination)) {
            final boolean[] makeActive = new boolean[1];
            PerforceUIPlugin.syncExec(new Runnable(){

                @Override
                public void run() {
                    RefactorDialog dialog = new RefactorDialog(P4UIUtils.getDialogShell(), source, destination, connection);
                    if (dialog.open() == 0) {
                        id[0] = dialog.getPendingId();
                        comment[0] = dialog.getPendingComment();
                        makeActive[0] = dialog.useSelected();
                    } else {
                        canceled[0] = true;
                    }
                }
            });
            if (id[0] == -2 && comment[0] != null) {
                monitor.setTaskName("Create new pending changelist");
                IP4PendingChangelist newList = connection.createChangelist(comment[0], null);
                if (newList != null) {
                    id[0] = newList.getId();
                }
            }
            if (makeActive[0]) {
                connection.setActivePendingChangelist(id[0]);
            }
        }
        if (canceled[0]) {
            throw new OperationCanceledException("Changelist selection dialog was cancelled.");
        }
        monitor.worked(1);
        boolean explicit = true;
        if (id[0] < 0) {
            id[0] = 0;
            explicit = false;
        }
        return new ChangelistSelection(id[0], explicit);
    }
}

