/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.project;

import com.perforce.p4java.core.IDepot;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.server.GetDirectoriesOptions;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.Policy;
import com.perforce.team.core.Tracing;
import com.perforce.team.core.p4java.ErrorHandler;
import com.perforce.team.core.p4java.IErrorHandler;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Folder;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4BrowsableConnection;
import com.perforce.team.core.p4java.P4Connection;
import com.perforce.team.core.p4java.P4Depot;
import com.perforce.team.core.p4java.builder.P4FileSpecBuilder;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceContentProvider;
import com.perforce.team.ui.PerforceLabelProvider;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.SWTUtils;
import com.perforce.team.ui.connection.BaseConnectionWizardPage;
import com.perforce.team.ui.connection.IConnectionWizard;
import com.perforce.team.ui.project.Messages;
import com.perforce.team.ui.project.P4DepotContainerCheckedTreeViewer;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.progress.UIJob;

public class ImportProjectsWizardPage
extends BaseConnectionWizardPage {
    private Composite displayArea;
    private P4DepotContainerCheckedTreeViewer depotViewer;
    private ListViewer projectsViewer;
    private Label descLabel;
    private Link totalLink;
    private ConnectionParameters params = new ConnectionParameters();
    private Button importButton;
    private IP4Folder[] folders = new IP4Folder[0];
    private boolean importSelected = false;
    private boolean isOptional = false;
    private boolean errorShown = false;
    private boolean selectFromDepotViewer = false;
    private IErrorHandler errorHandler = new ErrorHandler(){

        public boolean shouldRetry(IP4Connection connection, P4JavaException exception) {
            boolean retry = false;
            if (!ImportProjectsWizardPage.this.errorShown) {
                retry = P4ConnectionManager.getManager().displayException(connection, exception, true, false);
                ImportProjectsWizardPage.this.errorShown = !retry;
            }
            return retry;
        }
    };

    public ImportProjectsWizardPage(String pageName, boolean optional) {
        super(pageName);
        this.setTitle(Messages.ImportProjectsWizardPage_ChooseProjectsTitle);
        this.setDescription(Messages.ImportProjectsWizardPage_ChooseProjectsDescription);
        this.setImageDescriptor(PerforceUIPlugin.getPlugin().getImageDescriptor("perforce/import_wizard.png"));
        this.isOptional = optional;
    }

    @Override
    public boolean canFlipToNextPage() {
        return false;
    }

    private void loadConnection() {
        this.params = this.getCurrentParams();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask(MessageFormat.format(Messages.ImportProjectsWizardPage_CreatingConnection, ImportProjectsWizardPage.this.params.getPort()), 4);
                    final P4BrowsableConnection connection = new P4BrowsableConnection(ImportProjectsWizardPage.this.params);
                    connection.setErrorHandler(ImportProjectsWizardPage.this.errorHandler);
                    connection.login(ImportProjectsWizardPage.this.getPassword());
                    if (monitor.isCanceled()) {
                        return;
                    }
                    monitor.worked(1);
                    connection.connect();
                    if (monitor.isCanceled()) {
                        return;
                    }
                    monitor.worked(1);
                    connection.setShowClientOnly(connection.clientExists());
                    connection.setShowFoldersWIthOnlyDeletedFiles(false);
                    if (monitor.isCanceled()) {
                        return;
                    }
                    monitor.worked(1);
                    ImportProjectsWizardPage.this.updateAuthTicket((IP4Connection)connection);
                    PerforceUIPlugin.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (P4UIUtils.okToUse((Viewer)ImportProjectsWizardPage.this.depotViewer)) {
                                ImportProjectsWizardPage.this.depotViewer.setInput(new IP4Container[]{connection});
                            }
                        }
                    });
                    monitor.worked(1);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            PerforceProviderPlugin.logError((Throwable)e);
        }
        catch (InterruptedException e) {
            PerforceProviderPlugin.logError((Throwable)e);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            Object[] checked;
            this.errorShown = false;
            this.loadConnection();
            ArrayList<IP4Folder> current = new ArrayList<IP4Folder>();
            Object[] objectArray = checked = this.depotViewer.getCheckedElements();
            int n = checked.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof IP4Folder) {
                    current.add((IP4Folder)obj);
                }
                ++n2;
            }
            this.validateStreamDirectories(current.toArray(new IP4Folder[0]));
        }
        super.setVisible(visible);
    }

    public boolean isImportSelected() {
        return this.importSelected;
    }

    public IP4Folder[] getImportedFolders() {
        return this.folders;
    }

    public void createControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        this.displayArea.setLayout((Layout)new GridLayout(2, false));
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.importSelected = true;
        if (this.isOptional) {
            this.importButton = new Button(this.displayArea, 32);
            this.importButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
            this.importButton.setSelection(true);
            this.importButton.setText(Messages.ImportProjectsWizardPage_ImportExistingDepotFolders);
            this.importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean importing = ImportProjectsWizardPage.this.importButton.getSelection();
                    ImportProjectsWizardPage.this.depotViewer.getTree().setEnabled(importing);
                    if (!importing) {
                        ImportProjectsWizardPage.this.depotViewer.setSubtreeChecked(ImportProjectsWizardPage.this.depotViewer.getTree().getData(), false);
                    }
                    ImportProjectsWizardPage.this.importSelected = importing;
                }
            });
        }
        SashForm sash = new SashForm(this.displayArea, 256);
        sash.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Composite left = new Composite((Composite)sash, 0);
        left.setLayout((Layout)new GridLayout());
        Composite right = new Composite((Composite)sash, 0);
        right.setLayout((Layout)new GridLayout(2, false));
        SWTUtils.createLabel(left, Messages.ImportProjectsWizardPage_RemoteFolders);
        SWTUtils.createLabel(right, Messages.ImportProjectsWizardPage_EclipseProjectFolders);
        this.totalLink = new Link(right, 8);
        this.totalLink.setEnabled(true);
        this.totalLink.setText("0");
        this.depotViewer = new P4DepotContainerCheckedTreeViewer(left, 2820);
        this.depotViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.depotViewer.setAutoExpandLevel(2);
        PerforceContentProvider provider = new PerforceContentProvider((StructuredViewer)this.depotViewer);
        provider.setLoadAsync(false);
        this.depotViewer.setContentProvider((IContentProvider)provider);
        this.depotViewer.setLabelProvider((IBaseLabelProvider)new PerforceLabelProvider());
        this.depotViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(final CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (!(element instanceof IP4Folder) && event.getChecked()) {
                    if (element instanceof P4Depot) {
                        IDepot.DepotType depotType = ((P4Depot)element).getType();
                        if (depotType != IDepot.DepotType.LOCAL && depotType != IDepot.DepotType.STREAM) {
                            ImportProjectsWizardPage.this.depotViewer.setChecked(element, false);
                        }
                    } else {
                        ImportProjectsWizardPage.this.depotViewer.setChecked(element, false);
                    }
                }
                ImportProjectsWizardPage.this.depotViewer.removeChildOnlyNode(element);
                Tracing.printTrace((String)"ImportProjects", (String)MessageFormat.format("removeChildOnlyNode {0}, childOnlySet={1}", element, ImportProjectsWizardPage.this.depotViewer.getChildOnlySet()));
                Tracing.printExecTime((boolean)Policy.DEBUG, (String)"ImportProjects", (String)"TREE: collect children", (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ImportProjectsWizardPage.this.updateSelectedFolders(event.getElement());
                    }
                });
                ImportProjectsWizardPage.this.validateStreamDirectories(ImportProjectsWizardPage.this.folders);
            }
        });
        this.depotViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IP4File) {
                    IP4File resource = (IP4File)element;
                    if (resource.getConnection() instanceof P4BrowsableConnection) {
                        return !resource.isHeadActionDelete();
                    }
                    return resource.getLocalPath() != null;
                }
                if (element instanceof P4Depot) {
                    return ((P4Depot)element).isLocal();
                }
                return true;
            }
        });
        this.depotViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj = SWTUtils.getSingleSelectedObject((Viewer)ImportProjectsWizardPage.this.depotViewer);
                if (obj != null && ImportProjectsWizardPage.this.depotViewer.getChecked(obj) && !ImportProjectsWizardPage.this.depotViewer.getGrayed(obj)) {
                    ImportProjectsWizardPage.this.selectFromDepotViewer = true;
                    ImportProjectsWizardPage.this.projectsViewer.setSelection(event.getSelection(), true);
                    ImportProjectsWizardPage.this.selectFromDepotViewer = false;
                }
            }
        });
        this.setDepotViewerMenu();
        this.projectsViewer = new ListViewer(right, 768);
        this.projectsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.projectsViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.projectsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!ImportProjectsWizardPage.this.selectFromDepotViewer) {
                    ImportProjectsWizardPage.this.depotViewer.setSelection(event.getSelection(), true);
                }
            }
        });
        this.descLabel = new Label(this.displayArea, 64);
        this.descLabel.setText(Messages.ImportProjectsWizardPage_ImportProjectsHelpMessage);
        this.descLabel.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 2, 1));
        this.setControl((Control)this.displayArea);
        if (!this.isOptional) {
            this.setPageComplete(false);
        }
    }

    private void setDepotViewerMenu() {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)new Action(Messages.ImportProjectsWizardPage_ImportSubFoldersAsProjects){

                    public boolean isEnabled() {
                        Object sel = SWTUtils.getSingleSelectedObject((Viewer)ImportProjectsWizardPage.this.depotViewer);
                        if (sel instanceof IP4Container) {
                            if (ImportProjectsWizardPage.this.depotViewer.getExpandedState(sel)) {
                                return super.isEnabled() && this.hasSubfolders((IP4Container)sel);
                            }
                            return super.isEnabled();
                        }
                        return false;
                    }

                    private boolean hasSubfolders(IP4Container container) {
                        IP4Resource[] iP4ResourceArray = container.members();
                        int n = iP4ResourceArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IP4Resource res = iP4ResourceArray[n2];
                            if (res instanceof IP4Container) {
                                return true;
                            }
                            ++n2;
                        }
                        return false;
                    }

                    public void run() {
                        final Object sel = SWTUtils.getSingleSelectedObject((Viewer)ImportProjectsWizardPage.this.depotViewer);
                        if (sel instanceof IP4Container) {
                            boolean expanded = ImportProjectsWizardPage.this.depotViewer.getExpandedState(sel);
                            boolean checked = ImportProjectsWizardPage.this.depotViewer.getChecked(sel);
                            boolean grayed = ImportProjectsWizardPage.this.depotViewer.getGrayed(sel);
                            if (!expanded) {
                                Tracing.printExecTime((boolean)Policy.DEBUG, (String)"ImortProjects", (String)MessageFormat.format("expandCollapseNode {0}", sel), (Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        ImportProjectsWizardPage.this.depotViewer.setExpandedState(sel, true);
                                    }
                                });
                            }
                            if (this.hasSubfolders((IP4Container)sel)) {
                                ImportProjectsWizardPage.this.depotViewer.addChildOnlyNode(sel);
                                Tracing.printTrace((String)"ImportProjects", (String)MessageFormat.format("addChildOnlyNode {0}, childOnlySet={1}", sel, ImportProjectsWizardPage.this.depotViewer.getChildOnlySet()));
                                if (!checked) {
                                    ImportProjectsWizardPage.this.depotViewer.setChecked(sel, true);
                                }
                                if (!grayed) {
                                    ImportProjectsWizardPage.this.depotViewer.setGrayed(sel, true);
                                }
                                ImportProjectsWizardPage.this.updateSelectedFolders(sel);
                                ImportProjectsWizardPage.this.validateStreamDirectories(ImportProjectsWizardPage.this.folders);
                            } else {
                                MessageDialog.openWarning((Shell)ImportProjectsWizardPage.this.depotViewer.getTree().getShell(), (String)Messages.ImportProjectsWizardPage_InvalidOperation, (String)Messages.ImportProjectsWizardPage_NoSubFolderAvailableError);
                            }
                        }
                    }
                });
            }
        });
        Menu menu = contextMenu.createContextMenu(this.depotViewer.getControl());
        this.depotViewer.getControl().setMenu(menu);
    }

    protected void updateSelectedFolders(Object sel) {
        ArrayList<IP4Folder> result = new ArrayList<IP4Folder>();
        Tree tree = this.depotViewer.getTree();
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.collectChildren(item, result);
            ++n2;
        }
        this.folders = result.toArray(new IP4Folder[0]);
        this.totalLink.setText(String.valueOf(this.folders.length));
        this.totalLink.getParent().layout();
        this.projectsViewer.setInput((Object)this.folders);
        this.projectsViewer.setSelection((ISelection)new StructuredSelection(sel));
        Tracing.printTrace((String)"ImportProjects", (String)("\n\nSELECTED:" + Arrays.toString(this.folders)));
    }

    private void collectChildren(TreeItem item, List<IP4Folder> result) {
        block7: {
            block8: {
                Object element;
                block10: {
                    block9: {
                        if (!item.getChecked()) break block7;
                        if (item.getGrayed()) break block8;
                        element = item.getData();
                        if (!(element instanceof IP4Folder)) break block9;
                        result.add((IP4Folder)element);
                        break block7;
                    }
                    if (!(element instanceof P4Depot)) break block10;
                    P4Depot depot = (P4Depot)element;
                    if (depot.needsRefresh()) {
                        depot.refresh();
                        IP4Resource[] iP4ResourceArray = depot.members();
                        int n = iP4ResourceArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IP4Resource res = iP4ResourceArray[n2];
                            if (res instanceof IP4Folder) {
                                result.add((IP4Folder)res);
                            }
                            ++n2;
                        }
                    } else {
                        TreeItem[] treeItemArray = item.getItems();
                        int n = treeItemArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            TreeItem subItem = treeItemArray[n3];
                            this.collectChildren(subItem, result);
                            ++n3;
                        }
                    }
                    break block7;
                }
                if (!(element instanceof P4Connection)) break block7;
                TreeItem[] treeItemArray = item.getItems();
                int n = treeItemArray.length;
                int n4 = 0;
                while (n4 < n) {
                    TreeItem subItem = treeItemArray[n4];
                    this.collectChildren(subItem, result);
                    ++n4;
                }
                break block7;
            }
            TreeItem[] treeItemArray = item.getItems();
            int n = treeItemArray.length;
            int n5 = 0;
            while (n5 < n) {
                TreeItem subItem = treeItemArray[n5];
                this.collectChildren(subItem, result);
                ++n5;
            }
        }
    }

    protected void validateStreamDirectories(final IP4Folder[] folders) {
        if (!this.isOptional) {
            this.setPageComplete(folders.length > 0);
            if (folders.length > 0) {
                this.setPageComplete(true);
                this.setErrorMessage(null);
            } else {
                this.setPageComplete(false);
                this.setErrorMessage(Messages.ImportProjectsWizardPage_SelectAtLeastOneFolder);
            }
        } else {
            final String stream = ((IConnectionWizard)this.getWizard()).getStream();
            try {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        if (monitor == null) {
                            monitor = new NullProgressMonitor();
                        }
                        monitor.beginTask(Messages.ImportProjectsWizardPage_ValidatingFolders, folders.length);
                        final ArrayList<IP4Folder> invalidFolders = new ArrayList<IP4Folder>();
                        IP4Folder[] iP4FolderArray = folders;
                        int n = folders.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IP4Folder folder = iP4FolderArray[n2];
                            IOptionsServer server = (IOptionsServer)folder.getConnection().getServer();
                            String dir = folder.getRemotePath();
                            try {
                                GetDirectoriesOptions options = new GetDirectoriesOptions();
                                if (StringUtils.isEmpty((CharSequence)stream)) break;
                                options.setStream(stream);
                                List fileSpecs = server.getDirectories(P4FileSpecBuilder.makeFileSpecList((String)dir), options);
                                if (fileSpecs == null || fileSpecs.size() == 0) {
                                    invalidFolders.add(folder);
                                }
                            }
                            catch (P4JavaException e) {
                                e.printStackTrace();
                            }
                            monitor.worked(1);
                            if (monitor.isCanceled()) break;
                            ++n2;
                        }
                        monitor.done();
                        UIJob job = new UIJob(Messages.ImportProjectsWizardPage_UpdateStatus){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                if (invalidFolders.size() == 0) {
                                    ImportProjectsWizardPage.this.setPageComplete(true);
                                    ImportProjectsWizardPage.this.setErrorMessage(null);
                                } else {
                                    StringBuilder sb = new StringBuilder();
                                    for (IP4Folder folder : invalidFolders) {
                                        sb.append(String.valueOf(folder.getRemotePath()) + ", ");
                                    }
                                    sb.deleteCharAt(sb.length() - 1);
                                    sb.deleteCharAt(sb.length() - 1);
                                    ImportProjectsWizardPage.this.setPageComplete(false);
                                    ImportProjectsWizardPage.this.setErrorMessage(MessageFormat.format(Messages.ImportProjectsWizardPage_FoldersNotInClientView, sb.toString()));
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        job.schedule();
                    }
                });
            }
            catch (InvocationTargetException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
            catch (InterruptedException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
    }
}

