/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.preferences;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.dialogs.DialogUtils;
import com.perforce.team.ui.dialogs.PerforcePreferencesDialog;
import com.perforce.team.ui.preferences.Messages;
import java.text.MessageFormat;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class RetrievePreferencePage
extends PerforcePreferencesDialog {
    protected Button allElementsRadio;
    protected Button maxElementsRadio;
    protected Text maxElementsText;
    private boolean warningShown = false;

    public RetrievePreferencePage(int numColumns) {
        super(numColumns);
    }

    protected abstract String getRetrievePref();

    protected abstract String getName();

    @Override
    public boolean performOk() {
        int num = this.allElementsRadio.getSelection() ? -1 : Integer.parseInt(this.maxElementsText.getText().trim());
        this.setPrefInt(this.getRetrievePref(), num);
        return true;
    }

    @Override
    protected void performDefaults() {
        this.initValues(this.getPrefDefInt(this.getRetrievePref()));
    }

    protected Composite createRetrieveArea(Composite parent) {
        Group group = DialogUtils.createGroup(parent, MessageFormat.format(Messages.RetrievePreferencePage_WhenRetrieving, this.getName()), 1);
        int buttonStyle = P4CoreUtils.isWindows() ? 524288 : 0;
        this.allElementsRadio = DialogUtils.createRadio((Composite)group, buttonStyle, MessageFormat.format(Messages.RetrievePreferencePage_RetrieveAllFromServer, this.getName()));
        this.allElementsRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!RetrievePreferencePage.this.warningShown) {
                    P4ConnectionManager.getManager().openWarning(RetrievePreferencePage.this.allElementsRadio.getShell(), MessageFormat.format(Messages.RetrievePreferencePage_RetrieveAllWarningTitle, RetrievePreferencePage.this.getName()), MessageFormat.format(Messages.RetrievePreferencePage_RetrieveAllWarningMessage, RetrievePreferencePage.this.getName()));
                    RetrievePreferencePage.this.warningShown = true;
                }
            }
        });
        Composite row = new Composite((Composite)group, 0);
        row.setLayoutData((Object)new GridData());
        RowLayout layout = new RowLayout(256);
        layout.marginLeft = 0;
        row.setLayout((Layout)layout);
        this.maxElementsRadio = new Button(row, 0x10 | buttonStyle);
        this.maxElementsRadio.setText(Messages.RetrievePreferencePage_RetrieveMaxOf);
        this.maxElementsRadio.setLayoutData((Object)new RowData());
        this.maxElementsText = new Text(row, 2052);
        RowData data = new RowData();
        data.width = 50;
        this.maxElementsText.setLayoutData((Object)data);
        Label label = new Label(row, 16384);
        label.setText(MessageFormat.format(Messages.RetrievePreferencePage_NumFromServer, this.getName()));
        this.allElementsRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetrievePreferencePage.this.maxElementsRadio.setSelection(false);
                RetrievePreferencePage.this.maxElementsText.setEnabled(false);
                RetrievePreferencePage.this.setValid(true);
            }
        });
        this.maxElementsRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RetrievePreferencePage.this.allElementsRadio.setSelection(false);
                RetrievePreferencePage.this.maxElementsText.setEnabled(true);
            }
        });
        this.maxElementsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                try {
                    int num = Integer.parseInt(RetrievePreferencePage.this.maxElementsText.getText().trim());
                    if (num > 0) {
                        RetrievePreferencePage.this.setValid(true);
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                RetrievePreferencePage.this.setValid(false);
            }
        });
        this.initValues(this.getPrefInt(this.getRetrievePref()));
        return group;
    }

    private void initValues(int num) {
        if (num < 0) {
            this.maxElementsRadio.setSelection(false);
            this.allElementsRadio.setSelection(true);
            this.maxElementsText.setText("100");
            this.maxElementsText.setEnabled(false);
        } else {
            this.allElementsRadio.setSelection(false);
            this.maxElementsRadio.setSelection(true);
            this.maxElementsText.setText(Integer.toString(num));
            this.maxElementsText.setEnabled(true);
        }
    }

    public void selectAllElements() {
        if (this.allElementsRadio != null && !this.allElementsRadio.isDisposed()) {
            this.allElementsRadio.setSelection(true);
            this.maxElementsRadio.setSelection(false);
            this.maxElementsText.setEnabled(false);
        }
    }

    public void setMaxElements(String maxElements) {
        if (maxElements != null && this.maxElementsText != null && !this.maxElementsText.isDisposed()) {
            this.maxElementsText.setText(maxElements);
        }
    }

    public void selectMaxElements() {
        if (this.maxElementsRadio != null && !this.maxElementsRadio.isDisposed()) {
            this.maxElementsRadio.setSelection(true);
            this.allElementsRadio.setSelection(false);
            this.maxElementsText.setEnabled(true);
        }
    }
}

