/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4merge;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.ui.p4java.actions.P4Action;
import com.perforce.team.ui.p4merge.DiffRunner;
import com.perforce.team.ui.p4merge.Messages;
import java.util.ArrayList;

public class P4MergeDiffAction
extends P4Action {
    @Override
    protected void runAction() {
        this.runApplication();
    }

    public DiffRunner[] runApplication() {
        P4Collection collection = super.getDirectFileSelection();
        ArrayList<DiffRunner> runners = new ArrayList<DiffRunner>();
        if (!collection.isEmpty()) {
            IP4Resource[] resources;
            IP4Resource[] iP4ResourceArray = resources = collection.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource = iP4ResourceArray[n2];
                IP4File file = (IP4File)resource;
                file.refresh();
                if (file.getHeadRevision() > 0) {
                    String depotPath = file.getRemotePath();
                    depotPath = String.valueOf(depotPath) + "#" + file.getHeadRevision();
                    String localPath = file.getLocalPath();
                    DiffRunner runner = new DiffRunner(file.getConnection(), true, false, depotPath, depotPath, String.valueOf(localPath) + Messages.P4MergeDiffAction_WorkspaceFile, localPath);
                    runner.run();
                    runners.add(runner);
                }
                ++n2;
            }
        }
        return runners.toArray(new DiffRunner[0]);
    }

    public DiffRunner[] diffAgainstPrevious() {
        P4Collection collection = super.getDirectFileSelection();
        ArrayList<DiffRunner> runners = new ArrayList<DiffRunner>();
        if (!collection.isEmpty()) {
            IP4Resource[] resources;
            IP4Resource[] iP4ResourceArray = resources = collection.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource = iP4ResourceArray[n2];
                IP4File file = (IP4File)resource;
                file.refresh();
                if (file.getHeadRevision() > 1) {
                    String depotPath = file.getRemotePath();
                    depotPath = String.valueOf(depotPath) + "#" + (file.getHeadRevision() - 1);
                    String depotPath2 = file.getRemotePath();
                    depotPath2 = String.valueOf(depotPath2) + "#" + file.getHeadRevision();
                    DiffRunner runner = new DiffRunner(file.getConnection(), true, true, depotPath, depotPath, depotPath2, depotPath2);
                    runner.run();
                    runners.add(runner);
                }
                ++n2;
            }
        }
        return runners.toArray(new DiffRunner[0]);
    }

    @Override
    public boolean isEnabledEx() {
        P4Collection collection;
        IP4Resource[] resources;
        int size;
        boolean enabled = false;
        if (this.containsOnlineConnection() && (size = (resources = (collection = super.getDirectFileSelection()).members()).length) > 0) {
            IP4Resource[] iP4ResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IP4File file;
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource instanceof IP4File && (file = (IP4File)resource).getAction() != null) {
                    enabled = true;
                    break;
                }
                ++n2;
            }
        }
        return enabled;
    }
}

