/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4merge;

import com.perforce.p4java.server.PerforceCharsets;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.p4merge.Messages;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.progress.UIJob;

public abstract class ApplicationRunner {
    protected Process currentProcess = null;
    protected boolean async = true;

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    protected IPreferenceStore getPreferenceStore() {
        return PerforceUIPlugin.getPlugin().getPreferenceStore();
    }

    protected String getPreferenceValue() {
        return this.getPreferenceStore().getString(this.getPreference());
    }

    protected abstract String getPreference();

    protected abstract boolean loadFiles();

    protected abstract ProcessBuilder getBuilder();

    protected abstract void applicationFinished(int var1);

    protected abstract IP4Connection getConnection();

    public Process getProcess() {
        return this.currentProcess;
    }

    public void run() {
        String path = this.getPreferenceValue();
        if ("".equals(path)) {
            PerforceUIPlugin.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (P4ConnectionManager.getManager().openQuestion(P4UIUtils.getShell(), MessageFormat.format(Messages.ApplicationRunner_ConfigureAppTitle, ApplicationRunner.this.getApplicationName()), MessageFormat.format(Messages.ApplicationRunner_ConfigureAppMessage, ApplicationRunner.this.getApplicationName()))) {
                        P4UIUtils.openPreferencePage("com.perforce.team.ui.preferences.ExternalToolsPreferencePage");
                    }
                }
            });
        }
        if (!"".equals(path = this.getPreferenceValue())) {
            P4Runnable runnable = new P4Runnable(){

                public void run(final IProgressMonitor monitor) {
                    if (ApplicationRunner.this.loadFiles()) {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        final ProcessBuilder builder = ApplicationRunner.this.getBuilder();
                        final IOException[] exceptions = new IOException[1];
                        final boolean[] done = new boolean[1];
                        String task = ApplicationRunner.this.getTaskName();
                        if (task != null) {
                            monitor.beginTask(task, 1);
                        }
                        Thread thread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    try {
                                        (this).ApplicationRunner.this.currentProcess = builder.start();
                                        int rc = (this).ApplicationRunner.this.currentProcess.waitFor();
                                        if (!monitor.isCanceled()) {
                                            ApplicationRunner.this.applicationFinished(rc);
                                        }
                                    }
                                    catch (IOException e) {
                                        exceptions[0] = e;
                                        done[0] = true;
                                    }
                                    catch (InterruptedException e) {
                                        PerforceProviderPlugin.logError((Throwable)e);
                                        done[0] = true;
                                    }
                                }
                                finally {
                                    done[0] = true;
                                }
                            }
                        });
                        thread.start();
                        while (!done[0] && thread.isAlive()) {
                            if (monitor.isCanceled()) {
                                done[0] = true;
                                if (ApplicationRunner.this.currentProcess != null) {
                                    ApplicationRunner.this.currentProcess.destroy();
                                }
                            }
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        monitor.worked(1);
                        monitor.done();
                        if (exceptions[0] != null) {
                            UIJob job = new UIJob(MessageFormat.format(Messages.ApplicationRunner_DisplayAppError, ApplicationRunner.this.getApplicationName())){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    P4ConnectionManager.getManager().openError(P4UIUtils.getShell(), MessageFormat.format(Messages.ApplicationRunner_ErrorExecutingAppTitle, ApplicationRunner.this.getApplicationName()), MessageFormat.format(Messages.ApplicationRunner_ErrorExecutingAppMessage, ApplicationRunner.this.getApplicationName()));
                                    return Status.OK_STATUS;
                                }
                            };
                            job.schedule();
                        }
                    }
                }

                public String getTitle() {
                    return MessageFormat.format(Messages.ApplicationRunner_RunningApp, ApplicationRunner.this.getApplicationName());
                }
            };
            if (this.isAsync()) {
                P4Runner.schedule((IP4Runnable)runnable);
            } else {
                runnable.run((IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    protected abstract String getApplicationName();

    protected String getTaskName() {
        return null;
    }

    protected boolean shouldConvertExec() {
        return P4CoreUtils.isWindows() && !this.getConnection().getParameters().getCharset().equals("none") && PerforceCharsets.isSupported((String)this.getConnection().getParameters().getCharset());
    }

    protected void convertExec(List<String> arguments) {
        block15: {
            OutputStreamWriter writer = null;
            try {
                try {
                    File tempBatch = File.createTempFile("p4eclipse_win_exec", ".bat");
                    tempBatch.deleteOnExit();
                    writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tempBatch), "UTF-8");
                    writer.write("@echo off \r\n");
                    writer.write("chcp 1252 \r\n");
                    for (String arg : arguments) {
                        if (arg.indexOf(32) == -1) {
                            writer.write(arg);
                        } else {
                            writer.write(34);
                            writer.write(arg);
                            writer.write(34);
                        }
                        writer.write(94);
                        writer.write(13);
                        writer.write(10);
                        writer.write(32);
                    }
                    writer.flush();
                    arguments.clear();
                    arguments.add(tempBatch.getAbsolutePath());
                }
                catch (IOException e) {
                    PerforceProviderPlugin.logError((Throwable)e);
                    if (writer == null) break block15;
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        PerforceProviderPlugin.logError((Throwable)e2);
                    }
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        PerforceProviderPlugin.logError((Throwable)e);
                    }
                }
            }
        }
    }
}

