/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.team.ui.p4java.dialogs.IntegrateToStreamDialog;
import com.perforce.team.ui.p4java.dialogs.Messages;
import com.perforce.team.ui.p4java.dialogs.VersionComboViewer;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RevisionUptoWidget
extends Composite
implements IntegrateToStreamDialog.IRevisionRangeWidget {
    private Button endButton;
    private VersionComboViewer endCombo;
    private Text endText;
    private Label endHelp;
    private String endOption = null;

    public RevisionUptoWidget(Composite parent, int style, String title) {
        super(parent, style);
        this.createControl(this, title);
        this.init();
        this.addListeners();
    }

    private void init() {
        boolean enableEnd = true;
        if (this.endOption == null) {
            enableEnd = false;
        }
        this.endButton.setSelection(enableEnd);
        this.endCombo.setEnabled(enableEnd);
        this.endText.setEnabled(enableEnd);
        this.endHelp.setVisible(enableEnd);
    }

    private void addListeners() {
        this.endButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = RevisionUptoWidget.this.endButton.getSelection();
                RevisionUptoWidget.this.endCombo.setEnabled(enabled);
                RevisionUptoWidget.this.endText.setEnabled(enabled);
                RevisionUptoWidget.this.endHelp.setVisible(enabled);
                if (!enabled) {
                    RevisionUptoWidget.this.endOption = null;
                }
            }
        });
        this.endCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RevisionUptoWidget.this.endOption = String.valueOf(RevisionUptoWidget.this.getPrefix(RevisionUptoWidget.this.endCombo)) + RevisionUptoWidget.this.endText.getText();
            }
        });
        this.endText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RevisionUptoWidget.this.endOption = String.valueOf(RevisionUptoWidget.this.getPrefix(RevisionUptoWidget.this.endCombo)) + RevisionUptoWidget.this.endText.getText();
            }
        });
    }

    private void createControl(Composite parent, String title) {
        parent.setLayout((Layout)new FillLayout());
        Group limitArea = new Group(parent, 0);
        limitArea.setText(title);
        GridLayout laLayout = new GridLayout(4, false);
        limitArea.setLayout((Layout)laLayout);
        this.endButton = new Button((Composite)limitArea, 32);
        this.endButton.setText(Messages.RevisionUptoWidget_RevisionUpto);
        this.endCombo = new VersionComboViewer((Composite)limitArea, 8);
        this.endCombo.setEnabled(false);
        this.endText = new Text((Composite)limitArea, 2052);
        this.endText.setEnabled(false);
        GridDataFactory.swtDefaults().hint(50, -1).align(4, 0x1000000).grab(true, false).applyTo((Control)this.endText);
        this.endHelp = new Label((Composite)limitArea, 16384);
        this.endHelp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addComboListener(this.endCombo, this.endHelp);
        this.endHelp.setText(Messages.RevisionUptoWidget_SelectVersionTypeAndInputVersion);
    }

    private void addComboListener(final VersionComboViewer combo, final Label help) {
        combo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                VersionComboViewer.VersionType type = combo.getSelectedObject();
                if (type == VersionComboViewer.VersionType.Revision) {
                    help.setText(Messages.IntegrateDialog_EnterRevisionNumber);
                } else if (type == VersionComboViewer.VersionType.ChangeList) {
                    help.setText(Messages.IntegrateDialog_EnterChangelistNumber);
                } else if (type == VersionComboViewer.VersionType.Label) {
                    help.setText(Messages.IntegrateDialog_EnterLabel);
                } else {
                    help.setText(Messages.RevisionUptoWidget_SelectVersionTypeAndInputVersion);
                }
                help.setVisible(true);
                help.getParent().layout(true);
            }
        });
    }

    private String getPrefix(VersionComboViewer combo) {
        VersionComboViewer.VersionType type = combo.getSelectedObject();
        if (type != null) {
            return type.getPrefix();
        }
        return "";
    }

    @Override
    public IStatus validate() {
        boolean hasEnd = this.endButton.getSelection();
        if (hasEnd) {
            if (this.endCombo.getSelectedObject() == null) {
                return ValidationStatus.error((String)Messages.RevisionUptoWidget_VersionTypeNotSetError);
            }
            if (StringUtils.isEmpty((CharSequence)this.endText.getText())) {
                return ValidationStatus.error((String)Messages.RevisionUptoWidget_VersionNotSetError);
            }
        }
        return ValidationStatus.ok();
    }

    @Override
    public String getStart() {
        return null;
    }

    @Override
    public String getEnd() {
        return this.endOption;
    }

    @Override
    public Composite getControl() {
        return this;
    }
}

