/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.p4java.option.client.ResolveFilesAutoOptions;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.p4java.dialogs.IResolveControlContainer;
import com.perforce.team.ui.p4java.dialogs.Messages;
import com.perforce.team.ui.p4java.dialogs.ResolveWizard;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.UIJob;

public class ResolveAutoControl
extends Composite {
    private IResolveControlContainer container;
    private Button acceptSourceButton;
    private Button acceptTargetButton;
    private Button mergeSafeButton;
    private Button mergeNoConflictsButton;
    private Button mergeWithConflictsButton;
    private CheckboxTableViewer resolveTable;
    private Button resolveButton;
    private Button binaryMerge;
    private Button selectButton;
    private int numResolveOperations = 0;
    private int numResolveItems = 0;
    private int changeId;
    private IP4Connection conn;

    public ResolveAutoControl(Composite parent, int style, IResolveControlContainer container) {
        super(parent, style);
        this.container = container;
        this.createControl();
    }

    public ResolveAutoControl(Composite parent, int style, IResolveControlContainer container, int changeId, IP4Connection conn) {
        super(parent, style);
        this.changeId = changeId;
        this.container = container;
        this.conn = conn;
        this.createControl();
    }

    public void init() {
        this.resolveTable.setInput((Object)this.container.getResolveWizard().unresolved);
        this.resolveTable.setAllChecked(true);
    }

    private void createControl() {
        this.setLayout((Layout)new GridLayout(1, false));
        this.createFilesGroup(this);
        this.createMiddleGroup(this);
        this.createOptionsGroup(this);
        this.createResolveButton(this);
        this.setDefaultSelections();
    }

    private void createFilesGroup(Composite parent) {
        final Composite buttons = new Composite(parent, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label(buttons, 0);
        label.setText(Messages.ResolveWizardAutoPage_FilesToResolve);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        final Menu menu = new Menu((Decorations)parent.getShell(), 8);
        MenuItem item = new MenuItem(menu, 8);
        item.setText(Messages.ResolveWizardAutoPage_None);
        item.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ResolveAutoControl.this.resolveTable.setAllChecked(false);
            }
        });
        item = new MenuItem(menu, 8);
        item.setText(Messages.ResolveWizardAutoPage_All);
        item.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ResolveAutoControl.this.resolveTable.setAllChecked(true);
            }
        });
        item = new MenuItem(menu, 8);
        item.setText(Messages.ResolveWizardAutoPage_BinaryFiles);
        item.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ResolveAutoControl.this.selectAllWithFileType("binary");
            }
        });
        item = new MenuItem(menu, 8);
        item.setText(Messages.ResolveWizardAutoPage_TextFiles);
        item.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ResolveAutoControl.this.selectAllWithFileType("text");
            }
        });
        item = new MenuItem(menu, 8);
        item.setText(Messages.ResolveWizardAutoPage_ContentResolves);
        item.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ResolveAutoControl.this.selectAllWithResolveType("content");
            }
        });
        item = new MenuItem(menu, 8);
        item.setText(Messages.ResolveWizardAutoPage_MoveResolves);
        item.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ResolveAutoControl.this.selectAllWithResolveType("move");
            }
        });
        item = new MenuItem(menu, 8);
        item.setText(Messages.ResolveWizardAutoPage_FiletypeResolves);
        item.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ResolveAutoControl.this.selectAllWithResolveType("filetype");
            }
        });
        item = new MenuItem(menu, 8);
        item.setText(Messages.ResolveWizardAutoPage_DeleteResolves);
        item.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ResolveAutoControl.this.selectAllWithResolveType("delete");
            }
        });
        item = new MenuItem(menu, 8);
        item.setText(Messages.ResolveWizardAutoPage_BranchResolves);
        item.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ResolveAutoControl.this.selectAllWithResolveType("branch");
            }
        });
        item = new MenuItem(menu, 8);
        item.setText(Messages.ResolveWizardAutoPage_AttributeResolves);
        item.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ResolveAutoControl.this.selectAllWithResolveType("attributes");
            }
        });
        this.selectButton = new Button(buttons, 8);
        this.selectButton.setImage(PerforceUIPlugin.getDescriptor("perforce/filter_icon_menu.png").createImage());
        this.selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Rectangle rect = ResolveAutoControl.this.selectButton.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = buttons.toDisplay(pt);
                menu.setLocation(pt.x, pt.y);
                menu.setVisible(true);
                while (!menu.isDisposed() && menu.isVisible()) {
                    if (menu.getDisplay().readAndDispatch()) continue;
                    menu.getDisplay().sleep();
                }
            }
        });
        this.createViewer(parent);
    }

    private void createMiddleGroup(Composite parent) {
        this.binaryMerge = new Button(parent, 32);
        this.binaryMerge.setText(Messages.ResolveWizardAutoPage_MergeBinary);
        this.binaryMerge.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    private void createResolveButton(Composite parent) {
        this.resolveButton = new Button(parent, 8);
        this.resolveButton.setText(Messages.ResolveWizardAutoPage_ResolveSelected);
        this.resolveButton.setLayoutData((Object)new GridData(131072, 1, false, false));
        this.resolveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResolveAutoControl.this.runResolve();
            }
        });
    }

    void createOptionsGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.ResolveWizardAutoPage_ResolveOptions);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite autoResolveChoices = new Composite((Composite)group, 0);
        autoResolveChoices.setLayout((Layout)new GridLayout(1, true));
        autoResolveChoices.setLayoutData((Object)new GridData(4, 4, true, false));
        this.acceptSourceButton = new Button(autoResolveChoices, 16);
        this.acceptSourceButton.setText(Messages.ResolveWizardAutoPage_AcceptSource);
        this.acceptTargetButton = new Button(autoResolveChoices, 145);
        this.acceptTargetButton.setText(Messages.ResolveWizardAutoPage_AcceptTarget);
        this.mergeSafeButton = new Button(autoResolveChoices, 16);
        this.mergeSafeButton.setText(Messages.ResolveWizardAutoPage_SafeAutoResolve);
        this.mergeNoConflictsButton = new Button(autoResolveChoices, 16);
        this.mergeNoConflictsButton.setText(Messages.ResolveWizardAutoPage_AllowMergeNoConflicts);
        this.mergeWithConflictsButton = new Button(autoResolveChoices, 16);
        this.mergeWithConflictsButton.setText(Messages.ResolveWizardAutoPage_AllowMergeWithConflicts);
    }

    private void setDefaultSelections() {
        IPreferenceStore store = PerforceUIPlugin.getPlugin().getPreferenceStore();
        String action = store.getString("pref_resolve_default_action");
        if (action.equals("accept_source")) {
            this.acceptSourceButton.setSelection(true);
        } else if (action.equals("accept_target")) {
            this.acceptTargetButton.setSelection(true);
        } else if (action.equals("accept_merge_safe")) {
            this.mergeSafeButton.setSelection(true);
        } else if (action.equals("accept_merge_no_conflicts")) {
            this.mergeNoConflictsButton.setSelection(true);
        } else if (action.equals("accept_merge_with_conflicts")) {
            this.mergeWithConflictsButton.setSelection(true);
        }
        this.binaryMerge.setSelection(store.getBoolean("pref_resolve_merge_binary_as_text"));
    }

    ResolveFilesAutoOptions getAutoOption() {
        ResolveFilesAutoOptions options = new ResolveFilesAutoOptions();
        if (this.mergeSafeButton.getSelection()) {
            options.setSafeMerge(true);
        } else if (this.acceptSourceButton.getSelection()) {
            options.setAcceptTheirs(true);
        } else if (this.acceptTargetButton.getSelection()) {
            options.setAcceptYours(true);
        } else if (!this.mergeNoConflictsButton.getSelection() && this.mergeWithConflictsButton.getSelection()) {
            options.setForceResolve(true);
        }
        if (this.binaryMerge.getSelection()) {
            options.setForceTextualMerge(true);
        }
        return options;
    }

    private void createViewer(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 160;
        comp.setLayoutData((Object)data);
        TableColumnLayout layout = new TableColumnLayout();
        comp.setLayout((Layout)layout);
        this.resolveTable = CheckboxTableViewer.newCheckList((Composite)comp, (int)67588);
        Table table = this.resolveTable.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createColumns(comp, (TableViewer)this.resolveTable, layout);
        this.resolveTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.resolveTable.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ResolveAutoControl.this.validate();
            }
        });
    }

    private void createColumns(Composite parent, TableViewer viewer, TableColumnLayout layout) {
        TableViewerColumn col = this.createTableViewerColumn(Messages.ResolveWizardAutoPage_Resolve, 50, layout);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ResolveWizard.ResolveItem item = (ResolveWizard.ResolveItem)element;
                return item.file.getClientPath();
            }
        });
        col = this.createTableViewerColumn(Messages.ResolveWizardAutoPage_ResolveWith, 40, layout);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ResolveWizard.ResolveItem item = (ResolveWizard.ResolveItem)element;
                return MessageFormat.format("{0} #{1}, #{2}", item.getFromFile(), Math.max(0, item.getStartFromRev()) + 1, item.getEndFromRev());
            }
        });
        col = this.createTableViewerColumn(Messages.ResolveWizardAutoPage_ResolveType, 10, layout);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ResolveWizard.ResolveItem item = (ResolveWizard.ResolveItem)element;
                return item.file.getIntegrationSpecs()[item.index].getResolveType();
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(String title, int weight, TableColumnLayout layout) {
        TableViewerColumn viewerColumn = new TableViewerColumn((TableViewer)this.resolveTable, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(weight, true));
        return viewerColumn;
    }

    private void validate() {
        Table table = this.resolveTable.getTable();
        int i = 0;
        while (i < table.getItemCount()) {
            ResolveWizard.ResolveItem item = (ResolveWizard.ResolveItem)table.getItem(i).getData();
            if (this.resolveTable.getChecked((Object)item)) {
                if (item.isMove()) {
                    this.selectAllItemsForFile(item.file);
                } else if (item.isContent()) {
                    this.selectAllContentItemsForFile(item.file);
                }
            }
            ++i;
        }
        String message = null;
        int checkCount = this.resolveTable.getCheckedElements().length;
        this.resolveButton.setEnabled(checkCount > 0);
        if (message == null && checkCount == 0) {
            message = Messages.ResolveWizardAutoPage_SelectFiles;
        }
        this.container.setMessage(message);
    }

    private void selectAllItemsForFile(IP4File file) {
        Table table = this.resolveTable.getTable();
        int i = 0;
        while (i < table.getItemCount()) {
            ResolveWizard.ResolveItem item = (ResolveWizard.ResolveItem)table.getItem(i).getData();
            if (item.file == file) {
                this.resolveTable.setChecked((Object)item, true);
            }
            ++i;
        }
    }

    private void selectAllContentItemsForFile(IP4File file) {
        Table table = this.resolveTable.getTable();
        int i = 0;
        while (i < table.getItemCount()) {
            ResolveWizard.ResolveItem item = (ResolveWizard.ResolveItem)table.getItem(i).getData();
            if (item.file == file && item.isContent()) {
                this.resolveTable.setChecked((Object)item, true);
            }
            ++i;
        }
    }

    private void selectAllWithFileType(String type) {
        Table table = this.resolveTable.getTable();
        int i = 0;
        while (i < table.getItemCount()) {
            ResolveWizard.ResolveItem item = (ResolveWizard.ResolveItem)table.getItem(i).getData();
            this.resolveTable.setChecked((Object)item, StringUtils.equals((CharSequence)type, (CharSequence)item.file.getOpenedType()));
            ++i;
        }
        this.validate();
    }

    private void selectAllWithResolveType(String type) {
        Table table = this.resolveTable.getTable();
        int i = 0;
        while (i < table.getItemCount()) {
            ResolveWizard.ResolveItem item = (ResolveWizard.ResolveItem)table.getItem(i).getData();
            this.resolveTable.setChecked((Object)item, type.equals(item.getResolveType()));
            ++i;
        }
        this.validate();
    }

    private void runResolve() {
        assert (this.numResolveItems == 0);
        ArrayList<ResolveOperation> operations = new ArrayList<ResolveOperation>();
        Table table = this.resolveTable.getTable();
        ResolveOperation op = new ResolveOperation();
        ++this.numResolveItems;
        op.options = this.getAutoOption();
        op.options.setChangelistId(this.changeId);
        operations.add(op);
        if (!operations.isEmpty()) {
            this.startResolve(operations);
        }
    }

    private void startResolve(List<ResolveOperation> operations) {
        this.container.setMessage(Messages.ResolveWizardAutoPage_AutoResolvingFiles);
        this.updateButtons(false);
        assert (this.numResolveOperations == 0);
        this.numResolveOperations = operations.size();
        for (ResolveOperation op : operations) {
            final P4Collection collection = P4ConnectionManager.getManager().createP4Collection();
            collection.setType(IP4Resource.Type.LOCAL);
            final IP4File file = op.file;
            final ResolveFilesAutoOptions options = op.options;
            P4Runnable runnable = new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    boolean numIntegSpecsBefore = false;
                    collection.resolveChangelist(options, ResolveAutoControl.this.conn);
                    collection.resolve(new ResolveFilesAutoOptions().setShowActionsOnly(true).setShowBase(true));
                    boolean numIntegSpecsAfter = false;
                    UIJob job = new UIJob(Messages.ResolveWizardAutoPage_UpdatingDialog){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            ResolveAutoControl.this.stopResolve(file, 0);
                            return Status.OK_STATUS;
                        }
                    };
                    job.setSystem(true);
                    job.schedule();
                }
            };
            P4Runner.schedule((IP4Runnable)runnable);
        }
    }

    private void stopResolve(IP4File file, int numResolved) {
        if (!P4UIUtils.okToUse((Viewer)this.resolveTable)) {
            return;
        }
        this.numResolveItems -= numResolved;
        if (--this.numResolveOperations == 0) {
            this.container.getResolveWizard().updateUnresolvedItems();
            this.resolveTable.setInput((Object)this.container.getResolveWizard().unresolved);
            if (this.numResolveItems > 0) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.ResolveWizardAutoPage_ResolveFailedTitle, (String)MessageFormat.format(Messages.ResolveWizardAutoPage_ResolveFailedMessage, this.numResolveItems));
                this.numResolveItems = 0;
            }
            this.resolveTable.getTable().setEnabled(true);
            this.updateButtons(true);
        }
    }

    private void updateButtons(boolean enabled) {
        this.selectButton.setEnabled(enabled);
        this.resolveButton.setEnabled(enabled);
        this.mergeSafeButton.setEnabled(enabled);
        this.mergeNoConflictsButton.setEnabled(enabled);
        this.acceptTargetButton.setEnabled(enabled);
        this.acceptSourceButton.setEnabled(enabled);
        this.mergeWithConflictsButton.setEnabled(enabled);
    }

    private static class ResolveOperation {
        IP4File file = null;
        ResolveFilesAutoOptions options = null;

        private ResolveOperation() {
        }
    }
}

