/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.changelists.PendingCombo;
import com.perforce.team.ui.dialogs.FileListViewer;
import com.perforce.team.ui.dialogs.PerforceDialog;
import com.perforce.team.ui.p4java.dialogs.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CheckConsistencyDialog
extends PerforceDialog {
    private IFile[] diffFiles;
    private IFile[] missingFiles;
    private IFile[] newFiles;
    private FileListViewer diffViewer;
    private FileListViewer missingViewer;
    private FileListViewer newViewer;
    private IP4Connection connection;
    private PendingCombo changeCombo;

    public CheckConsistencyDialog(Shell parent, IP4Connection connection, IFile[] diffFiles, IFile[] missingFiles, IFile[] newFiles) {
        super(parent, Messages.CheckConsistencyDialog_ConsistencyCheckResults);
        this.diffFiles = diffFiles;
        this.missingFiles = missingFiles;
        this.newFiles = newFiles;
        this.connection = connection;
        this.setModalResizeStyle();
    }

    public int getSelectedChange() {
        return this.changeCombo.getSelected();
    }

    public String getSelectedDescription() {
        return this.changeCombo.getDescription();
    }

    public IFile[] getDiffFiles() {
        return this.diffFiles;
    }

    public IFile[] getMissingFiles() {
        return this.missingFiles;
    }

    public IFile[] getNewFiles() {
        return this.newFiles;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = this.createComposite(dialogArea, 1, 1808);
        if (this.diffFiles.length > 0) {
            Composite diffGroup = this.createTitledArea(composite, 1808);
            this.createLabel(diffGroup, Messages.CheckConsistencyDialog_UnopenedFilesThatDiffer);
            this.diffViewer = new FileListViewer(diffGroup, this.diffFiles, this.diffFiles, false);
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.diffViewer.getControl(), "com.perforce.team.ui.check_consistency_diff_files");
        }
        if (this.missingFiles.length > 0) {
            Composite missingGroup = this.createTitledArea(composite, 1808);
            this.createLabel(missingGroup, Messages.CheckConsistencyDialog_UnopenedFilesMissing);
            this.missingViewer = new FileListViewer(missingGroup, this.missingFiles, this.missingFiles, false);
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.missingViewer.getControl(), "com.perforce.team.ui.check_consistency_missing_files");
        }
        if (this.newFiles.length > 0) {
            Composite newGroup = this.createTitledArea(composite, 1808);
            this.createLabel(newGroup, Messages.CheckConsistencyDialog_FilesNotUnderPerforce);
            this.newViewer = new FileListViewer(newGroup, this.newFiles, this.newFiles, false);
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.newViewer.getControl(), "com.perforce.team.ui.check_consistency_new_files");
        }
        this.changeCombo = this.createChangeCombo(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.changeCombo.getCombo(), "com.perforce.team.ui.check_consistency_changes");
        return composite;
    }

    protected void okPressed() {
        if (this.diffFiles.length > 0) {
            this.diffFiles = this.getFiles(this.diffViewer.getCheckedElements());
        }
        if (this.missingFiles.length > 0) {
            this.missingFiles = this.getFiles(this.missingViewer.getCheckedElements());
        }
        if (this.newFiles.length > 0) {
            this.newFiles = this.getFiles(this.newViewer.getCheckedElements());
        }
        super.okPressed();
    }

    private IFile[] getFiles(Object[] objs) {
        IFile[] files = new IFile[objs.length];
        int i = 0;
        while (i < objs.length) {
            files[i] = (IFile)objs[i];
            ++i;
        }
        return files;
    }

    private PendingCombo createChangeCombo(Composite parent) {
        PendingCombo combo = new PendingCombo(Messages.CheckConsistencyDialog_OpenInChangelist, (IP4Resource)this.connection);
        combo.createControl(parent);
        return combo;
    }
}

