/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.dialogs;

import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.ui.dialogs.P4StatusDialog;
import com.perforce.team.ui.p4java.dialogs.Messages;
import com.perforce.team.ui.views.IPerforceView;
import com.perforce.team.ui.views.SubmittedViewControl;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;

public class BrowseChangeListDialog
extends P4StatusDialog {
    private SubmittedViewControl control;
    private IP4Connection connection;
    private IP4Changelist changelist;

    public BrowseChangeListDialog(Shell parent, IP4Connection connection) {
        super(parent, Messages.BrowseChangeListDialog_Title);
        this.connection = connection;
        this.setShellStyle(16);
    }

    public IP4Changelist getSelectedChangeList() {
        return this.changelist;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        IPerforceView view = new IPerforceView(){

            @Override
            public IWorkbenchPartSite getSite() {
                return null;
            }

            @Override
            public Shell getShell() {
                return BrowseChangeListDialog.this.getShell();
            }

            @Override
            public IP4Connection getConnection() {
                return BrowseChangeListDialog.this.connection;
            }
        };
        this.control = new SubmittedViewControl(view);
        this.control.createViewControl(dialogArea);
        this.control.showDisplayDetails(true);
        this.control.enableDoubleClick(false);
        this.control.getChangelistTable().getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BrowseChangeListDialog.this.validate();
            }
        });
        return dialogArea;
    }

    private void validate() {
        String errorMessage = null;
        IP4SubmittedChangelist[] selections = this.control.getChangelistTable().getSelectedChangelists();
        if (selections == null || selections.length == 0) {
            errorMessage = Messages.BrowseChangeListDialog_NoChangeListSelectedError;
        }
        if (errorMessage != null) {
            this.setErrorMessage(errorMessage);
        } else {
            this.setInfoMessage(Messages.BrowseChangeListDialog_InformationText);
        }
    }

    public void create() {
        super.create();
        this.getShell().setSize(1000, 800);
        this.validate();
    }

    protected void okPressed() {
        IP4SubmittedChangelist[] selections = this.control.getChangelistTable().getSelectedChangelists();
        if (selections != null && selections.length > 0) {
            this.changelist = selections[0];
        }
        super.okPressed();
    }
}

