/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Depot;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;

public class SandBoxPullAction
extends P4Action {
    @Override
    protected void runAction() {
        IP4Connection conn;
        final P4Collection collection = this.getResourceSelection();
        if (collection.isEmpty()) {
            return;
        }
        Object resource = this.getSelection().getFirstElement();
        if (resource instanceof IP4Resource && (conn = ((IP4Resource)resource).getConnection()) != null) {
            P4Runnable runnable = new P4Runnable(){

                public String getTitle() {
                    return Messages.PullAction_Pulling;
                }

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(this.getTitle(), 1);
                    monitor.subTask(SandBoxPullAction.this.generateTitle(null, collection));
                    collection.pull();
                    monitor.worked(1);
                    monitor.done();
                    collection.refreshLocalResources(2);
                    SandBoxPullAction.this.updateActionState();
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
    }

    @Override
    protected boolean isEnabledEx() throws TeamException {
        Object[] selected;
        if (this.getSelection() != null && (selected = this.getSelection().toArray()) != null && selected.length == 1 && selected[0] instanceof IP4Resource) {
            IP4Resource resource = (IP4Resource)selected[0];
            IP4Connection conn = resource.getConnection();
            return conn != null && conn.isSandbox() && "mirror".equals(resource.getName()) && resource.getParent() instanceof P4Depot;
        }
        return false;
    }
}

