/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import com.perforce.team.ui.p4java.dialogs.PopulateDialog;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class PopulateAction
extends P4Action {
    @Override
    public boolean isEnabledEx() {
        boolean enabled = false;
        if (this.containsOnlineConnection()) {
            boolean bl = enabled = this.getSelection() != null && this.getSelection().size() == 1;
            if (enabled && !this.containsContainers()) {
                IP4Resource[] resources = this.getResourceSelection().members();
                if (resources.length == 1) {
                    if (resources[0] instanceof IP4Connection || resources[0] instanceof IP4SubmittedChangelist) {
                        enabled = true;
                    } else if (resources[0] instanceof IP4File) {
                        IP4File resource = (IP4File)resources[0];
                        enabled = resource.getHeadRevision() > 0;
                    }
                } else {
                    enabled = false;
                }
            }
        }
        return enabled;
    }

    public void populate(IP4Connection connection, String targetPath) {
        PopulateDialog dialog;
        if (targetPath != null && (dialog = new PopulateDialog(this.getShell(), connection, null, targetPath)).open() == 0) {
            this.populate(connection, dialog.getSourcePaths(), dialog.getTargetPaths(), false, dialog.getDescription());
        }
    }

    public void populate(final IP4Connection connection, final List<String> sourcePaths, final List<String> targetPaths, final boolean preview, final String description) {
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                int i = 0;
                while (i < sourcePaths.size()) {
                    IP4Resource[] integrated = connection.populate((String)sourcePaths.get(i), (String)targetPaths.get(i), preview, description);
                    if (integrated != null && integrated.length > 0) {
                        P4Collection collection = PopulateAction.this.createCollection(integrated);
                        collection.refreshLocalResources(2);
                    }
                    ++i;
                }
            }

            public String getTitle() {
                return Messages.PopulateAction_PopulatingFiles;
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    @Override
    protected void runAction() {
    }
}

