/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import com.perforce.team.ui.p4java.dialogs.ChangeSpecDialog;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.progress.UIJob;

public class NewChangelistAction
extends P4Action {
    public void runAction(boolean showDialog, String description, IP4File[] files, IP4Job[] jobs) {
        P4Collection collection = this.getResourceSelection();
        IP4Connection connection = null;
        IP4Resource[] iP4ResourceArray = collection.members();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource.getConnection() != null) {
                connection = resource.getConnection();
                break;
            }
            ++n2;
        }
        if (connection != null) {
            if (jobs == null) {
                jobs = new IP4Job[]{};
            }
            if (files == null) {
                files = new IP4File[]{};
            }
            this.refreshAndCreate(showDialog, description, files, jobs, connection);
        }
    }

    private void refreshAndCreate(final boolean showDialog, final String description, final IP4File[] files, final IP4Job[] jobs, final IP4Connection connection) {
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                IP4PendingChangelist defaultChangelist = connection.getPendingChangelist(0);
                if (defaultChangelist != null) {
                    defaultChangelist.refresh();
                    NewChangelistAction.this.create(showDialog, description, files, jobs, connection, defaultChangelist);
                }
            }

            public String getTitle() {
                return Messages.NewChangelistAction_RefreshingDefaultChangelist;
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    private void create(boolean showDialog, String description, IP4File[] files, IP4Job[] jobs, final IP4Connection connection, final IP4PendingChangelist defaultChangelist) {
        if (showDialog) {
            UIJob job = new UIJob(Messages.NewChangelistAction_DisplayingNewChangelistDialog){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    ChangeSpecDialog dlg = new ChangeSpecDialog(defaultChangelist, null, NewChangelistAction.this.getShell(), false);
                    if (dlg.open() == 0) {
                        String enteredDescription = dlg.getDescription();
                        IP4File[] selectedFiles = dlg.getCheckedFiles();
                        IP4Job[] selectedJobs = dlg.getCheckedJobs();
                        NewChangelistAction.this.createChangelist(enteredDescription, selectedJobs, selectedFiles, connection);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        } else {
            this.createChangelist(description, jobs, files, connection);
        }
    }

    public void create() {
        P4Collection collection = this.getFileSelection();
        Map connectionMap = collection.toFileMap();
        for (Map.Entry entry : connectionMap.entrySet()) {
            final IP4Connection connection = (IP4Connection)entry.getKey();
            final IP4File[] files = ((List)entry.getValue()).toArray(new IP4File[0]);
            PerforceUIPlugin.syncExec(new Runnable(){

                @Override
                public void run() {
                    ChangeSpecDialog dlg = new ChangeSpecDialog(connection, files, null, NewChangelistAction.this.getShell(), Messages.NewChangelistAction_Test);
                    if (dlg.open() == 0) {
                        String enteredDescription = dlg.getDescription();
                        IP4File[] selectedFiles = dlg.getCheckedFiles();
                        IP4Job[] selectedJobs = dlg.getCheckedJobs();
                        NewChangelistAction.this.createChangelist(enteredDescription, selectedJobs, selectedFiles, connection);
                    }
                }
            });
        }
    }

    private void createChangelist(final String p4Description, final IP4Job[] p4Jobs, final IP4File[] p4Files, final IP4Connection p4Connection) {
        if (p4Jobs != null && p4Files != null && p4Description != null) {
            P4Runnable runnable = new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    p4Connection.createChangelist(p4Description, p4Files, p4Jobs);
                }

                public String getTitle() {
                    return Messages.NewChangelistAction_CreatingNewChangelist;
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
    }

    public void runAction(boolean showDialog, String description) {
        this.runAction(showDialog, description, null, null);
    }

    @Override
    public void runAction() {
        this.runAction(true, null);
    }
}

