/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.p4java.server.IServer;
import com.perforce.team.core.p4java.IP4Branch;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4FileIntegration;
import com.perforce.team.core.p4java.P4IntegrationOptions;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import com.perforce.team.ui.p4java.dialogs.IntegrateDialog;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.core.runtime.IProgressMonitor;

public class IntegrateAction
extends P4Action {
    public void integrate(IP4SubmittedChangelist changelist) {
        this.integrateResource((IP4Resource)changelist);
    }

    private void integrateResource(IP4Resource resource) {
        IntegrateDialog dialog = new IntegrateDialog(this.getShell(), resource);
        if (dialog.open() == 0) {
            this.processDialog(dialog, resource);
        }
    }

    public void integrate(IP4Connection connection, P4FileIntegration integration, int changelist, P4IntegrationOptions options, boolean isAddPreviouslyLinkedJobs) {
        this.integrate(connection, integration, null, changelist, options, isAddPreviouslyLinkedJobs);
    }

    public void integrate(IP4Connection connection, P4FileIntegration integration, String branch, int changelist, P4IntegrationOptions options, boolean isAddPreviouslyLinkedJobs) {
        this.integrate(connection, integration, branch, changelist, null, options, isAddPreviouslyLinkedJobs);
    }

    public void integrate(String source, String target, String start, String end, int changelist, P4IntegrationOptions options, boolean isAddPreviouslyLinkedJobs) {
        P4Collection collection = this.getResourceSelection();
        IP4Resource[] members = collection.members();
        if (members.length == 1) {
            P4FileIntegration integration = new P4FileIntegration();
            integration.setTarget(target);
            integration.setSource(source);
            integration.setEnd(end);
            integration.setStart(start);
            IP4Connection connection = members[0].getConnection();
            this.integrate(connection, integration, changelist, options, isAddPreviouslyLinkedJobs);
        }
    }

    public void integrate(final IP4Connection connection, final P4FileIntegration integration, final String branch, final int changelist, final String description, final P4IntegrationOptions options, final boolean isAddPreviouslyLinkedJobs) {
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                Object[] integrated = connection.integrate(integration, branch, changelist, description, false, options, isAddPreviouslyLinkedJobs);
                if (ArrayUtils.isNotEmpty((Object[])integrated)) {
                    P4Collection collection = IntegrateAction.this.createCollection((IP4Resource[])integrated);
                    collection.refreshLocalResources(2);
                }
            }

            public String getTitle() {
                return Messages.getString("IntegrateAction_IntegratingFiles");
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    public void integrateBranch(IP4Branch branch, boolean reverse) {
        this.integrateBranch(branch, reverse, null);
    }

    public void integrateBranch(IP4Branch branch, boolean reverse, IP4SubmittedChangelist limit) {
        if (branch != null) {
            IntegrateDialog dialog = new IntegrateDialog(this.getShell(), (IP4Resource)branch);
            dialog.setDefaultLimitOnIntegration(limit);
            if (reverse) {
                P4IntegrationOptions options = P4IntegrationOptions.createInstance((IServer)branch.getServer());
                options.setReverseMapping(true);
                dialog.setDefaultEnabledOptions(options);
            }
            if (dialog.open() == 0) {
                this.processDialog(dialog, (IP4Resource)branch);
            }
        }
    }

    public void integratePaths(IP4Resource resource, String source, String target) {
        this.integratePaths(resource, source, target, null);
    }

    public void integratePaths(IP4Resource resource, String source, String target, IP4SubmittedChangelist limit) {
        if (resource != null) {
            IntegrateDialog dialog = new IntegrateDialog(this.getShell(), resource.getConnection(), source, target);
            dialog.setDefaultLimitOnIntegration(limit);
            if (dialog.open() == 0) {
                this.processDialog(dialog, resource);
            }
        }
    }

    private void processDialog(IntegrateDialog dialog, IP4Resource resource) {
        P4FileIntegration integration = dialog.getCurrentFileIntegrationInfo();
        String branch = dialog.getBranchName();
        int changelist = dialog.getPendingChangelistId();
        String description = dialog.getChangeListDescription();
        P4IntegrationOptions options = dialog.getSelectedIntegrationOptions();
        boolean isAddPreviouslyLinkedJobs = dialog.isAddPreviouslyLinkedJobs();
        this.integrate(resource.getConnection(), integration, branch, changelist, description, options, isAddPreviouslyLinkedJobs);
    }

    @Override
    public boolean isEnabledEx() {
        boolean enabled = false;
        if (this.containsOnlineConnection()) {
            boolean bl = enabled = this.getSelection() != null && this.getSelection().size() == 1;
            if (enabled && !this.containsContainers()) {
                IP4Resource[] resources = this.getResourceSelection().members();
                if (resources.length == 1) {
                    if (resources[0] instanceof IP4Connection || resources[0] instanceof IP4SubmittedChangelist) {
                        enabled = true;
                    } else if (resources[0] instanceof IP4File) {
                        IP4File resource = (IP4File)resources[0];
                        enabled = resource.getHeadRevision() > 0;
                    }
                } else {
                    enabled = false;
                }
            }
        }
        return enabled;
    }

    @Override
    protected void runAction() {
        P4Collection collection = this.getResourceSelection();
        IP4Resource[] members = collection.members();
        if (members.length == 1) {
            this.integrateResource(members[0]);
        }
    }
}

