/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.dialogs.JobFixDialog;
import com.perforce.team.ui.p4java.actions.P4Action;
import org.eclipse.core.runtime.IProgressMonitor;

public class FixJobAction
extends P4Action {
    @Override
    public boolean isEnabledEx() {
        boolean enabled = false;
        P4Collection collection = this.getResourceSelection();
        IP4Resource[] members = collection.members();
        if (members.length == 1 && members[0] instanceof IP4PendingChangelist) {
            IP4PendingChangelist list = (IP4PendingChangelist)members[0];
            enabled = !list.isDefault() && !list.isReadOnly() && list.isOnClient();
        }
        return enabled;
    }

    public void runAction(IP4Job[] jobs) {
        P4Collection collection = this.getResourceSelection();
        IP4Resource[] resources = collection.members();
        if (resources.length == 1 && resources[0] instanceof IP4Changelist) {
            IP4Changelist list = (IP4Changelist)resources[0];
            this.fix(list, jobs);
        }
    }

    public void fix(IP4Changelist list, IP4Job[] jobs) {
        this.fix(new IP4Changelist[]{list}, jobs);
    }

    public void fix(final IP4Changelist[] lists, final IP4Job[] jobs) {
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                try {
                    IP4Changelist[] iP4ChangelistArray = lists;
                    int n = lists.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IP4Changelist list = iP4ChangelistArray[n2];
                        FixJobAction.this.createCollection((IP4Resource[])jobs).fix(list);
                        ++n2;
                    }
                }
                catch (Exception e) {
                    PerforceProviderPlugin.logWarning((Throwable)e);
                }
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    public void fix(IP4Changelist[] lists, IP4Job job) {
        this.fix(lists, new IP4Job[]{job});
    }

    public void fix(IP4Changelist list, IP4Job job) {
        this.fix(list, new IP4Job[]{job});
    }

    @Override
    public void runAction() {
        P4Collection collection = this.getResourceSelection();
        IP4Resource[] resources = collection.members();
        if (resources.length == 1) {
            IP4Job[] selected;
            IP4Resource resource = resources[0];
            JobFixDialog dialog = new JobFixDialog(this.getShell(), resource.getConnection());
            if (dialog.open() == 0 && (selected = dialog.getSelectedJobs()) != null && selected.length > 0) {
                this.runAction(selected);
            }
        }
    }
}

