/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.jobs.EditJobDialog;
import com.perforce.team.ui.p4java.actions.FixJobAction;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.P4DoubleClickAction;
import com.perforce.team.ui.p4java.actions.UnfixJobAction;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;

public class EditJobAction
extends P4DoubleClickAction {
    private void updateJob(final String id, final IP4Job job, final IP4Changelist[] added, final IP4Changelist[] removed) {
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                IP4Changelist list;
                int n;
                int n2;
                IP4Changelist[] iP4ChangelistArray;
                monitor.beginTask(this.getTitle(), added.length + removed.length + 1);
                if (!monitor.isCanceled()) {
                    iP4ChangelistArray = added;
                    n2 = added.length;
                    n = 0;
                    while (n < n2) {
                        list = iP4ChangelistArray[n];
                        monitor.setTaskName(MessageFormat.format(Messages.EditJobAction_FixingChangelist, list.getId()));
                        FixJobAction fix = new FixJobAction();
                        fix.setAsync(false);
                        fix.fix(list, new IP4Job[]{job});
                        monitor.worked(1);
                        ++n;
                    }
                }
                if (!monitor.isCanceled()) {
                    iP4ChangelistArray = removed;
                    n2 = removed.length;
                    n = 0;
                    while (n < n2) {
                        IP4PendingChangelist cached;
                        list = iP4ChangelistArray[n];
                        if (list instanceof IP4PendingChangelist && (cached = job.getConnection().getPendingChangelist(list.getId())) != null) {
                            list = cached;
                        }
                        monitor.setTaskName(MessageFormat.format(Messages.EditJobAction_UnfixingChangelist, list.getId()));
                        UnfixJobAction unfix = new UnfixJobAction();
                        unfix.setAsync(false);
                        unfix.unfix(list, job);
                        monitor.worked(1);
                        ++n;
                    }
                }
                if (!monitor.isCanceled()) {
                    monitor.setTaskName(MessageFormat.format(Messages.EditJobAction_RefreshingJob, id));
                    job.refresh();
                    P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.REFRESHED, (IP4Resource)job));
                    monitor.worked(1);
                }
                monitor.done();
            }

            public String getTitle() {
                return MessageFormat.format(Messages.EditJobAction_UpdatingJob, id);
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    @Override
    protected void runAction() {
        IP4Resource resource = this.getSingleResourceSelection();
        if (resource instanceof IP4Job) {
            final IP4Job job = (IP4Job)resource;
            String id = job.getId();
            if (id == null) {
                id = "";
            }
            final String jobId = id;
            P4Runnable runnable = new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(MessageFormat.format(Messages.EditJobAction_EditingJob, jobId), 3);
                    monitor.subTask(Messages.EditJobAction_RefreshingJobSubtask);
                    job.refresh();
                    monitor.worked(1);
                    monitor.subTask(Messages.EditJobAction_RefreshingChangelistsSubtask);
                    final IP4Changelist[] changelists = job.getConnection().getFixes(job);
                    monitor.worked(1);
                    monitor.subTask(Messages.EditJobAction_DisplayingDialogSubtask);
                    PerforceUIPlugin.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            EditJobDialog dialog = new EditJobDialog(EditJobAction.this.getShell(), job, changelists);
                            if (dialog.open() == 0) {
                                IP4Changelist[] added = dialog.getAddedChangelists();
                                IP4Changelist[] removed = dialog.getRemovedChangelists();
                                EditJobAction.this.updateJob(jobId, job, added, removed);
                            }
                        }
                    });
                    monitor.done();
                }

                public String getTitle() {
                    return MessageFormat.format(Messages.EditJobAction_LoadingJob, jobId);
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
    }

    @Override
    protected boolean isEnabledEx() throws TeamException {
        if (this.containsOnlineConnection()) {
            return this.getSingleResourceSelection() instanceof IP4Job;
        }
        return false;
    }
}

