/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4SubmittedFile;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.editor.CompareUtils;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class DepotDiffPreviousAction
extends P4Action {
    private static void showDiffDeleted() {
        PerforceUIPlugin.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)P4UIUtils.getShell(), (String)Messages.DepotDiffPreviousAction_CantDiffDeletedTitle, (String)Messages.DepotDiffPreviousAction_CantDiffDeletedMessage);
            }
        });
    }

    private static void showDiffAdded() {
        PerforceUIPlugin.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)P4UIUtils.getShell(), (String)Messages.DepotDiffPreviousAction_CantDiffAddedTitle, (String)Messages.DepotDiffPreviousAction_CantDiffAddedMessage);
            }
        });
    }

    @Override
    protected void runAction() {
        IP4File file;
        IP4Resource resource = this.getSingleResourceSelection();
        if (resource instanceof IP4SubmittedFile && (file = ((IP4SubmittedFile)resource).getFile()) != null) {
            P4Runnable runnable = new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    IFileSpec spec = file.getP4JFile();
                    if (spec != null) {
                        if (file.openedForDelete()) {
                            DepotDiffPreviousAction.showDiffDeleted();
                        } else {
                            String depot = file.getRemotePath();
                            int end = spec.getEndRevision();
                            if (end > 1) {
                                CompareUtils.doCompare(file, depot, depot, end, end - 1);
                            } else {
                                DepotDiffPreviousAction.showDiffAdded();
                            }
                        }
                    }
                }

                public String getTitle() {
                    return Messages.DepotDiffPreviousAction_GeneratingDiff;
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
    }
}

