/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.p4java.actions.P4Action;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.core.TeamException;

public abstract class AsyncEnablementAction
extends P4Action {
    private ISchedulingRule enablementRule = P4Runner.createRule();

    private boolean loadEnablementAsync() {
        boolean useAsync = false;
        if (PerforceUIPlugin.isUIThread() && this.getSelection() != null) {
            Object[] objectArray = this.getSelection().toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object select = objectArray[n2];
                IResource resource = this.getResource(select);
                if (resource != null) {
                    IP4Connection connection = P4ConnectionManager.getManager().getConnection(resource.getProject(), false);
                    if (this.isConnected(connection)) {
                        useAsync = true;
                        break;
                    }
                } else {
                    IP4Resource p4Resource = this.getP4Resource(select);
                    if (p4Resource != null && this.isConnected(p4Resource.getConnection())) {
                        useAsync = true;
                        break;
                    }
                }
                ++n2;
            }
        }
        return useAsync;
    }

    private boolean isConnected(IP4Connection connection) {
        return connection != null && !connection.isOffline() && !connection.isConnected();
    }

    @Override
    protected void setActionEnablement(final IAction action) {
        if (!this.loadEnablementAsync()) {
            super.setActionEnablement(action);
        } else {
            action.setEnabled(false);
            P4Runner.schedule((IP4Runnable)new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    try {
                        action.setEnabled(AsyncEnablementAction.this.isEnabledEx());
                    }
                    catch (TeamException te) {
                        PerforceProviderPlugin.logError((Throwable)te);
                    }
                }
            }, (ISchedulingRule)this.enablementRule);
        }
    }
}

