/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.IgnoredFiles;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.OpenAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;

public class AddAction
extends OpenAction {
    private boolean makeWritable = false;

    @Override
    protected boolean isEnabledEx() throws TeamException {
        P4Collection collection;
        IP4Resource[] resources;
        boolean enabled = this.containsOnlineConnection();
        if (enabled && !(enabled = this.containsContainers()) && (resources = (collection = super.getResourceSelection()).members()).length > 0) {
            IP4Resource[] iP4ResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource.getRemotePath() == null) {
                    enabled = true;
                    break;
                }
                if (resource instanceof IP4File && ((IP4File)resource).isHeadActionDelete()) {
                    enabled = true;
                    break;
                }
                ++n2;
            }
        }
        return enabled;
    }

    private void add(final P4Collection collection, final int changelist, final String description, final boolean setActive) {
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                P4Collection filterIgnored = AddAction.this.createCollection();
                filterIgnored.setType(collection.getType());
                IP4Resource[] iP4ResourceArray = collection.members();
                int n = iP4ResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4Resource resource = iP4ResourceArray[n2];
                    if (resource instanceof IP4File) {
                        IFile[] filtered;
                        IFile file = ((IP4File)resource).getLocalFileForLocation();
                        if (file != null && (filtered = IgnoredFiles.filterAddFiles(new IFile[]{file})) != null && filtered.length == 1 && file.equals((Object)filtered[0])) {
                            filterIgnored.add(resource);
                        }
                    } else {
                        filterIgnored.add(resource);
                    }
                    ++n2;
                }
                monitor.beginTask(this.getTitle(), 1);
                monitor.subTask(AddAction.this.generateTitle(null, filterIgnored));
                P4Collection added = filterIgnored.addToChangelist(changelist, description, setActive);
                monitor.worked(1);
                monitor.done();
                if (added != null && AddAction.this.makeWritable) {
                    added.setReadOnly(false);
                }
                AddAction.this.updateActionState();
            }

            public String getTitle() {
                return AddAction.this.getJobTitle();
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }

    @Override
    protected void runModifyAction(int changelist, String description, P4Collection collection, boolean setActive) {
        this.add(collection, changelist, description, setActive);
    }

    @Override
    public String getComboTitle() {
        return Messages.AddAction_AddToChangelist;
    }

    @Override
    public String getDialogTitle() {
        return Messages.AddAction_AddToSourceControl;
    }

    public boolean isMakeWritable() {
        return this.makeWritable;
    }

    public void setMakeWritable(boolean makeWritable) {
        this.makeWritable = makeWritable;
    }

    @Override
    protected boolean isValidFile(IP4File file) {
        return file.getRemotePath() == null || file.isHeadActionDelete();
    }

    @Override
    protected String getJobTitle() {
        return Messages.AddAction_AddingToSourceControl;
    }

    @Override
    protected String getDefaultDescription() {
        return P4Collection.ADD_DEFAULT_DESCRIPTION;
    }
}

