/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.labels;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Label;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.dialogs.DialogUtils;
import com.perforce.team.ui.dialogs.FixedWidthScrolledComposite;
import com.perforce.team.ui.labels.LabelSorter;
import com.perforce.team.ui.labels.LabelWidget;
import com.perforce.team.ui.labels.Messages;
import com.perforce.team.ui.viewer.FilterViewer;
import com.perforce.team.ui.views.PerforceProjectView;
import com.perforce.team.ui.views.SessionManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.progress.UIJob;

public class LabelsViewer
extends FilterViewer
implements ISelectionChangedListener,
IPropertyChangeListener {
    public static final String FILE_FOLDER_HISTORY = "com.perforce.team.ui.labels.FILE_FOLDER_HISTORY";
    public static final String OWNER_HISTORY = "com.perforce.team.ui.labels.OWNER_HISTORY";
    public static final String NAME_HISTORY = "com.perforce.team.ui.labels.NAME_HISTORY";
    public static final String LABEL_COLUMN = Messages.LabelsViewer_Label;
    public static final String DESCRIPTION_COLUMN = Messages.LabelsViewer_Description;
    public static final String ACCESS_COLUMN = Messages.LabelsViewer_AccessTime;
    public static final String OWNER_COLUMN = Messages.LabelsViewer_Owner;
    public static final String ELLIPSIS = "...";
    private LabelSorter sorter;
    private TableViewer labelsList;
    private IP4Connection connection;
    private Composite viewComposite;
    private Link showMore;
    private Label folderFileLabel;
    private Combo folderFileCombo;
    private ToolBar folderFileBar;
    private ToolItem folderFileClearItem;
    private Label ownerLabel;
    private Combo ownerCombo;
    private ToolBar ownerBar;
    private ToolItem ownerClearItem;
    private Label nameLabel;
    private Combo nameCombo;
    private ToolBar nameBar;
    private ToolItem nameClearItem;
    private SashForm sash;
    private ScrolledComposite detailPanel;
    private LabelWidget labelView;
    private int retrieveCount = 0;
    private boolean isLoading = false;
    private boolean autoSelectFirstEntry = false;
    private IP4Label selectedLabel = null;
    private Object loading = new Object();
    private Image loadingImage;
    private Image clearImage;
    public static final String COLUMN_SIZES = "com.perforce.team.ui.labelcolumns";

    public void showMore() {
        if (this.retrieveCount != -1) {
            this.retrieveCount += this.getMaxLabels();
        }
        this.loadLabels();
    }

    private void createMoreLink(Composite parent) {
        this.showMore = new Link(parent, 8);
        this.showMore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LabelsViewer.this.showMore();
            }
        });
        this.showMore.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
        this.refreshRetrieveCount();
        this.updateMoreButton(false);
        if (this.connection.getIntVersion() < 20061) {
            this.showMore.setVisible(false);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("com.perforce.team.ui.preferences.NUM_LABELS_RETRIEVE".equals(property)) {
            this.retrieveCount = this.getMaxLabels();
            this.updateMoreButton();
            this.loadLabels();
        }
    }

    public Composite createControl(Composite parent, IP4Connection con, boolean multiSelect, boolean displayDetails) {
        this.connection = con;
        if (this.sash != null && !this.sash.isDisposed()) {
            this.sash.dispose();
        }
        PerforceUIPlugin.getPlugin().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.sash = DialogUtils.createSash(parent);
        this.viewComposite = new Composite((Composite)this.sash, 0);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        this.viewComposite.setLayout((Layout)gl);
        this.createFilterArea(this.viewComposite);
        this.createMoreLink(this.viewComposite);
        Table table = this.createTable(this.viewComposite, multiSelect);
        this.detailPanel = this.createDetailPanel((Composite)this.sash, table.getBackground());
        this.labelsList.addSelectionChangedListener((ISelectionChangedListener)this);
        this.updateSash(displayDetails);
        this.loadLabels();
        return this.sash;
    }

    public void setPath(String folderFilePath) {
        if (this.okToUse()) {
            if (folderFilePath == null) {
                folderFilePath = "";
            }
            this.folderFileCombo.setText(folderFilePath);
            this.loadLabels();
        }
    }

    private void updateMoreButton(boolean layout) {
        if (this.showMore != null && !this.showMore.isDisposed()) {
            int max = this.getMaxLabels();
            if (max == -1) {
                this.showMore.setText(Messages.LabelsViewer_ShowMore);
                this.showMore.setEnabled(false);
            } else {
                this.showMore.setText(MessageFormat.format(Messages.LabelsViewer_ShowNumMore, max));
                this.showMore.setEnabled(true);
            }
            if (layout) {
                this.showMore.getParent().layout(new Control[]{this.showMore});
            }
        }
    }

    private void updateMoreButton() {
        this.updateMoreButton(true);
    }

    private void createFilterArea(Composite parent) {
        String[] names;
        String[] keywords;
        String[] folders;
        this.filterComposite = new Composite(parent, 0);
        GridLayout fcLayout = new GridLayout(6, false);
        this.filterComposite.setLayout((Layout)fcLayout);
        this.filterComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        final SelectionListener comboAdapter = P4UIUtils.createComboSelectionListener(new Runnable(){

            @Override
            public void run() {
                LabelsViewer.this.loadLabels();
            }
        });
        this.clearImage = PerforceUIPlugin.getPlugin().getImageDescriptor("normal/clear.png").createImage();
        this.folderFileLabel = new Label(this.filterComposite, 16384);
        this.folderFileLabel.setText(Messages.LabelsViewer_FolderFile);
        this.folderFileCombo = new Combo(this.filterComposite, 4);
        String[] stringArray = folders = PerforceProjectView.getItems(FILE_FOLDER_HISTORY);
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            String folder = stringArray[n2];
            this.folderFileCombo.add(folder);
            ++n2;
        }
        this.folderFileCombo.addSelectionListener(comboAdapter);
        GridData ffcData = new GridData(4, 4, true, false);
        ffcData.horizontalSpan = 4;
        this.folderFileCombo.setLayoutData((Object)ffcData);
        this.folderFileBar = new ToolBar(this.filterComposite, 0x800000);
        this.folderFileClearItem = new ToolItem(this.folderFileBar, 8);
        this.folderFileClearItem.setToolTipText(Messages.LabelsViewer_ClearFolderFile);
        this.folderFileClearItem.setImage(this.clearImage);
        this.folderFileClearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LabelsViewer.this.folderFileCombo.setText("");
                comboAdapter.widgetSelected(null);
            }
        });
        this.ownerLabel = new Label(this.filterComposite, 16384);
        this.ownerLabel.setText(Messages.LabelsViewer_OwnerLabel);
        this.ownerLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.ownerCombo = new Combo(this.filterComposite, 4);
        String[] stringArray2 = keywords = PerforceProjectView.getItems(OWNER_HISTORY);
        int n3 = keywords.length;
        int n4 = 0;
        while (n4 < n3) {
            String keyword = stringArray2[n4];
            this.ownerCombo.add(keyword);
            ++n4;
        }
        this.ownerCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.ownerCombo.addSelectionListener(comboAdapter);
        this.ownerBar = new ToolBar(this.filterComposite, 0x800000);
        this.ownerClearItem = new ToolItem(this.ownerBar, 8);
        this.ownerClearItem.setToolTipText(Messages.LabelsViewer_ClearOwnerFilter);
        this.ownerClearItem.setImage(this.clearImage);
        this.ownerClearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LabelsViewer.this.ownerCombo.setText("");
                comboAdapter.widgetSelected(null);
            }
        });
        this.nameLabel = new Label(this.filterComposite, 16384);
        this.nameLabel.setText(Messages.LabelsViewer_NameContains);
        this.nameLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.nameCombo = new Combo(this.filterComposite, 4);
        String[] stringArray3 = names = PerforceProjectView.getItems(NAME_HISTORY);
        int n5 = names.length;
        n3 = 0;
        while (n3 < n5) {
            String name = stringArray3[n3];
            this.nameCombo.add(name);
            ++n3;
        }
        this.nameCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.nameCombo.addSelectionListener(comboAdapter);
        this.nameBar = new ToolBar(this.filterComposite, 0x800000);
        this.nameClearItem = new ToolItem(this.nameBar, 8);
        this.nameClearItem.setToolTipText(Messages.LabelsViewer_ClearNameFilter);
        this.nameClearItem.setImage(this.clearImage);
        this.nameClearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LabelsViewer.this.nameCombo.setText("");
                comboAdapter.widgetSelected(e);
            }
        });
        if (this.connection.getIntVersion() < 20081) {
            this.nameLabel.setVisible(false);
            this.nameCombo.setVisible(false);
            this.nameBar.setVisible(false);
        }
    }

    private IP4Label getSelectedLabel(ISelection selection) {
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        if (ss.size() != 1) {
            return null;
        }
        if (ss.getFirstElement() instanceof IP4Label) {
            return (IP4Label)ss.getFirstElement();
        }
        return null;
    }

    public IP4Label[] getSelectedLabels() {
        ISelection selected = this.labelsList.getSelection();
        ArrayList<IP4Label> selectedLabels = new ArrayList<IP4Label>();
        if (selected instanceof IStructuredSelection) {
            Object[] selectedItem = ((IStructuredSelection)selected).toArray();
            int i = 0;
            while (i < selectedItem.length) {
                if (selectedItem[i] instanceof IP4Label) {
                    selectedLabels.add((IP4Label)selectedItem[i]);
                }
                ++i;
            }
        }
        return selectedLabels.toArray(new IP4Label[selectedLabels.size()]);
    }

    public Table getTableControl() {
        if (this.labelsList != null) {
            return this.labelsList.getTable();
        }
        return null;
    }

    public TableViewer getViewer() {
        return this.labelsList;
    }

    private Map<String, Integer> loadColumnSizes() {
        return SessionManager.loadColumnSizes(COLUMN_SIZES);
    }

    private void saveColumnSizes() {
        SessionManager.saveColumnPreferences(this.labelsList.getTable(), COLUMN_SIZES);
    }

    private Table createTable(Composite parent, boolean multiSelect) {
        int flags = 68352;
        if (multiSelect) {
            flags |= 2;
        }
        Table table = new Table(parent, flags);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LabelsViewer.this.saveColumnSizes();
                PerforceUIPlugin.getPlugin().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)LabelsViewer.this);
            }
        });
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        table.setLayoutData((Object)gd);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        SelectionAdapter headerListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableColumn column = (TableColumn)e.widget;
                LabelsViewer.this.sorter.setSortColumn(column.getText());
                LabelsViewer.this.labelsList.refresh();
            }
        };
        this.labelsList = new TableViewer(table);
        this.labelsList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.labelsList.setLabelProvider((IBaseLabelProvider)new LabelsLabelProvider());
        TableColumn labelColumn = this.addColumn(this.labelsList.getTable(), LABEL_COLUMN);
        this.addColumn(this.labelsList.getTable(), OWNER_COLUMN);
        this.addColumn(this.labelsList.getTable(), ACCESS_COLUMN);
        this.addColumn(this.labelsList.getTable(), DESCRIPTION_COLUMN);
        TableColumn[] tableColumnArray = this.labelsList.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.addSelectionListener((SelectionListener)headerListener);
            ++n2;
        }
        table.setSortColumn(labelColumn);
        table.setSortDirection(128);
        Map<String, Integer> columnSizes = this.loadColumnSizes();
        TableColumn[] tableColumnArray2 = this.labelsList.getTable().getColumns();
        int n3 = tableColumnArray2.length;
        n = 0;
        while (n < n3) {
            int size;
            TableColumn column = tableColumnArray2[n];
            int width = 100;
            if (columnSizes.containsKey(column.getText()) && (size = columnSizes.get(column.getText()).intValue()) > 0) {
                width = size;
            }
            layout.addColumnData((ColumnLayoutData)new ColumnPixelData(width, true));
            ++n;
        }
        this.sorter = new LabelSorter(this.labelsList.getTable(), labelColumn.getText());
        this.sorter.setAscending();
        this.labelsList.setSorter((ViewerSorter)this.sorter);
        return table;
    }

    private TableColumn addColumn(Table table, String title) {
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(title);
        return col;
    }

    public void refresh() {
        if (this.connection != null) {
            this.refreshRetrieveCount();
            this.loadLabels();
        }
    }

    private IPreferenceStore getPreferenceStore() {
        return PerforceUIPlugin.getPlugin().getPreferenceStore();
    }

    private int getMaxLabels() {
        return this.getPreferenceStore().getInt("com.perforce.team.ui.preferences.NUM_LABELS_RETRIEVE");
    }

    private void updateDetailsPanel(final IP4Label label) {
        this.labelView.clear();
        if (label != null && label.needsRefresh()) {
            final String name = label.getName();
            P4Runner.schedule((IP4Runnable)new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    label.refresh();
                    if (!label.needsRefresh()) {
                        UIJob job = new UIJob(String.valueOf(Messages.LabelsViewer_UpdatingLabel) + name){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                if (LabelsViewer.this.okToUse() && label == LabelsViewer.this.selectedLabel) {
                                    LabelsViewer.this.updateDetailsPanel(label);
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        job.schedule();
                    }
                }

                public String getTitle() {
                    return String.valueOf(Messages.LabelsViewer_LoadingLabel) + name;
                }
            });
        } else {
            this.labelView.update(label);
            this.updateScrollPanel();
        }
    }

    private void clearDetailsPanel() {
        this.labelView.clear();
        this.updateScrollPanel();
    }

    private void updateScrollPanel() {
        this.detailPanel.setMinSize(this.labelView.getControl().computeSize(-1, -1, true));
    }

    private ScrolledComposite createDetailPanel(Composite parent, Color background) {
        FixedWidthScrolledComposite panel = new FixedWidthScrolledComposite(parent, 2560);
        panel.setLayout((Layout)new FillLayout());
        this.labelView = new LabelWidget((Composite)panel, 10, 10, false);
        panel.setContent((Control)this.labelView.getControl());
        panel.setExpandHorizontal(true);
        panel.setExpandVertical(true);
        panel.setMinSize(this.labelView.getControl().computeSize(-1, -1));
        return panel;
    }

    public void updateSash(boolean displayDetails) {
        if (displayDetails) {
            this.sash.setMaximizedControl(null);
            IP4Label label = this.getSelectedLabel(this.labelsList.getSelection());
            if (label == null) {
                this.clearDetailsPanel();
            } else {
                this.updateDetailsPanel(label);
            }
        } else {
            this.sash.setMaximizedControl((Control)this.viewComposite);
        }
    }

    private void enableFilters(boolean enabled) {
        this.folderFileCombo.setEnabled(enabled);
        this.ownerCombo.setEnabled(enabled);
        this.nameCombo.setEnabled(enabled);
    }

    private boolean checkFilter(String[] paths, String keyword) {
        if (keyword == null) {
            keyword = "";
        }
        if (paths == null) {
            paths = new String[]{""};
        }
        if (paths.length == 1 && paths[0] != null) {
            return paths[0].equals(this.folderFileCombo.getText().trim()) && keyword.equals(this.ownerCombo.getText().trim());
        }
        return false;
    }

    private void updateHistory(String path, String owner, String name) {
        if (path != null && path.length() > 0) {
            SessionManager.saveComboHistory(this.folderFileCombo, 10, FILE_FOLDER_HISTORY);
        }
        if (owner != null && owner.length() > 0) {
            SessionManager.saveComboHistory(this.ownerCombo, 10, OWNER_HISTORY);
        }
        if (name != null && name.length() > 0) {
            SessionManager.saveComboHistory(this.nameCombo, 10, NAME_HISTORY);
        }
    }

    public boolean okToUse() {
        return this.labelsList != null && this.labelsList.getTable() != null && !this.labelsList.getTable().isDisposed();
    }

    private String convertNameContains(String entered) {
        String converted = entered;
        if (converted.length() > 0 && (converted = converted.replace("*", ELLIPSIS)).indexOf(ELLIPSIS) == -1) {
            converted = ELLIPSIS + converted + ELLIPSIS;
        }
        return converted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLabels() {
        String nameContains;
        this.isLoading = true;
        if (this.viewComposite == null || this.viewComposite.isDisposed()) {
            return;
        }
        this.clearDetailsPanel();
        final Object newLoading = new Object();
        LabelsViewer labelsViewer = this;
        synchronized (labelsViewer) {
            this.loading = newLoading;
            this.labelsList.setInput((Object)new Object[]{this.loading});
        }
        String[] paths = null;
        String path = this.folderFileCombo.getText().trim();
        paths = path.length() == 0 ? null : new String[]{path};
        String owner = this.ownerCombo.getText().trim();
        if (owner.length() == 0) {
            owner = null;
        }
        if ((nameContains = this.convertNameContains(this.nameCombo.getText().trim())).length() == 0) {
            nameContains = null;
        }
        final String[] finalPaths = paths;
        final String finalOwner = owner;
        final String finalNameContains = nameContains;
        this.enableFilters(false);
        this.updateHistory(path, owner, nameContains);
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return Messages.LabelsViewer_LoadingLabels;
            }

            public void run(IProgressMonitor monitor) {
                IP4Connection labelConnection = LabelsViewer.this.connection;
                if (labelConnection == null) {
                    LabelsViewer.this.isLoading = false;
                    return;
                }
                final IP4Label[] newLabels = labelConnection.getLabels(finalOwner, finalPaths, LabelsViewer.this.retrieveCount, finalNameContains);
                if (newLoading == LabelsViewer.this.loading) {
                    UIJob job = new UIJob(Messages.LabelsViewer_UpdatingLabelsView){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (LabelsViewer.this.okToUse() && newLoading == LabelsViewer.this.loading && LabelsViewer.this.checkFilter(finalPaths, finalOwner)) {
                                LabelsViewer.this.labelsList.setInput((Object)newLabels);
                                if (LabelsViewer.this.autoSelectFirstEntry && newLabels.length > 0) {
                                    LabelsViewer.this.labelsList.setSelection((ISelection)new StructuredSelection((Object)newLabels[0]));
                                }
                                LabelsViewer.this.enableFilters(true);
                                LabelsViewer.this.isLoading = false;
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
            }
        });
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.labelsList == null || this.labelsList.getTable().isDisposed()) {
            return;
        }
        IP4Label label = this.getSelectedLabel(event.getSelection());
        if (label != null) {
            this.selectedLabel = label;
            this.updateDetailsPanel(label);
        }
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public void refreshRetrieveCount() {
        this.retrieveCount = this.getMaxLabels();
    }

    public void setAutoSelectFirstEntry(boolean autoSelectFirstEntry) {
        this.autoSelectFirstEntry = autoSelectFirstEntry;
    }

    public LabelWidget getDetails() {
        return this.labelView;
    }

    private class LabelsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private Image labelImage = null;

        private LabelsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element == LabelsViewer.this.loading) {
                    if (LabelsViewer.this.loadingImage == null) {
                        LabelsViewer.this.loadingImage = this.getLoadingImage();
                    }
                    return LabelsViewer.this.loadingImage;
                }
                if (this.labelImage == null) {
                    this.labelImage = this.createLabelImage();
                }
                return this.labelImage;
            }
            return null;
        }

        public void dispose() {
            if (this.labelImage != null && !this.labelImage.isDisposed()) {
                this.labelImage.dispose();
                this.labelImage = null;
            }
            if (LabelsViewer.this.loadingImage != null && !LabelsViewer.this.loadingImage.isDisposed()) {
                LabelsViewer.this.loadingImage.dispose();
                LabelsViewer.this.loadingImage = null;
            }
            if (LabelsViewer.this.clearImage != null && !LabelsViewer.this.clearImage.isDisposed()) {
                LabelsViewer.this.clearImage.dispose();
                LabelsViewer.this.clearImage = null;
            }
        }

        private Image getLoadingImage() {
            PerforceUIPlugin plugin = PerforceUIPlugin.getPlugin();
            return plugin.getImageDescriptor("perforce/hourglass.png").createImage();
        }

        private Image createLabelImage() {
            PerforceUIPlugin plugin = PerforceUIPlugin.getPlugin();
            return plugin.getImageDescriptor("views/label.png").createImage();
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element == LabelsViewer.this.loading && columnIndex == 0) {
                return Messages.LabelsViewer_Loading;
            }
            if (element instanceof IP4Label) {
                String value = null;
                IP4Label label = (IP4Label)element;
                switch (columnIndex) {
                    case 0: {
                        value = label.getName();
                        break;
                    }
                    case 1: {
                        value = label.getOwner();
                        break;
                    }
                    case 2: {
                        value = P4UIUtils.formatLabelDate(label.getAccessTime());
                        break;
                    }
                    case 3: {
                        value = label.getDescription();
                        break;
                    }
                }
                if (value != null) {
                    return P4CoreUtils.removeWhitespace((String)value);
                }
            }
            return "";
        }
    }
}

