/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.jobs;

import com.perforce.p4java.core.IJobSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.jobs.BaseJobDialog;
import com.perforce.team.ui.jobs.Messages;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class NewJobDialog
extends BaseJobDialog {
    private IP4Connection connection;
    private IP4Job createdJob;
    private Set<IP4Changelist> addedChangelists;
    private IP4Job template;

    public NewJobDialog(Shell parent, IP4Connection connection, IP4Job template) {
        super(parent);
        this.connection = connection;
        this.template = template;
        if (this.connection != null) {
            this.setTitle(MessageFormat.format(Messages.NewJobDialog_NewJob, connection.getParameters().getPortNoNull(), connection.getParameters().getUserNoNull()));
        }
    }

    @Override
    protected IP4Connection getConnection() {
        return this.connection;
    }

    @Override
    protected void addChangelists(TableViewer viewer) {
    }

    @Override
    protected void setField(Text text, IJobSpec.IJobSpecField field, String preset) {
        String type;
        Object value;
        boolean set = false;
        if (this.template != null && (value = this.template.getField(field.getName())) != null) {
            text.setText(value.toString());
            set = true;
        }
        if ("always".equals(type = field.getFieldType()) || "once".equals(type)) {
            text.setEditable(false);
        }
        if (!set && preset != null) {
            if (!"optional".equals(type)) {
                if ("$blank".equals(preset)) {
                    text.setText(IP4Job.BLANK_VALUE);
                } else if ("$user".equals(preset)) {
                    text.setText(this.getConnection().getParameters().getUserNoNull());
                } else if (!"$now".equals(preset)) {
                    text.setText(preset);
                }
            }
        } else if (101 == field.getCode()) {
            text.setText("new");
        }
    }

    @Override
    protected void setField(Combo combo, IJobSpec.IJobSpecField field, String preset) {
        Object value;
        boolean set = false;
        if (this.template != null && (value = this.template.getField(field.getName())) != null) {
            combo.setText(value.toString());
            set = true;
        }
        if (!set && preset != null) {
            int comma;
            if (102 == field.getCode() && (comma = preset.indexOf(44)) != -1) {
                preset = preset.substring(0, comma);
            }
            combo.setText(preset);
        }
    }

    public void loadFields(Map<String, Object> fields) {
        Widget[] widgets;
        Widget[] widgetArray = widgets = this.getFields();
        int n = widgets.length;
        int n2 = 0;
        while (n2 < n) {
            String value;
            Widget widget = widgetArray[n2];
            IJobSpec.IJobSpecField field = (IJobSpec.IJobSpecField)widget.getData();
            if (field != null && (value = this.getWidgetText(widget, true)) != null) {
                fields.put(field.getName(), value);
            }
            ++n2;
        }
    }

    public IP4Job getCreatedJob() {
        return this.createdJob;
    }

    public IP4Changelist[] getAddedChangelists() {
        return this.addedChangelists != null ? this.addedChangelists.toArray(new IP4Changelist[0]) : null;
    }

    @Override
    public boolean save() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        this.loadFields(fields);
        this.addedChangelists = new HashSet<IP4Changelist>();
        for (IP4Changelist list : this.changelists) {
            if (!this.changelistTable.getChecked((Object)list)) continue;
            this.addedChangelists.add(list);
        }
        boolean retry = true;
        while (retry) {
            retry = false;
            try {
                this.createdJob = this.connection.createJob(fields);
            }
            catch (P4JavaException e) {
                retry = P4ConnectionManager.getManager().displayException(this.connection, e, true, true);
                if (retry) continue;
                return false;
            }
        }
        return true;
    }
}

