/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.jobs;

import com.perforce.p4java.core.IJob;
import com.perforce.p4java.core.IJobSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.Job;
import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.dialogs.P4FormDialog;
import com.perforce.team.ui.jobs.BaseJobDialog;
import com.perforce.team.ui.jobs.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class EditJobDialog
extends BaseJobDialog {
    private IP4Job job;
    private IJob updatedJob;
    private List<IP4Changelist> initialChangelists;
    private Set<IP4Changelist> addedChangelists;
    private Set<IP4Changelist> removedChangelists;

    public EditJobDialog(Shell parent, IP4Job job, IP4Changelist[] changelists) {
        super(parent);
        this.setType(P4FormDialog.Type.EDIT);
        if (job != null && job.getId() != null && job.getConnection() != null) {
            this.job = job;
            ConnectionParameters params = this.job.getConnection().getParameters();
            this.setTitle(MessageFormat.format(Messages.EditJobDialog_EditJobTitle, job.getId(), params.getPortNoNull(), params.getUserNoNull()));
        }
        this.initialChangelists = changelists != null ? Arrays.asList(changelists) : new ArrayList<IP4Changelist>();
    }

    @Override
    protected boolean isReadonly(IJobSpec.IJobSpecField field, String preset) {
        if (field.getCode() == 101) {
            return true;
        }
        return super.isReadonly(field, preset);
    }

    public IJob getUpdatedJob() {
        return this.updatedJob;
    }

    public IP4Changelist[] getAddedChangelists() {
        return this.addedChangelists != null ? this.addedChangelists.toArray(new IP4Changelist[0]) : null;
    }

    public IP4Changelist[] getRemovedChangelists() {
        return this.removedChangelists != null ? this.removedChangelists.toArray(new IP4Changelist[0]) : null;
    }

    @Override
    protected IP4Connection getConnection() {
        IP4Connection connection = null;
        if (this.job != null) {
            connection = this.job.getConnection();
        }
        return connection;
    }

    @Override
    protected void addChangelists(TableViewer viewer) {
        for (IP4Changelist list : this.initialChangelists) {
            this.addChangelist(list, false);
        }
    }

    @Override
    protected void setField(Text text, IJobSpec.IJobSpecField field, String preset) {
        Object fieldValue = this.job.getField(field.getName());
        if (fieldValue != null) {
            text.setText(fieldValue.toString());
        } else if ("always".equals(field.getFieldType()) && preset != null) {
            text.setText(preset);
        }
    }

    public void loadFields(Map<String, Object> fields) {
        Widget[] widgets;
        Widget[] widgetArray = widgets = this.getFields();
        int n = widgets.length;
        int n2 = 0;
        while (n2 < n) {
            Widget widget = widgetArray[n2];
            IJobSpec.IJobSpecField field = (IJobSpec.IJobSpecField)widget.getData();
            if (field != null) {
                String value = null;
                value = field.getCode() != 101 ? this.getWidgetText(widget, true) : this.getWidgetText(widget, false);
                if (value != null) {
                    fields.put(field.getName(), value);
                }
            }
            ++n2;
        }
    }

    public void updateChanges() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        this.loadFields(fields);
        this.updatedJob = new Job(null, fields);
        this.addedChangelists = new HashSet<IP4Changelist>();
        this.removedChangelists = new HashSet<IP4Changelist>();
        for (IP4Changelist list : this.changelists) {
            if (this.initialChangelists.contains(list)) {
                if (this.changelistTable.getChecked((Object)list)) continue;
                this.removedChangelists.add(list);
                continue;
            }
            if (!this.changelistTable.getChecked((Object)list)) continue;
            this.addedChangelists.add(list);
        }
    }

    @Override
    public boolean save() {
        this.updateChanges();
        boolean retry = true;
        while (retry) {
            retry = false;
            try {
                this.job.update(this.updatedJob);
            }
            catch (P4JavaException e) {
                retry = P4ConnectionManager.getManager().displayException(this.job.getConnection(), e, true, true);
                if (retry) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected void setField(Combo combo, IJobSpec.IJobSpecField field, String preset) {
        Object fieldValue = this.job.getField(field.getName());
        if (fieldValue != null) {
            combo.setText(fieldValue.toString());
        }
    }
}

