/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.jobs;

import com.perforce.p4java.core.IJobSpec;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.dialogs.P4FormDialog;
import com.perforce.team.ui.jobs.Messages;
import com.perforce.team.ui.submitted.SubmittedChangelistDialog;
import com.perforce.team.ui.submitted.SubmittedSorter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class BaseJobDialog
extends P4FormDialog {
    protected Composite displayArea;
    protected Composite fieldArea;
    protected Composite singleFieldsArea;
    protected Composite multiFieldsArea;
    protected Composite changelistArea;
    protected CheckboxTableViewer changelistTable;
    private Label changelistLabel;
    private Text changelistText;
    private Button addButton;
    private Button browseButton;
    private List<Widget> fields = new ArrayList<Widget>();
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            BaseJobDialog.this.modified = true;
        }
    };
    protected Set<IP4Changelist> changelists = new HashSet<IP4Changelist>();
    private ITableLabelProvider labelProvider = new ITableLabelProvider(){
        Image submittedIcon = null;
        Image pendingIcon = null;

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
            if (this.submittedIcon != null) {
                this.submittedIcon.dispose();
            }
            if (this.pendingIcon != null) {
                this.pendingIcon.dispose();
            }
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IP4Changelist) {
                IP4Changelist list = (IP4Changelist)element;
                switch (columnIndex) {
                    case 0: {
                        return Integer.toString(list.getId());
                    }
                    case 1: {
                        return list.getDate().toString();
                    }
                    case 2: {
                        return list.getUserName();
                    }
                    case 3: {
                        return P4CoreUtils.removeWhitespace((String)list.getDescription());
                    }
                }
                return "";
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof IP4PendingChangelist) {
                    if (this.pendingIcon == null) {
                        this.pendingIcon = PerforceUIPlugin.getPlugin().getImageDescriptor("perforce/your_pending.png").createImage();
                    }
                    return this.pendingIcon;
                }
                if (element instanceof IP4SubmittedChangelist) {
                    if (this.submittedIcon == null) {
                        this.submittedIcon = PerforceUIPlugin.getPlugin().getImageDescriptor("perforce/submitted.png").createImage();
                    }
                    return this.submittedIcon;
                }
            }
            return null;
        }
    };

    public BaseJobDialog(Shell parent) {
        super(parent);
        this.setModalResizeStyle();
    }

    public BaseJobDialog(Shell parent, String title) {
        super(parent, title);
        this.setModalResizeStyle();
    }

    protected abstract IP4Connection getConnection();

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        this.displayArea = new Composite(c, 0);
        GridLayout daLayout = new GridLayout(1, true);
        daLayout.marginWidth = 0;
        daLayout.marginHeight = 0;
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createFieldArea(this.displayArea);
        this.createChangelistArea(this.displayArea);
        return c;
    }

    private void createFieldArea(Composite parent) {
        IJobSpec spec;
        this.fieldArea = new Composite(parent, 0);
        GridLayout faLayout = new GridLayout(1, true);
        faLayout.marginWidth = 0;
        faLayout.marginHeight = 0;
        this.fieldArea.setLayout((Layout)faLayout);
        this.fieldArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.singleFieldsArea = new Composite(this.fieldArea, 0);
        GridLayout sfaLayout = new GridLayout(2, true);
        sfaLayout.marginHeight = 0;
        sfaLayout.marginWidth = 0;
        this.singleFieldsArea.setLayout((Layout)sfaLayout);
        this.singleFieldsArea.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout twoDiffLayout = new GridLayout(2, false);
        twoDiffLayout.marginHeight = 0;
        twoDiffLayout.marginWidth = 0;
        Composite leftSide = new Composite(this.singleFieldsArea, 0);
        leftSide.setLayout((Layout)twoDiffLayout);
        leftSide.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite rightSide = new Composite(this.singleFieldsArea, 0);
        rightSide.setLayout((Layout)twoDiffLayout);
        rightSide.setLayoutData((Object)new GridData(4, 4, true, true));
        this.multiFieldsArea = new Composite(this.fieldArea, 0);
        this.multiFieldsArea.setLayout((Layout)twoDiffLayout);
        this.multiFieldsArea.setLayoutData((Object)new GridData(4, 4, true, true));
        IP4Connection conn = this.getConnection();
        if (conn != null && (spec = conn.getJobSpec()) != null) {
            List fields = spec.getFields();
            int singleFields = 0;
            for (IJobSpec.IJobSpecField field : fields) {
                if ("text".equals(field.getDataType())) continue;
                ++singleFields;
            }
            int left = 0;
            for (IJobSpec.IJobSpecField field : fields) {
                if ("text".equals(field.getDataType())) {
                    this.addMultiField(this.multiFieldsArea, field, spec.getFieldPreset(field.getName()));
                    continue;
                }
                if (left < singleFields / 2) {
                    ++left;
                    this.addSingleField(leftSide, field, spec.getFieldValues(field.getName()), spec.getFieldPreset(field.getName()));
                    continue;
                }
                this.addSingleField(rightSide, field, spec.getFieldValues(field.getName()), spec.getFieldPreset(field.getName()));
            }
        }
    }

    protected boolean isReadonly(IJobSpec.IJobSpecField field, String preset) {
        return "always".equals(field.getFieldType()) || "once".equals(field.getFieldType());
    }

    private void addSingleField(Composite parent, IJobSpec.IJobSpecField field, List<String> values, String preset) {
        Label label = new Label(parent, 16384);
        label.setText(String.valueOf(field.getName()) + ":");
        if ("select".equals(field.getDataType())) {
            Combo combo = new Combo(parent, 2060);
            combo.setData((Object)field);
            combo.setLayoutData((Object)new GridData(4, 4, true, false));
            combo.add(Messages.BaseJobDialog_NoneSelected);
            combo.select(0);
            if (values != null) {
                for (String value : values) {
                    combo.add(value);
                }
            }
            this.setField(combo, field, preset);
            combo.addModifyListener(this.modifyListener);
            this.addField((Widget)combo);
        } else {
            int flags = 4;
            flags = this.isReadonly(field, preset) ? (flags |= 8) : (flags |= 0x800);
            Text text = new Text(parent, flags);
            text.setData((Object)field);
            text.setLayoutData((Object)new GridData(4, 4, true, false));
            this.setField(text, field, preset);
            text.addModifyListener(this.modifyListener);
            this.addField((Widget)text);
            if (101 == field.getCode()) {
                this.addFormNameValidation(text, "job");
            }
        }
    }

    private void addMultiField(Composite parent, IJobSpec.IJobSpecField field, String preset) {
        Label label = new Label(parent, 16384);
        label.setText(String.valueOf(field.getName()) + ":");
        label.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        Text text = new Text(parent, 2562);
        text.setData((Object)field);
        GridData tData = new GridData(4, 4, true, true);
        tData.heightHint = 105 == field.getCode() ? 90 : 40;
        text.setLayoutData((Object)tData);
        if (this.isReadonly(field, preset)) {
            text.setEditable(false);
        }
        this.setField(text, field, preset);
        text.addModifyListener(this.modifyListener);
        this.addField((Widget)text);
    }

    private void createChangelistTable(Composite parent) {
        this.changelistTable = CheckboxTableViewer.newCheckList((Composite)parent, (int)68356);
        this.changelistTable.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.changelistTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        GridData ctData = new GridData(4, 4, true, true);
        ctData.heightHint = 80;
        this.changelistTable.getTable().setLayoutData((Object)ctData);
        this.changelistTable.getTable().setHeaderVisible(true);
        TableColumn sortColumn = this.addColumn(this.changelistTable.getTable(), SubmittedSorter.CHANGELIST, 100);
        this.addColumn(this.changelistTable.getTable(), SubmittedSorter.DATE, 100);
        this.addColumn(this.changelistTable.getTable(), SubmittedSorter.USER, 100);
        this.addColumn(this.changelistTable.getTable(), SubmittedSorter.DESCRIPTION, 200);
        SubmittedSorter sorter = new SubmittedSorter(this.changelistTable.getTable());
        sorter.init((TableViewer)this.changelistTable, sortColumn, 1024);
        this.changelistTable.setSorter((ViewerSorter)sorter);
        this.addChangelists((TableViewer)this.changelistTable);
        this.changelistTable.setInput(this.changelists);
        this.changelistTable.setAllChecked(true);
    }

    public void addChangelist(IP4Changelist changelist, boolean refresh) {
        if (changelist != null) {
            this.changelists.add(changelist);
            if (refresh) {
                this.changelistTable.refresh();
                this.changelistTable.setChecked((Object)changelist, true);
            }
        }
    }

    public void removeChangelist(IP4Changelist changelist, boolean refresh) {
        if (changelist != null) {
            this.changelists.remove(changelist);
            if (refresh) {
                this.changelistTable.refresh();
            }
        }
    }

    protected abstract void setField(Text var1, IJobSpec.IJobSpecField var2, String var3);

    protected abstract void setField(Combo var1, IJobSpec.IJobSpecField var2, String var3);

    protected abstract void addChangelists(TableViewer var1);

    private TableColumn addColumn(Table table, String text, int width) {
        TableColumn column = new TableColumn(table, 16384);
        column.setText(text);
        column.setWidth(width);
        return column;
    }

    private void createChangelistArea(Composite parent) {
        this.changelistArea = new Composite(parent, 0);
        GridLayout caLayout = new GridLayout(1, true);
        caLayout.marginHeight = 0;
        caLayout.marginWidth = 0;
        this.changelistArea.setLayout((Layout)caLayout);
        this.changelistArea.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createChangelistTable(this.changelistArea);
        Composite addArea = new Composite(parent, 0);
        GridLayout aaLayout = new GridLayout(4, false);
        aaLayout.marginHeight = 0;
        aaLayout.marginWidth = 0;
        addArea.setLayout((Layout)aaLayout);
        addArea.setLayoutData((Object)new GridData(4, 4, true, false));
        this.changelistLabel = new Label(addArea, 16384);
        this.changelistLabel.setText(Messages.BaseJobDialog_Changelist);
        this.changelistText = new Text(addArea, 2052);
        this.changelistText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addButton = new Button(addArea, 8);
        this.addButton.setText(Messages.BaseJobDialog_Add);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String id = BaseJobDialog.this.changelistText.getText().trim();
                try {
                    IP4Changelist changelist;
                    int listId = Integer.parseInt(id);
                    IP4Changelist iP4Changelist = changelist = BaseJobDialog.this.getConnection() == null ? null : BaseJobDialog.this.getConnection().getChangelistById(listId, null, false, true);
                    if (changelist != null) {
                        BaseJobDialog.this.addChangelist(changelist, true);
                    } else {
                        MessageDialog.openError((Shell)BaseJobDialog.this.getShell(), (String)Messages.BaseJobDialog_ChangelistNotFoundTitle, (String)MessageFormat.format(Messages.BaseJobDialog_ChangelistNotFoundMessage, listId));
                    }
                }
                catch (NumberFormatException e1) {
                    MessageDialog.openError((Shell)BaseJobDialog.this.getShell(), (String)Messages.BaseJobDialog_InvalidChangelistTitle, (String)MessageFormat.format(Messages.BaseJobDialog_InvalidChangelistMessage, Integer.MAX_VALUE));
                }
            }
        });
        this.browseButton = new Button(addArea, 8);
        this.browseButton.setText(Messages.BaseJobDialog_Browse);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SubmittedChangelistDialog dialog = new SubmittedChangelistDialog(BaseJobDialog.this.browseButton.getShell(), BaseJobDialog.this.getConnection());
                if (dialog.open() == 0) {
                    IP4SubmittedChangelist[] iP4SubmittedChangelistArray = dialog.getSelected();
                    int n = iP4SubmittedChangelistArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IP4SubmittedChangelist selected = iP4SubmittedChangelistArray[n2];
                        BaseJobDialog.this.addChangelist((IP4Changelist)selected, true);
                        ++n2;
                    }
                }
            }
        });
    }

    protected void addField(Widget field) {
        this.fields.add(field);
    }

    protected String getWidgetText(Widget widget, boolean checkReadOnly) {
        String text = null;
        if (widget instanceof Combo) {
            if (((Combo)widget).getSelectionIndex() > 0) {
                text = ((Combo)widget).getText();
            }
        } else if (widget instanceof Text && (!checkReadOnly || (widget.getStyle() & 8) == 0)) {
            text = ((Text)widget).getText();
        }
        return text;
    }

    public Widget[] getFields() {
        return this.fields.toArray(new Widget[0]);
    }

    public CheckboxTableViewer getChangelistViewer() {
        return this.changelistTable;
    }

    @Override
    protected String getModelLabel() {
        return Messages.BaseJobDialog_Job;
    }
}

