/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.editor;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.ui.editor.IContentAssistProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public final class ContentAssistRegistry {
    public static final String CONTENT_ASSIST_EXTENSION_POINT = "com.perforce.team.ui.contentAssist";
    public static final String ASSIST_ELEMENT = "provider";
    public static final String CONTEXT_ATTRIBUTE = "context";
    public static final String CLASS_ATTRIBUTE = "class";
    private static ContentAssistRegistry registry;
    private Map<String, List<IContentAssistProvider>> contextToProviders = new HashMap<String, List<IContentAssistProvider>>();

    public static synchronized ContentAssistRegistry getRegistry() {
        if (registry == null) {
            registry = new ContentAssistRegistry();
        }
        return registry;
    }

    private ContentAssistRegistry() {
        this.loadExtensionPoints();
    }

    public IContentAssistProvider[] getProviders(String context) {
        List<IContentAssistProvider> contextProviders;
        IContentAssistProvider[] providers = null;
        if (context != null && (contextProviders = this.contextToProviders.get(context)) != null) {
            providers = contextProviders.toArray(new IContentAssistProvider[contextProviders.size()]);
        }
        if (providers == null) {
            providers = new IContentAssistProvider[]{};
        }
        return providers;
    }

    private void loadExtensionPoints() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(CONTENT_ASSIST_EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (ASSIST_ELEMENT.equals(element.getName())) {
                String context = element.getAttribute(CONTEXT_ATTRIBUTE);
                String providerClass = element.getAttribute(CLASS_ATTRIBUTE);
                if (context != null && providerClass != null) {
                    try {
                        Object provider = element.createExecutableExtension(CLASS_ATTRIBUTE);
                        if (provider instanceof IContentAssistProvider) {
                            List<IContentAssistProvider> providers = this.contextToProviders.get(context);
                            if (providers == null) {
                                providers = new ArrayList<IContentAssistProvider>();
                                this.contextToProviders.put(context, providers);
                            }
                            providers.add((IContentAssistProvider)provider);
                        }
                    }
                    catch (CoreException e) {
                        PerforceProviderPlugin.logError((Throwable)e);
                    }
                }
            }
            ++n2;
        }
    }
}

