/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.dialogs;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.PerforceLabelProvider;
import com.perforce.team.ui.changelists.PendingCombo;
import com.perforce.team.ui.dialogs.Messages;
import com.perforce.team.ui.dialogs.P4StatusDialog;
import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RefactorDialog
extends P4StatusDialog {
    private IP4Connection connection;
    private IResource source;
    private IResource destination;
    private boolean useSelected = false;
    private PendingCombo pendingCombo;

    public RefactorDialog(Shell parent, IResource source, IResource destination, IP4Connection connection) {
        super(parent, Messages.RefactorDialog_SelectRefactorChangelist);
        this.setModalResizeStyle();
        this.source = source;
        this.destination = destination;
        this.connection = connection;
    }

    public boolean useSelected() {
        return this.useSelected;
    }

    public int getPendingId() {
        return this.pendingCombo.getSelected();
    }

    public String getPendingComment() {
        return this.pendingCombo.getDescription();
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        Composite displayArea = new Composite(c, 0);
        GridLayout daLayout = new GridLayout(2, false);
        displayArea.setLayout((Layout)daLayout);
        GridData daData = new GridData(4, 4, true, true);
        daData.heightHint = 150;
        displayArea.setLayoutData((Object)daData);
        GridData twoColData = new GridData(4, 4, true, false);
        twoColData.horizontalSpan = 2;
        String comment = MessageFormat.format(Messages.RefactorDialog_RefactoringFilesFromTo, this.source.getProjectRelativePath().toString(), this.destination.getProjectRelativePath().toString());
        this.pendingCombo = new PendingCombo(Messages.RefactorDialog_OpenInChangelist, (IP4Resource)this.connection);
        this.pendingCombo.createControl(displayArea, 2, comment);
        final PerforceLabelProvider provider = new PerforceLabelProvider(true);
        displayArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                provider.dispose();
            }
        });
        Image sourceImage = provider.getImage(this.source);
        Label fromIcon = new Label(displayArea, 16384);
        fromIcon.setImage(sourceImage);
        Label fromPath = new Label(displayArea, 64);
        fromPath.setText(MessageFormat.format(Messages.RefactorDialog_From, this.source.getProjectRelativePath().toOSString()));
        fromPath.setLayoutData((Object)new GridData(4, 4, true, false));
        Image destinationImage = provider.getImage(this.destination);
        Label toIcon = new Label(displayArea, 64);
        toIcon.setImage(destinationImage);
        Label toPath = new Label(displayArea, 16384);
        toPath.setText(MessageFormat.format(Messages.RefactorDialog_To, this.destination.getProjectRelativePath().toOSString()));
        toPath.setLayoutData((Object)new GridData(4, 4, true, false));
        final Button useSelectedButton = new Button(displayArea, 32);
        useSelectedButton.setText(Messages.RefactorDialog_UseSelectedChangelistUntilSubmitted);
        useSelectedButton.setLayoutData((Object)twoColData);
        useSelectedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefactorDialog.this.useSelected = useSelectedButton.getSelection();
            }
        });
        return c;
    }
}

