/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.dialogs;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.dialogs.Messages;
import com.perforce.team.ui.p4java.dialogs.ChangeSpecDialog;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;

public class JobListViewer {
    private ChangeSpecDialog parentDialog;
    private static final int DEFAULT_WIDTH = 500;
    private static final int DEFAULT_HEIGHT = 75;
    private TableViewer jobsTable;

    public JobListViewer(Composite parent, ChangeSpecDialog dialog, Set<IP4Job> jobs) {
        this.jobsTable = new TableViewer(parent, 67586);
        this.parentDialog = dialog;
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 500;
        data.heightHint = 75;
        this.jobsTable.getControl().setLayoutData((Object)data);
        this.jobsTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.jobsTable.setLabelProvider((IBaseLabelProvider)new JobListLabelProvider());
        final Action unfixAction = new Action(Messages.JobListViewer_RemoveFromChangelist, PerforceUIPlugin.getPlugin().getImageDescriptor("normal/delete.png")){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)JobListViewer.this.jobsTable.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    List jobList = selection.toList();
                    IP4Job[] jobs = jobList.toArray(new IP4Job[jobList.size()]);
                    JobListViewer.this.parentDialog.removeJobs(jobs);
                }
            }
        };
        MenuManager manager = new MenuManager();
        Table tab = this.jobsTable.getTable();
        Menu menu = manager.createContextMenu((Control)tab);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (JobListViewer.this.jobsTable.getTable().getSelectionCount() > 0) {
                    manager.add((IAction)unfixAction);
                }
            }
        });
        manager.setRemoveAllWhenShown(true);
        tab.setMenu(menu);
        this.jobsTable.setInput(jobs);
    }

    public void refresh() {
        if (this.jobsTable != null) {
            this.jobsTable.refresh();
        }
    }

    public Control getControl() {
        Control control = null;
        if (this.jobsTable != null) {
            control = this.jobsTable.getControl();
        }
        return control;
    }

    public IP4Job[] getSelectedJobs() {
        IStructuredSelection selection = (IStructuredSelection)this.jobsTable.getSelection();
        Object[] selected = selection.toArray();
        IP4Job[] jobs = new IP4Job[selected.length];
        System.arraycopy(selected, 0, jobs, 0, selected.length);
        return jobs;
    }

    public void remove(IP4Job job) {
        if (this.jobsTable != null && job != null) {
            this.jobsTable.remove((Object)job);
        }
    }

    public void remove(IP4Job[] jobs) {
        if (this.jobsTable != null && jobs != null) {
            this.jobsTable.remove((Object[])jobs);
        }
    }

    public void add(IP4Job job) {
        if (this.jobsTable != null && job != null) {
            this.jobsTable.add((Object)job);
        }
    }

    public void add(IP4Job[] jobs) {
        if (this.jobsTable != null && jobs != null) {
            this.jobsTable.add((Object[])jobs);
        }
    }

    private static class JobListLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private Image jobImage = null;

        private JobListLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (this.jobImage == null) {
                    this.jobImage = this.getJobImage();
                }
                return this.jobImage;
            }
            return null;
        }

        public void dispose() {
            if (this.jobImage != null) {
                this.jobImage.dispose();
                this.jobImage = null;
            }
        }

        private Image getJobImage() {
            PerforceUIPlugin plugin = PerforceUIPlugin.getPlugin();
            return plugin.getImageDescriptor("perforce/job.png").createImage();
        }

        public String getColumnText(Object element, int columnIndex) {
            IP4Job job = (IP4Job)element;
            String text = job.getId();
            String desc = job.getShortDescription();
            if (desc != null) {
                text = String.valueOf(text) + " - " + P4CoreUtils.removeWhitespace((String)desc);
            }
            return text;
        }
    }
}

