/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.dialogs;

import com.perforce.team.ui.dialogs.DialogUtils;
import com.perforce.team.ui.dialogs.Messages;
import com.perforce.team.ui.dialogs.PerforcePreferencesDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.PlatformUI;

public class GeneralPreferencesDialog
extends PerforcePreferencesDialog {
    public static final String ID = "com.perforce.team.ui.dialogs.GeneralPreferencesDialog";
    private Button showMarkers;
    private Button openForAdd;
    private Button openDefault;
    private Button openRefactor;
    private Button noAction;
    private Button refactorSupport;
    private Button saveRefactorSupport;
    private Button useMoveCommand;
    private Button deleteProject;
    private Button logCommand;
    private Button persistOfflineStateButton;
    private Button saveExpandedDepotsButton;
    private Button deleteLinkedResources;
    private Button enableChangesets;
    private Button enablePromptOnRemove;
    private Button enableTeamRefresh;
    private Button disableMarkerDecoration;

    public GeneralPreferencesDialog() {
        super(1);
    }

    @Override
    public boolean performOk() {
        this.setPrefBoolean("pref_show_markers", this.showMarkers.getSelection());
        this.setPrefBoolean("pref_new_open_add", this.openForAdd.getSelection());
        this.setPrefBoolean("pref_open_default", this.openDefault.getSelection());
        this.setPrefBoolean("com.perforce.team.ui.preferences.REFACTOR_DIALOG", this.openRefactor.getSelection());
        this.setPrefBoolean("pref_refactor_support", this.refactorSupport.getSelection());
        this.setPrefBoolean("pref_refactor_save_support", this.saveRefactorSupport.getSelection());
        this.setPrefBoolean("pref_refactor_use_move", this.useMoveCommand.getSelection());
        this.setPrefBoolean("pref_delete_project_files", this.deleteProject.getSelection());
        this.setPrefBoolean("PREF_DELETE_LINKED_RESOURCES", this.deleteLinkedResources.getSelection());
        this.setPrefBoolean("com.perforce.team.ui.preferences.SHOW_CHANGE_SETS", this.enableChangesets.getSelection());
        this.setPrefBoolean("pref_log_command", this.logCommand.getSelection());
        this.setPrefBoolean("pref_disable_marker_decoration", this.disableMarkerDecoration.getSelection());
        this.setPrefBoolean("com.perforce.team.ui.preferences.PERSIST_OFFINE", this.persistOfflineStateButton.getSelection());
        this.setPrefBoolean("com.perforce.team.ui.preferences.SAVE_EXPANDED_DEPOTS", this.saveExpandedDepotsButton.getSelection());
        this.setPrefBoolean("pref_prompt_on_deleting_managed_folders", this.enablePromptOnRemove.getSelection());
        this.setPrefBoolean("pref_refresh_revision_on_refresh", this.enableTeamRefresh.getSelection());
        return true;
    }

    @Override
    protected void performDefaults() {
        this.showMarkers.setSelection(false);
        this.openForAdd.setSelection(false);
        this.noAction.setSelection(false);
        this.disableMarkerDecoration.setSelection(false);
        if (this.getPrefDefBoolean("pref_show_markers")) {
            this.showMarkers.setSelection(true);
        } else if (this.getPrefDefBoolean("pref_new_open_add")) {
            this.openForAdd.setSelection(true);
        } else {
            this.noAction.setSelection(true);
        }
        this.openDefault.setSelection(this.getPrefDefBoolean("pref_open_default"));
        this.openRefactor.setSelection(this.getPrefDefBoolean("com.perforce.team.ui.preferences.REFACTOR_DIALOG"));
        this.refactorSupport.setSelection(this.getPrefDefBoolean("pref_refactor_support"));
        this.deleteProject.setSelection(this.getPrefDefBoolean("pref_delete_project_files"));
        this.deleteLinkedResources.setSelection(this.getPrefDefBoolean("PREF_DELETE_LINKED_RESOURCES"));
        this.enableChangesets.setSelection(this.getPrefDefBoolean("com.perforce.team.ui.preferences.SHOW_CHANGE_SETS"));
        this.disableMarkerDecoration.setSelection(this.getPrefDefBoolean("pref_disable_marker_decoration"));
        this.logCommand.setSelection(this.getPrefDefBoolean("pref_log_command"));
        this.persistOfflineStateButton.setSelection(this.getPrefDefBoolean("com.perforce.team.ui.preferences.PERSIST_OFFINE"));
        this.saveExpandedDepotsButton.setSelection(this.getPrefDefBoolean("com.perforce.team.ui.preferences.SAVE_EXPANDED_DEPOTS"));
        this.useMoveCommand.setSelection(this.getPrefDefBoolean("pref_refactor_use_move"));
        this.saveRefactorSupport.setSelection(this.getPrefDefBoolean("pref_refactor_save_support"));
        this.enablePromptOnRemove.setSelection(this.getPrefDefBoolean("pref_prompt_on_deleting_managed_folders"));
        this.enableTeamRefresh.setSelection(this.getPrefDefBoolean("pref_refresh_revision_on_refresh"));
    }

    protected Control createContents(Composite parent) {
        Composite composite = DialogUtils.createComposite(parent);
        DialogUtils.createLabel(composite, Messages.GeneralPreferencesDialog_GeneralSettings);
        this.createAddingFileGroup(composite);
        DialogUtils.createBlank(composite);
        this.openDefault = DialogUtils.createCheck(composite, Messages.GeneralPreferencesDialog_ShowChangelistSelectionWhenMarkingFiles);
        this.openRefactor = DialogUtils.createCheck(composite, Messages.GeneralPreferencesDialog_ShowChangelistSelectionWhenRefactoring);
        this.refactorSupport = DialogUtils.createCheck(composite, Messages.GeneralPreferencesDialog_EnableEditDeleteRenameRefactorOps);
        this.saveRefactorSupport = DialogUtils.createCheck(composite, Messages.GeneralPreferencesDialog_EnableSaveOps);
        this.useMoveCommand = DialogUtils.createCheck(composite, Messages.GeneralPreferencesDialog_UseMoveForRefactoring);
        this.deleteProject = DialogUtils.createCheck(composite, Messages.GeneralPreferencesDialog_MarkForDeleteWhenDeletingProject);
        this.deleteLinkedResources = DialogUtils.createCheck(composite, Messages.GeneralPreferencesDialog_MarkForDeleteWhenDeletingLinkedResources);
        this.disableMarkerDecoration = DialogUtils.createCheck(composite, Messages.GeneralPreferencesDialog_DisableMarkerDecoration);
        this.logCommand = DialogUtils.createCheck(composite, Messages.GeneralPreferencesDialog_LogAllCommands);
        this.persistOfflineStateButton = DialogUtils.createCheck(composite, Messages.GeneralPreferencesDialog_RetainOfflineState);
        this.saveExpandedDepotsButton = DialogUtils.createCheck(composite, Messages.GeneralPreferencesDialog_RetainExpandedFolders);
        this.enableChangesets = DialogUtils.createCheck(composite, Messages.GeneralPreferencesDialog_GroupSyncsByChangelist);
        this.enablePromptOnRemove = DialogUtils.createCheck(composite, Messages.GeneralPreferencesDialog_PromptOnRemove);
        this.enableTeamRefresh = DialogUtils.createCheck(composite, Messages.GeneralPreferencesDialog_RefreshRevisionWhenRefresh);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.openDefault, "com.perforce.team.ui.pref_open_default");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.refactorSupport, "com.perforce.team.ui.pref_refactor_support");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.deleteProject, "com.perforce.team.ui.pref_delete_project_files");
        this.initialiseValues();
        return composite;
    }

    private void initialiseValues() {
        if (this.getPrefBoolean("pref_show_markers")) {
            this.showMarkers.setSelection(true);
        } else if (this.getPrefBoolean("pref_new_open_add")) {
            this.openForAdd.setSelection(true);
        } else {
            this.noAction.setSelection(true);
        }
        this.openDefault.setSelection(this.getPrefBoolean("pref_open_default"));
        this.openRefactor.setSelection(this.getPrefBoolean("com.perforce.team.ui.preferences.REFACTOR_DIALOG"));
        this.refactorSupport.setSelection(this.getPrefBoolean("pref_refactor_support"));
        this.saveRefactorSupport.setSelection(this.getPrefBoolean("pref_refactor_save_support"));
        this.useMoveCommand.setSelection(this.getPrefBoolean("pref_refactor_use_move"));
        this.deleteProject.setSelection(this.getPrefBoolean("pref_delete_project_files"));
        this.deleteLinkedResources.setSelection(this.getPrefBoolean("PREF_DELETE_LINKED_RESOURCES"));
        this.enableChangesets.setSelection(this.getPrefBoolean("com.perforce.team.ui.preferences.SHOW_CHANGE_SETS"));
        this.disableMarkerDecoration.setSelection(this.getPrefBoolean("pref_disable_marker_decoration"));
        this.logCommand.setSelection(this.getPrefBoolean("pref_log_command"));
        this.persistOfflineStateButton.setSelection(this.getPrefBoolean("com.perforce.team.ui.preferences.PERSIST_OFFINE"));
        this.saveExpandedDepotsButton.setSelection(this.getPrefBoolean("com.perforce.team.ui.preferences.SAVE_EXPANDED_DEPOTS"));
        this.enablePromptOnRemove.setSelection(this.getPrefBoolean("pref_prompt_on_deleting_managed_folders"));
        this.enableTeamRefresh.setSelection(this.getPrefBoolean("pref_refresh_revision_on_refresh"));
    }

    private void createAddingFileGroup(Composite parent) {
        Group group = DialogUtils.createGroup(parent, Messages.GeneralPreferencesDialog_WhenAddingNewFile, 1);
        this.openForAdd = DialogUtils.createRadio((Composite)group, Messages.GeneralPreferencesDialog_MarkForAdd);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.openForAdd, "com.perforce.team.ui.pref_new_open_add");
        this.showMarkers = DialogUtils.createRadio((Composite)group, Messages.GeneralPreferencesDialog_CreateMarker);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.showMarkers, "com.perforce.team.ui.pref_markers_enabled");
        this.noAction = DialogUtils.createRadio((Composite)group, Messages.GeneralPreferencesDialog_TakeNoAction);
    }
}

