/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.connection.mfa;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.connection.mfa.AuthResult;
import com.perforce.team.ui.connection.mfa.MFAAppRunner;
import com.perforce.team.ui.connection.mfa.MFARunStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Shell;

public class MFAUtil {
    public static boolean doMFA(Shell shell, boolean canDoIt, IP4Connection conn) {
        MFAAppRunner runner;
        AuthResult<Integer> res;
        if (canDoIt && !(res = (runner = new MFAAppRunner()).run(conn, conn.getParameters().getPort(), conn.getParameters().getUser(), "", "")).isSuccessful()) {
            if (res.getResultData().intValue() == MFARunStatus.APPNOTFOUND.getStatus()) {
                PreferenceDialog pd;
                if (MessageDialog.openConfirm((Shell)shell, (String)"MFA App not installed", (String)(String.valueOf(res.getMessage()) + "\nPress OK to configure it.")) && (pd = P4UIUtils.openPreferencePage("com.perforce.team.ui.preferences.ExternalToolsPreferencePage", true)).getReturnCode() > -1) {
                    return res.isSuccessful();
                }
            } else {
                MessageDialog.openConfirm((Shell)shell, (String)"Authentication failure", (String)res.getMessage());
                return res.isSuccessful();
            }
        }
        return canDoIt;
    }
}

