/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.connection;

import com.perforce.p4java.server.IServer;
import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.P4BrowsableConnection;
import com.perforce.team.core.p4java.P4Connection;
import com.perforce.team.core.p4java.P4ServerConnection;
import com.perforce.team.ui.connection.AbstractConnectionWizard;
import com.perforce.team.ui.connection.IConnectionWizard;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;

public abstract class BaseConnectionWizardPage
extends WizardPage {
    protected BaseConnectionWizardPage(String pageName) {
        super(pageName);
    }

    protected ConnectionParameters getCurrentParams() {
        return this.getCurrentParams(false);
    }

    protected ConnectionParameters getCurrentParams(boolean ignoreClient) {
        ConnectionParameters params = new ConnectionParameters();
        params.setUser(this.getUser());
        if (!ignoreClient) {
            params.setClient(this.getClient());
        }
        params.setPort(this.getPort());
        params.setCharset(this.getCharset());
        params.setPassword(this.getPassword());
        params.setIgnoreSSLValidation(this.isIgnoreSSLValidation());
        params.setAuthTicket(((IConnectionWizard)this.getWizard()).getAuthTicket());
        return params;
    }

    protected IP4Connection createConnection() {
        return this.createConnection(false, false);
    }

    protected IP4Connection createConnection(boolean ignoreClient, boolean serverOnly) {
        Object connection = null;
        ConnectionParameters params = this.getCurrentParams(ignoreClient);
        connection = !serverOnly ? new P4Connection(params) : new P4ServerConnection(params);
        return connection;
    }

    protected P4BrowsableConnection createBrowseConnection() {
        ConnectionParameters params = this.getCurrentParams();
        P4BrowsableConnection connection = new P4BrowsableConnection(params);
        return connection;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public String getPort() {
        return ((IConnectionWizard)this.getWizard()).getPort();
    }

    public String getUser() {
        return ((IConnectionWizard)this.getWizard()).getUser();
    }

    public String getClient() {
        return ((IConnectionWizard)this.getWizard()).getClient();
    }

    public String getPassword() {
        return ((IConnectionWizard)this.getWizard()).getPassword();
    }

    public boolean isIgnoreSSLValidation() {
        return ((IConnectionWizard)this.getWizard()).isIgnoreSSLValidation();
    }

    public String getCharset() {
        return ((IConnectionWizard)this.getWizard()).getCharset();
    }

    protected void updateAuthTicket(IP4Connection connection) {
        String ticket;
        IServer server;
        if (connection != null && (server = connection.getServer()) != null && (ticket = server.getAuthTicket()) != null) {
            this.updateAuthTicket(ticket);
        }
    }

    protected void updateAuthTicket(String ticket) {
        ((IConnectionWizard)this.getWizard()).setAuthTicket(ticket);
    }

    protected IP4Connection getWizardConnection() {
        IWizard wizard = this.getWizard();
        if (wizard instanceof AbstractConnectionWizard) {
            return ((AbstractConnectionWizard)wizard).getConnection();
        }
        return null;
    }

    protected void setWizardConnection(IP4Connection conn) {
        IWizard wizard = this.getWizard();
        if (wizard instanceof AbstractConnectionWizard) {
            ((AbstractConnectionWizard)wizard).setConnection(conn);
        }
    }
}

