/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.changelists;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4ShelvedChangelist;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.ui.changelists.Messages;
import com.perforce.team.ui.diff.DiffLabelProvider;
import java.text.MessageFormat;

public class ChangelistLabelProvider
extends DiffLabelProvider {
    public ChangelistLabelProvider(boolean decorateResources) {
        super(decorateResources, false, true);
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        IP4File file = (IP4File)P4CoreUtils.convert((Object)element, IP4File.class);
        if (file != null) {
            return file.getRemotePath();
        }
        IP4Changelist list = (IP4Changelist)P4CoreUtils.convert((Object)element, IP4Changelist.class);
        if (list instanceof IP4PendingChangelist) {
            if (list.isDefault()) {
                return Messages.ChangelistLabelProvider_DefaultChange;
            }
            int id = list.getId();
            if (id > 0) {
                return MessageFormat.format(Messages.ChangelistLabelProvider_ChangeNumber, id);
            }
            return Messages.ChangelistLabelProvider_Change;
        }
        if (list instanceof IP4SubmittedChangelist) {
            int id = list.getId();
            if (id > 0) {
                return MessageFormat.format(Messages.ChangelistLabelProvider_ChangeNumber, id);
            }
            return Messages.ChangelistLabelProvider_Change;
        }
        if (list instanceof IP4ShelvedChangelist) {
            return Messages.ChangelistLabelProvider_ShelvedFiles;
        }
        return super.getColumnText(element, columnIndex);
    }
}

