/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.changelists;

import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.changelists.Messages;
import com.perforce.team.ui.jobs.JobsWidget;
import com.perforce.team.ui.p4java.actions.FixJobAction;
import com.perforce.team.ui.p4java.actions.UnfixJobAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ChangelistJobsWidget
extends JobsWidget {
    private IP4Changelist changelist;

    public ChangelistJobsWidget(IP4Changelist changelist, boolean enableEdit) {
        super(enableEdit);
        this.changelist = changelist;
    }

    private IP4Job[] getSelectedJobs() {
        ArrayList<IP4Job> jobs = new ArrayList<IP4Job>();
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IP4Job) {
                jobs.add((IP4Job)element);
            }
            ++n2;
        }
        return jobs.toArray(new IP4Job[jobs.size()]);
    }

    @Override
    protected void fillToolbar(ToolBar toolbar) {
        super.fillToolbar(toolbar);
        ToolItem addFixItem = new ToolItem(toolbar, 8);
        addFixItem.setToolTipText(Messages.ChangelistJobsWidget_AddJob);
        Image addImage = PerforceUIPlugin.getDescriptor("normal/add.png").createImage();
        P4UIUtils.registerDisposal((Widget)addFixItem, (Resource)addImage);
        addFixItem.setImage(addImage);
        addFixItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FixJobAction fix = new FixJobAction();
                fix.selectionChanged(null, (ISelection)new StructuredSelection((Object)ChangelistJobsWidget.this.changelist));
                fix.run(null);
            }
        });
        ToolItem removeFixItem = new ToolItem(toolbar, 8);
        removeFixItem.setToolTipText(Messages.ChangelistJobsWidget_RemoveSelectedJobs);
        Image removeImage = PerforceUIPlugin.getDescriptor("normal/delete.png").createImage();
        P4UIUtils.registerDisposal((Widget)removeFixItem, (Resource)removeImage);
        removeFixItem.setImage(removeImage);
        removeFixItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IP4Job[] jobs = ChangelistJobsWidget.this.getSelectedJobs();
                if (jobs.length > 0) {
                    StringBuilder title = new StringBuilder(Messages.ChangelistJobsWidget_ConfirmJobRemoval);
                    String message = MessageFormat.format(Messages.ChangelistJobsWidget_RemoveJobsFromChangelist, jobs.length, ChangelistJobsWidget.this.changelist.getId());
                    if (P4ConnectionManager.getManager().openConfirm(title.toString(), message.toString())) {
                        UnfixJobAction unfix = new UnfixJobAction();
                        unfix.unfix(ChangelistJobsWidget.this.changelist, jobs);
                    }
                }
            }
        });
    }
}

