/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.changelists;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4ShelvedChangelist;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.changelists.ChangelistFormPage;
import com.perforce.team.ui.changelists.IChangelistEditorInput;
import com.perforce.team.ui.changelists.Messages;
import com.perforce.team.ui.editor.PageFactoryRegistry;
import com.perforce.team.ui.p4java.actions.IntegrateAction;
import com.perforce.team.ui.shelve.ShelvedFormPage;
import com.perforce.team.ui.shelve.UnshelveAction;
import com.perforce.team.ui.submitted.SubmittedFormPage;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.widgets.Form;

public class ChangelistEditor
extends SharedHeaderFormEditor {
    public static final String ID = "com.perforce.team.ui.changelists.ChangelistEditor";
    private IP4Changelist changelist;
    private ChangelistFormPage changelistPage = null;

    protected void addPages() {
        if (this.changelist instanceof IP4SubmittedChangelist) {
            this.changelistPage = new SubmittedFormPage((FormEditor)this, this.changelist);
        } else if (this.changelist instanceof IP4ShelvedChangelist) {
            this.changelistPage = new ShelvedFormPage((FormEditor)this, this.changelist);
        }
        if (this.changelistPage != null) {
            ImageDescriptor descriptor;
            try {
                this.addPage((IFormPage)this.changelistPage);
            }
            catch (PartInitException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
            String name = this.getEditorInput().getName();
            if (name != null) {
                this.setPartName(name);
            }
            if ((descriptor = this.getEditorInput().getImageDescriptor()) != null) {
                Image editorImage = descriptor.createImage();
                this.setTitleImage(editorImage);
                P4UIUtils.registerDisposal((Widget)this.getContainer(), (Resource)editorImage);
            }
        }
        PageFactoryRegistry.getRegistry().addPages((FormEditor)this, ID);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof IChangelistEditorInput) {
            this.changelist = ((IChangelistEditorInput)input).getChangelist();
            if (this.changelist == null) {
                throw new PartInitException("Input changelist must not be null");
            }
        } else {
            throw new PartInitException("Input must be an instance of IChangelistEditorInput");
        }
        super.init(site, input);
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        String format = "{0} ({1})";
        Image image = null;
        if (this.changelist instanceof IP4SubmittedChangelist) {
            format = Messages.ChangelistEditor_SubmittedChangelist;
            image = PerforceUIPlugin.getDescriptor("perforce/submitted.png").createImage();
        } else if (this.changelist instanceof IP4ShelvedChangelist) {
            format = Messages.ChangelistEditor_ShelvedChangelist;
            image = PerforceUIPlugin.getDescriptor("views/shelve.png").createImage();
        }
        Form form = headerForm.getForm().getForm();
        Action refreshAction = new Action(Messages.ChangelistEditor_RefreshChangelist, PerforceUIPlugin.getDescriptor("normal/refresh.png")){

            public void run() {
                if (ChangelistEditor.this.changelistPage != null) {
                    ChangelistEditor.this.changelistPage.refresh();
                }
            }
        };
        form.getToolBarManager().add((IAction)refreshAction);
        if (this.changelist instanceof IP4SubmittedChangelist) {
            Action integAction = new Action(Messages.ChangelistEditor_IntegrateChangelist, PerforceUIPlugin.getDescriptor("normal/integrate.png")){

                public void run() {
                    IntegrateAction integ = new IntegrateAction();
                    integ.selectionChanged(null, (ISelection)new StructuredSelection((Object)ChangelistEditor.this.changelist));
                    integ.run(null);
                }
            };
            form.getToolBarManager().add((IAction)integAction);
        } else if (this.changelist instanceof IP4ShelvedChangelist) {
            Action unshelveAction = new Action(Messages.ChangelistEditor_Unshelve, PerforceUIPlugin.getDescriptor("normal/unshelve.png")){

                public void run() {
                    UnshelveAction unshelve = new UnshelveAction();
                    unshelve.selectionChanged(null, (ISelection)new StructuredSelection((Object)ChangelistEditor.this.changelist));
                    unshelve.run(null);
                }
            };
            form.getToolBarManager().add((IAction)unshelveAction);
        }
        form.getToolBarManager().update(true);
        if (image != null) {
            P4UIUtils.registerDisposal((Widget)form, (Resource)image);
            form.setImage(image);
        }
        form.setText(MessageFormat.format(format, this.changelist.getId(), this.changelist.getConnection().getParameters().getPort()));
        this.getToolkit().decorateFormHeading(form);
    }

    public void setFocus() {
        super.setFocus();
        IFormPage page = this.getActivePageInstance();
        if (page != null) {
            page.setFocus();
        }
    }
}

