/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.branches;

import com.perforce.team.core.p4java.IP4Branch;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.branches.EditBranchDialog;
import com.perforce.team.ui.branches.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class EditBranchAction
extends P4Action {
    @Override
    protected void runAction() {
        IP4Resource resource = this.getSingleOnlineResourceSelection();
        if (resource != null) {
            final IP4Branch branch = (IP4Branch)resource;
            String name = branch.getName();
            if (name == null) {
                name = "";
            }
            final String branchName = name;
            P4Runnable runnable = new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(NLS.bind((String)Messages.EditBranchAction_EditingBranch, (Object)branchName), 2);
                    monitor.subTask(Messages.EditBranchAction_RefreshingBranchSubTask);
                    branch.refresh();
                    monitor.worked(1);
                    monitor.subTask(Messages.EditBranchAction_DisplayingBranchSubTask);
                    PerforceUIPlugin.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            EditBranchDialog dialog = new EditBranchDialog(EditBranchAction.this.getShell(), branch);
                            if (dialog.open() == 0) {
                                EditBranchAction.this.updateBranch(branch, branchName);
                            }
                        }
                    });
                    monitor.done();
                }

                public String getTitle() {
                    return NLS.bind((String)Messages.EditBranchAction_LoadingBranch, (Object)branchName);
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
    }

    private void updateBranch(final IP4Branch branch, final String name) {
        P4Runnable runnable = new P4Runnable(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(this.getTitle(), 1);
                monitor.setTaskName(NLS.bind((String)Messages.EditBranchAction_RefreshingBranch, (Object)name));
                branch.refresh();
                P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.REFRESHED, (IP4Resource)branch));
                monitor.worked(1);
                monitor.done();
            }

            public String getTitle() {
                return NLS.bind((String)Messages.EditBranchAction_UpdatingBranch, (Object)name);
            }
        };
        this.runRunnable((IP4Runnable)runnable);
    }
}

