/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.Policy;
import com.perforce.team.core.Tracing;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.Messages;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchAdapter;

public class PerforceContentProvider
extends BaseWorkbenchContentProvider
implements ITreeContentProvider {
    public static final Object[] EMPTY = new Object[0];
    protected Object[] roots = EMPTY;
    protected StructuredViewer viewer;
    private boolean loadAsync = false;

    public PerforceContentProvider(StructuredViewer viewer) {
        this(viewer, false);
    }

    public PerforceContentProvider(StructuredViewer viewer, boolean async) {
        this.viewer = viewer;
        this.loadAsync = async;
    }

    public PerforceContentProvider(StructuredViewer viewer, Object context) {
        this(viewer, false, context);
    }

    public PerforceContentProvider(StructuredViewer viewer, boolean async, Object context) {
        this(viewer, async);
    }

    protected IP4Resource[] getMembers(IP4Container container) {
        return container.members();
    }

    protected ISchedulingRule generateRule(IP4Container container) {
        return new ResourceRule((IP4Resource)container);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IP4Container) {
            IP4Container container = (IP4Container)parentElement;
            if (!container.needsRefresh()) {
                return this.getMembers(container);
            }
            if (this.loadAsync) {
                Loading loading = new Loading();
                this.asyncUpdateContainer(container);
                return new Object[]{loading};
            }
            if (container.needsRefresh()) {
                container.refresh();
            }
            return container.members();
        }
        return super.getChildren(parentElement);
    }

    protected void asyncUpdateContainer(final IP4Container container) {
        ISchedulingRule rule = this.generateRule(container);
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return MessageFormat.format(Messages.PerforceContentProvider_FetchingChildren, container.getName());
            }

            public void run(IProgressMonitor monitor) {
                if (container.needsRefresh()) {
                    container.refresh();
                }
                P4UIUtils.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (P4UIUtils.okToUse((Viewer)(this).PerforceContentProvider.this.viewer)) {
                            if ((this).PerforceContentProvider.this.viewer instanceof ICheckable) {
                                boolean checkState = ((ICheckable)(this).PerforceContentProvider.this.viewer).getChecked((Object)container);
                                (this).PerforceContentProvider.this.viewer.refresh((Object)container);
                                ((ICheckable)(this).PerforceContentProvider.this.viewer).setChecked((Object)container, checkState);
                                IP4Resource[] iP4ResourceArray = container.members();
                                int n = iP4ResourceArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IP4Resource child = iP4ResourceArray[n2];
                                    if (child instanceof IP4Container) {
                                        ((ICheckable)(this).PerforceContentProvider.this.viewer).setChecked((Object)child, checkState);
                                    } else {
                                        ((ICheckable)(this).PerforceContentProvider.this.viewer).setChecked((Object)child, false);
                                    }
                                    ++n2;
                                }
                            } else {
                                (this).PerforceContentProvider.this.viewer.refresh((Object)container);
                            }
                        }
                    }
                });
            }
        }, (ISchedulingRule)rule);
    }

    public Object getParent(Object element) {
        Object parent = null;
        parent = element instanceof IP4Resource ? ((IP4Resource)element).getParent() : super.getParent(element);
        return parent;
    }

    public boolean hasChildren(Object element) {
        boolean children = false;
        if (element instanceof IP4Changelist && !((IP4Changelist)element).needsRefresh()) {
            children = this.getMembers((IP4Container)((IP4Changelist)element)).length > 0;
        } else if (element instanceof IP4Container) {
            children = true;
        } else {
            if (element instanceof Loading) {
                return false;
            }
            children = super.hasChildren(element);
        }
        return children;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Loading) {
            return new Object[]{inputElement};
        }
        return this.roots;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof Object[]) {
            this.roots = (Object[])newInput;
        } else if (newInput instanceof IP4Resource) {
            this.roots = new Object[]{newInput};
        } else if (newInput instanceof Collection) {
            this.roots = ((Collection)newInput).toArray();
        }
    }

    public boolean isLoadAsync() {
        return this.loadAsync;
    }

    public void setLoadAsync(boolean loadAsync) {
        this.loadAsync = loadAsync;
    }

    public void updateElement(final Object parent, final int index) {
        if (this.viewer instanceof TreeViewer) {
            if (parent == this.roots) {
                Tracing.printExecTime((boolean)Policy.DEBUG, (String)"updateElement", (String)MessageFormat.format("index={0},parent={1}", index, Arrays.toString(this.roots)), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (index >= 0 && index < PerforceContentProvider.this.roots.length) {
                            Object el = PerforceContentProvider.this.roots[index];
                            ((TreeViewer)PerforceContentProvider.this.viewer).replace(parent, index, el);
                            PerforceContentProvider.this.updateChildCount(el, -1);
                        } else {
                            PerforceProviderPlugin.logError((String)"index outof bound of roots");
                        }
                    }
                });
            } else if (parent instanceof IP4Container) {
                final IP4Container container = (IP4Container)parent;
                if (!container.needsRefresh()) {
                    Tracing.printExecTime((boolean)Policy.DEBUG, (String)"updateElement", (String)MessageFormat.format("P4ContainerNeedsNoRefresh,index={0}, parent={1}", index, parent), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            IP4Resource[] members = PerforceContentProvider.this.getMembers((IP4Container)parent);
                            if (members.length > index) {
                                IP4Resource element = members[index];
                                ((TreeViewer)PerforceContentProvider.this.viewer).replace(parent, index, (Object)element);
                                PerforceContentProvider.this.updateChildCount(element, -1);
                            }
                        }
                    });
                } else if (this.isLoadAsync()) {
                    Tracing.printExecTime((boolean)Policy.DEBUG, (String)"updateElement", (String)MessageFormat.format("AsyncLoad, index={0}, parent={1}", index, parent), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Loading loading = new Loading();
                            ((TreeViewer)PerforceContentProvider.this.viewer).replace((Object)container, 0, (Object)loading);
                            PerforceContentProvider.this.updateChildCount(container, 1);
                            PerforceContentProvider.this.asyncUpdateContainer(container, index);
                        }
                    });
                } else {
                    Tracing.printExecTime((boolean)Policy.DEBUG, (String)"updateElement", (String)MessageFormat.format("SyncLoad, index={0}, parent={1}", index, parent), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            container.refresh();
                            IP4Resource[] members = PerforceContentProvider.this.getMembers(container);
                            if (members.length > index && index >= 0) {
                                IP4Resource element = members[index];
                                ((TreeViewer)PerforceContentProvider.this.viewer).replace((Object)container, index, (Object)element);
                                PerforceContentProvider.this.updateChildCount(element, -1);
                            }
                        }
                    });
                }
            }
        }
    }

    public void updateChildCount(Object element, int currentChildCount) {
        if (this.viewer instanceof TreeViewer) {
            if (element instanceof IP4Container) {
                if (!((IP4Container)element).needsRefresh()) {
                    Tracing.printTrace((String)"updateChildCount", (String)MessageFormat.format("Element=IP4Container[{0}], NoRefresh, children={1}", element, this.getMembers((IP4Container)element).length));
                    ((TreeViewer)this.viewer).setChildCount(element, this.getMembers((IP4Container)element).length);
                } else {
                    Tracing.printTrace((String)"updateChildCount", (String)MessageFormat.format("Element=IP4Container[{0}], Refresh, children={1}", element, 1));
                    ((TreeViewer)this.viewer).setChildCount(element, 1);
                }
            } else if (element instanceof Loading) {
                Tracing.printTrace((String)"updateChildCount", (String)"Element=Loading");
                ((TreeViewer)this.viewer).setChildCount(element, 0);
            } else if (element == this.roots) {
                Tracing.printTrace((String)"updateChildCount", (String)MessageFormat.format("Element=roots{0}, NoRefresh", this.roots.length > 1000 ? Arrays.toString(new int[]{this.roots.length}) : Arrays.toString(this.roots)));
                ((TreeViewer)this.viewer).setChildCount(element, this.roots.length);
            } else if (element != null) {
                int length = super.getChildren(element).length;
                Tracing.printTrace((String)"updateChildCount", (String)MessageFormat.format("Element=[{0}], length={1}", element, length));
                ((TreeViewer)this.viewer).setChildCount(element, length);
            }
        }
    }

    protected void asyncUpdateContainer(final IP4Container container, final int index) {
        Tracing.printTrace((String)"asyncUpdateContainer", (String)("AsyncUpdateContainer + " + index + ", container=" + container));
        ISchedulingRule rule = this.generateRule(container);
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return MessageFormat.format(Messages.PerforceContentProvider_FetchingChildren, container.getName());
            }

            public void run(IProgressMonitor monitor) {
                if (container.needsRefresh()) {
                    Tracing.printExecTime((boolean)Policy.DEBUG, (String)"AsyncUpdateContainer:refreshContainer()", (String)(String.valueOf(index) + ", container=" + container), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            PerforceContentProvider.this.refreshContainer(container);
                        }
                    });
                }
                P4UIUtils.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (P4UIUtils.okToUse((Viewer)(this).PerforceContentProvider.this.viewer)) {
                            if ((this).PerforceContentProvider.this.viewer instanceof ICheckable) {
                                boolean checkState = ((ICheckable)(this).PerforceContentProvider.this.viewer).getChecked((Object)container);
                                (this).PerforceContentProvider.this.viewer.refresh((Object)container);
                                ((ICheckable)(this).PerforceContentProvider.this.viewer).setChecked((Object)container, checkState);
                                IP4Resource[] iP4ResourceArray = container.members();
                                int n = iP4ResourceArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IP4Resource child = iP4ResourceArray[n2];
                                    if (child instanceof IP4Container) {
                                        ((ICheckable)(this).PerforceContentProvider.this.viewer).setChecked((Object)child, checkState);
                                    } else {
                                        ((ICheckable)(this).PerforceContentProvider.this.viewer).setChecked((Object)child, false);
                                    }
                                    ++n2;
                                }
                            } else if ((this).PerforceContentProvider.this.viewer instanceof TreeViewer && (this).PerforceContentProvider.this.viewer.getContentProvider() instanceof ILazyTreeContentProvider) {
                                Tracing.printExecTime((boolean)Policy.DEBUG, (String)"AsyncUpdateContainer:updateContainerNode", (String)(String.valueOf(index) + ", container=" + container), (Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        PerforceContentProvider.this.updateContainerNode((TreeViewer)((this).this).PerforceContentProvider.this.viewer, container, index);
                                    }
                                });
                            } else {
                                (this).PerforceContentProvider.this.viewer.refresh((Object)container);
                            }
                        }
                    }
                });
            }
        }, (ISchedulingRule)rule);
    }

    private synchronized void refreshContainer(IP4Container container) {
        container.refresh();
    }

    protected void updateContainerNode(TreeViewer viewer, IP4Container container, int index) {
        viewer.refresh((Object)container);
        IP4Resource[] members = container.members();
        viewer.setChildCount((Object)container, members.length);
    }

    public static class Loading
    extends WorkbenchAdapter {
        public ImageDescriptor getImageDescriptor(Object object) {
            return PerforceUIPlugin.getDescriptor("perforce/hourglass.png");
        }

        public String getLabel(Object object) {
            return Messages.PerforceContentProvider_Loading;
        }
    }

    public static class ResourceRule
    implements ISchedulingRule {
        private IP4Resource resource = null;

        public ResourceRule(IP4Resource resource) {
            this.resource = resource;
        }

        public boolean contains(ISchedulingRule rule) {
            if (rule instanceof ResourceRule) {
                return this.resource == ((ResourceRule)rule).resource;
            }
            return false;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return this.contains(rule);
        }
    }
}

