/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui;

import com.perforce.p4java.server.callback.ILogCallback;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IErrorHandler;
import com.perforce.team.core.p4java.IP4WorkspaceConfigurer;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.PerforceUIPlugin;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class P4WorkspaceConfigurer
implements IP4WorkspaceConfigurer {
    private void configureUiSettings(final P4Workspace workspace) {
        IPreferenceStore uiStore = PerforceUIPlugin.getPlugin().getPreferenceStore();
        this.loadP4JavaProperties(workspace, uiStore.getString("com.perforce.team.ui.preferences.CUSTOM_P4JAVA_PROPERTIES"));
        workspace.setPersistOffline(uiStore.getBoolean("com.perforce.team.ui.preferences.PERSIST_OFFINE"));
        this.loadTraceLevel(workspace, uiStore.getString("com.perforce.team.ui.preferences.TRACE_LEVEL"));
        IPropertyChangeListener uiListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("com.perforce.team.ui.preferences.TRACE_LEVEL".equals(event.getProperty())) {
                    P4WorkspaceConfigurer.this.loadTraceLevel(workspace, event.getNewValue());
                } else if ("com.perforce.team.ui.preferences.CUSTOM_P4JAVA_PROPERTIES".equals(event.getProperty())) {
                    String value = event.getNewValue() != null ? event.getNewValue().toString() : null;
                    P4WorkspaceConfigurer.this.loadP4JavaProperties(workspace, value);
                }
            }
        };
        uiStore.addPropertyChangeListener(uiListener);
    }

    private void loadTraceLevel(P4Workspace workspace, Object value) {
        String sValue;
        String string = sValue = value != null ? value.toString() : null;
        if (sValue != null && sValue.length() > 0) {
            try {
                ILogCallback.LogTraceLevel level = ILogCallback.LogTraceLevel.valueOf((String)sValue);
                workspace.setTraceLevel(level);
            }
            catch (IllegalArgumentException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
    }

    private void loadP4JavaProperties(P4Workspace workspace, String properties) {
        workspace.getAdvancedProperties().clear();
        if (properties != null) {
            String[] pairs;
            String[] stringArray = pairs = properties.split("###");
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                String pair = stringArray[n2];
                String[] sections = pair.split("===");
                if (sections.length == 2) {
                    workspace.getAdvancedProperties().put(sections[0], sections[1]);
                }
                ++n2;
            }
            workspace.getServerProperties().putAll((Map<?, ?>)workspace.getAdvancedProperties());
        }
    }

    public void configure(P4Workspace workspace) {
        workspace.setErrorHandler((IErrorHandler)P4ConnectionManager.getManager());
        this.configureUiSettings(workspace);
    }
}

