/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public final class P4FormUIUtils {
    public static void registerExpansionSpaceGrabber(Section section, Composite body) {
        P4FormUIUtils.registerExpansionSpaceGrabber(section, body, true, false);
    }

    public static void registerExpansionSpaceGrabber(final Section section, final Composite body, final boolean vertical, final boolean horizontal) {
        if (section != null && body != null) {
            section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    GridData data = (GridData)section.getLayoutData();
                    if (vertical) {
                        data.grabExcessVerticalSpace = section.isExpanded();
                    }
                    if (horizontal) {
                        data.grabExcessHorizontalSpace = section.isExpanded();
                    }
                    body.layout(true, true);
                }
            });
        }
    }

    public static Composite createSectionTextClient(FormToolkit toolkit, Section section, int numColumns, int style) {
        Composite area = null;
        if (toolkit != null && section != null) {
            area = toolkit.createComposite((Composite)section, style);
            area.setBackground(null);
            GridLayout aLayout = new GridLayout(numColumns, false);
            aLayout.marginWidth = 0;
            aLayout.marginHeight = 0;
            area.setLayout((Layout)aLayout);
            section.setTextClient((Control)area);
        }
        return area;
    }

    public static Composite createSectionTextClient(FormToolkit toolkit, Section section, int numColumns) {
        return P4FormUIUtils.createSectionTextClient(toolkit, section, numColumns, 0);
    }

    public static Composite createSectionTextClient(FormToolkit toolkit, Section section) {
        return P4FormUIUtils.createSectionTextClient(toolkit, section, 1);
    }

    public static ToolBar createSectionToolbar(FormToolkit toolkit, Section section) {
        ToolBar toolbar = null;
        if (toolkit != null && section != null) {
            Composite toolbarArea = P4FormUIUtils.createSectionTextClient(toolkit, section);
            toolbar = new ToolBar(toolbarArea, 0x800000);
        }
        return toolbar;
    }
}

