/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui;

import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ClientError;
import com.perforce.p4java.exception.ConfigException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.TrustException;
import com.perforce.p4java.server.AuthTicketsHelper;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.IServerInfo;
import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.P4LogUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.ConnectionMappedException;
import com.perforce.team.core.p4java.IErrorHandler;
import com.perforce.team.core.p4java.IEventObject;
import com.perforce.team.core.p4java.IP4CommandListener;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Listener;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Connection;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.core.p4java.ServerNotSupportedException;
import com.perforce.team.ui.Messages;
import com.perforce.team.ui.P4TrustDialog;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.actions.ServerPropertiesAction;
import com.perforce.team.ui.connection.mfa.MFAUtil;
import com.perforce.team.ui.dialogs.DialogUtils;
import com.perforce.team.ui.p4java.dialogs.PasswordDialog;
import com.perforce.team.ui.p4java.dialogs.PerforceErrorDialog;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.UIJob;

public final class P4ConnectionManager
implements IErrorHandler,
IEventObject {
    public static final String CONNECTIONS = "com.perforce.team.ui.DEPOT_CONNECTIONS";
    public static final String SUPPRESS_ERROR_DIALOGS = "com.perforce.team.ui.SUPPRESS_ERROR_DIALOGS";
    private static final int WORK_OFFLINE = 0;
    private static final int EDIT_SETTINGS = 1;
    private static final int RETRY = 2;
    private static P4ConnectionManager manager = null;
    private boolean suppressErrors = System.getProperty("com.perforce.team.ui.SUPPRESS_ERROR_DIALOGS") != null;
    private IP4Connection selectedConnection = null;

    public static boolean isLoginError(String message) {
        return message != null && (message.indexOf("invalid or unset") > -1 || message.indexOf("please login again") > -1 || message.indexOf("please %'login'% again") > -1 || message.indexOf("The pipe is being closed") > -1);
    }

    public static boolean isLogin2Error(String message) {
        return message != null && message.indexOf("Second factor authentication required! Run 'p4 login2'.") > -1;
    }

    public static boolean isClientNonExistentError(String message) {
        return message != null && message.indexOf("Client '") > -1 && message.indexOf("' does not exist") > -1;
    }

    public static boolean isServerNotSupportedError(P4JavaException exception) {
        return exception instanceof ServerNotSupportedException;
    }

    public static boolean isTrustError(P4JavaException exception) {
        TrustException te;
        if (exception instanceof TrustException) {
            te = (TrustException)exception;
        } else if (exception instanceof ConnectionException && exception.getCause() instanceof TrustException) {
            te = (TrustException)exception.getCause();
        } else {
            return false;
        }
        return te.getType() == TrustException.Type.NEW_CONNECTION || te.getType() == TrustException.Type.NEW_KEY;
    }

    public static boolean isConnectionError(P4JavaException exception) {
        boolean connectionError = false;
        if (exception instanceof ConnectionException && !(exception.getCause() instanceof ClientError)) {
            connectionError = true;
        }
        return connectionError;
    }

    public static boolean isCommandLineError(P4JavaException exception) {
        boolean error = false;
        if (exception instanceof ConfigException) {
            String message = exception.getMessage();
            error = message != null && message.endsWith("no such command line executable found");
        }
        return error;
    }

    public boolean isSuppressErrors() {
        return this.suppressErrors;
    }

    public static synchronized P4ConnectionManager getManager() {
        if (manager == null) {
            manager = new P4ConnectionManager();
        }
        return manager;
    }

    private P4ConnectionManager() {
    }

    public P4Collection createP4Collection() {
        P4Collection collection = new P4Collection();
        collection.setErrorHandler((IErrorHandler)this);
        return collection;
    }

    public void openInformation(Shell shell, String title, String message) {
        if (!this.suppressErrors) {
            MessageDialog.openInformation((Shell)shell, (String)title, (String)message);
        } else {
            PerforceProviderPlugin.logInfo((String)message);
        }
    }

    public void openError(Shell shell, String title, String message) {
        PerforceProviderPlugin.logError((String)message);
        if (!this.suppressErrors) {
            MessageDialog.openError((Shell)shell, (String)title, (String)message);
        }
    }

    public boolean openConfirm(final String title, final String message) {
        final boolean[] confirmed = new boolean[1];
        PerforceProviderPlugin.logInfo((String)message);
        if (!this.suppressErrors) {
            PerforceUIPlugin.syncExec(new Runnable(){

                @Override
                public void run() {
                    confirmed[0] = P4ConnectionManager.this.openConfirm(P4UIUtils.getShell(), title, message);
                }
            });
        }
        return confirmed[0];
    }

    public boolean openConfirm(Shell shell, String title, String message) {
        boolean confirm = false;
        PerforceProviderPlugin.logInfo((String)message);
        if (!this.suppressErrors) {
            confirm = MessageDialog.openConfirm((Shell)shell, (String)title, (String)message);
        }
        return confirm;
    }

    public boolean openQuestion(Shell shell, String title, String message) {
        boolean answer = false;
        PerforceProviderPlugin.logInfo((String)message);
        if (!this.suppressErrors) {
            answer = MessageDialog.openQuestion((Shell)shell, (String)title, (String)message);
        }
        return answer;
    }

    public void openWarning(Shell shell, String title, String message) {
        PerforceProviderPlugin.logWarning((String)message);
        if (!this.suppressErrors) {
            MessageDialog.openWarning((Shell)shell, (String)title, (String)message);
        }
    }

    public P4Collection createP4Collection(IP4Resource resource) {
        return this.createP4Collection(new IP4Resource[]{resource});
    }

    public P4Collection createP4Collection(IP4Resource[] resources) {
        P4Collection collection = new P4Collection(resources);
        collection.setErrorHandler((IErrorHandler)this);
        return collection;
    }

    private boolean connectionInvalid(IP4Connection connection) {
        return connection == null || connection.isOffline() || connection.isDisposed();
    }

    private void goOffline(IP4Connection connection) {
        connection.setOffline(true);
        P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.CHANGED, (IP4Resource)connection));
    }

    private void editConnection(IP4Connection connection) {
        ServerPropertiesAction action = new ServerPropertiesAction();
        action.execute(connection);
    }

    private boolean trySSO() {
        return P4Workspace.getWorkspace().getAdvancedProperties().getProperty("P4LOGINSSO") != null || System.getenv("P4LOGINSSO") != null;
    }

    private void handleLoginError(final IP4Connection connection, final Retry returnCode, final boolean allowOffline, final long exceptionTime) {
        String password;
        if (connection.getParameters().savePassword() && (password = connection.getParameters().getPassword()) != null && connection.login(password)) {
            returnCode.retry = true;
            return;
        }
        if (this.trySSO() && connection.login("")) {
            returnCode.retry = true;
            return;
        }
        if (connection.getServerInfo().isSSOAuthRequired().booleanValue()) {
            connection.login("");
            return;
        }
        try {
            String ticket = null;
            IServer server = connection.getServer();
            IServerInfo info = connection.getServer().getServerInfo();
            ticket = AuthTicketsHelper.getTicketValue((String)ConnectionParameters.getTicketUser((ConnectionParameters)connection.getParameters(), (IServer)server), (String)info.getServerAddress(), (String)P4Connection.getP4TicketsOSLocation());
            if (ticket != null && !ticket.equals(server.getAuthTicket())) {
                connection.getServer().setAuthTicket(ticket);
                returnCode.retry = true;
                return;
            }
        }
        catch (Exception e) {
            PerforceProviderPlugin.logError((Throwable)e);
        }
        P4UIUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                String password;
                if (!P4ConnectionManager.this.dispatchAndCheck(connection)) {
                    return;
                }
                if (connection.getLoggedInTime() >= exceptionTime) {
                    returnCode.retry = true;
                    return;
                }
                if (connection.isLoggedIn()) {
                    connection.markLoggedOut();
                    returnCode.retry = true;
                    return;
                }
                PasswordDialog dialog = new PasswordDialog(P4UIUtils.getDialogShell(), connection, allowOffline);
                if (dialog.open() == 0 && (password = dialog.getPassword()) != null) {
                    if (connection.getParameters().savePassword()) {
                        connection.getParameters().setPassword(password);
                        PerforceUIPlugin.storePasswordInUI(connection.getParameters());
                    }
                    boolean doit = connection.login(password);
                    MFAUtil.doMFA(dialog.getShell(), doit, connection);
                    returnCode.retry = true;
                }
            }
        });
    }

    private void handleClientNonExistentError(final IP4Connection connection, final Retry returnCode, final boolean showOptions) {
        PerforceUIPlugin.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!P4ConnectionManager.this.dispatchAndCheck(connection)) {
                    return;
                }
                ConnectionParameters params = connection.getParameters();
                String msg = MessageFormat.format(Messages.P4ConnectionManager_ClientUnknown, params.getClientNoNull());
                String[] options = null;
                options = showOptions ? new String[]{Messages.P4ConnectionManager_WorkOffline, Messages.P4ConnectionManager_EditSettings, Messages.P4ConnectionManager_Retry} : new String[]{IDialogConstants.OK_LABEL};
                MessageDialog errdlg = new MessageDialog(P4UIUtils.getDialogShell(), Messages.P4ConnectionManager_ConnectionError, null, msg, 1, options, 0);
                int option = errdlg.open();
                if (showOptions) {
                    if (option == 2) {
                        returnCode.retry = true;
                    } else if (option == 0) {
                        P4ConnectionManager.this.goOffline(connection);
                    } else if (option == 1) {
                        P4ConnectionManager.this.editConnection(connection);
                    }
                }
            }
        });
    }

    private void handleServerNotSupportedError(final IP4Connection connection, final P4JavaException exception, final Retry returnCode, final boolean showOptions) {
        PerforceUIPlugin.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!P4ConnectionManager.this.dispatchAndCheck(connection)) {
                    return;
                }
                String msg = exception.getMessage();
                String[] options = null;
                options = showOptions ? new String[]{Messages.P4ConnectionManager_EditSettings, Messages.P4ConnectionManager_Retry} : new String[]{IDialogConstants.OK_LABEL};
                MessageDialog errdlg = new MessageDialog(P4UIUtils.getDialogShell(), Messages.P4ConnectionManager_ServerNotSupported, null, msg, 1, options, 0);
                int option = errdlg.open();
                if (showOptions) {
                    if (option == 1) {
                        returnCode.retry = true;
                    } else if (option == 0) {
                        P4ConnectionManager.this.editConnection(connection);
                    }
                }
            }
        });
    }

    private void handleTrustError(final IP4Connection connection, final Exception exception, final Retry returnCode) {
        P4UIUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!P4ConnectionManager.this.dispatchAndCheck(connection)) {
                    return;
                }
                TrustException te = exception instanceof TrustException ? (TrustException)exception : (TrustException)exception.getCause();
                P4TrustDialog trustDlg = new P4TrustDialog(P4UIUtils.getDialogShell(), te.getServerHostPort(), te.getServerIpPort(), te.getFingerprint(), te.getType());
                int option = trustDlg.open();
                if (option == 1) {
                    try {
                        returnCode.retry = P4Workspace.addTrust((String)te.getServerIpPort(), (String)te.getFingerprint());
                    }
                    catch (P4JavaException e) {
                        P4ConnectionManager.this.handleConnectionError(connection, (Exception)((Object)e), returnCode, true);
                    }
                } else {
                    P4ConnectionManager.this.goOffline(connection);
                }
            }
        });
    }

    private void handleConnectionError(final IP4Connection connection, final Exception exception, final Retry returnCode, final boolean showOptions) {
        P4UIUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!P4ConnectionManager.this.dispatchAndCheck(connection)) {
                    return;
                }
                String msg = exception.getLocalizedMessage();
                ArrayList<String> causes = new ArrayList<String>();
                String last = msg;
                Throwable cause = exception.getCause();
                while (cause != null) {
                    String nextCause = cause.getLocalizedMessage();
                    if (!StringUtils.equals((CharSequence)nextCause, (CharSequence)last)) {
                        causes.add(nextCause);
                        last = nextCause;
                    }
                    if (cause == cause.getCause()) break;
                    cause = cause.getCause();
                }
                final String details = StringUtils.join(causes, (String)"\n");
                String[] options = null;
                options = showOptions ? new String[]{Messages.P4ConnectionManager_WorkOffline, Messages.P4ConnectionManager_EditSettings, Messages.P4ConnectionManager_Retry} : new String[]{IDialogConstants.OK_LABEL};
                MessageDialog errdlg = new MessageDialog(P4UIUtils.getDialogShell(), Messages.P4ConnectionManager_ConnectionError, null, msg, 1, options, 0){

                    protected Control createCustomArea(Composite parent) {
                        if (details.isEmpty()) {
                            return null;
                        }
                        Composite displayArea = new Composite(parent, 0);
                        displayArea.setLayout((Layout)new GridLayout(2, false));
                        displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
                        Label detailsLabel = new Label(displayArea, 0);
                        detailsLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
                        detailsLabel.setText("Details:");
                        Text detailsText = DialogUtils.createSelectableLabel(displayArea, new GridData(4, 4, true, false));
                        detailsText.setText(details);
                        detailsText.setSelection(0, 0);
                        return displayArea;
                    }

                    protected boolean customShouldTakeFocus() {
                        return false;
                    }
                };
                int option = errdlg.open();
                if (showOptions) {
                    if (option == 2) {
                        returnCode.retry = true;
                    } else if (option == 0) {
                        P4ConnectionManager.this.goOffline(connection);
                    } else if (option == 1) {
                        P4ConnectionManager.this.editConnection(connection);
                    }
                }
            }
        });
    }

    private void handleCommandLineError(final IP4Connection connection, final boolean showOptions) {
        P4UIUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!P4ConnectionManager.this.dispatchAndCheck(connection)) {
                    return;
                }
                String[] options = null;
                options = showOptions ? new String[]{Messages.P4ConnectionManager_WorkOffline} : new String[]{IDialogConstants.OK_LABEL};
                MessageDialog errdlg = new MessageDialog(P4UIUtils.getDialogShell(), Messages.P4ConnectionManager_P4NotFoundTitle, null, Messages.P4ConnectionManager_P4NotFoundMessage, 1, options, 0);
                int option = errdlg.open();
                if (showOptions && option == 0) {
                    P4ConnectionManager.this.goOffline(connection);
                }
            }
        });
    }

    private void handleStandardError(final IP4Connection connection, final P4JavaException exception, final boolean showOptions) {
        P4UIUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!P4ConnectionManager.this.dispatchAndCheck(connection)) {
                    return;
                }
                String[] options = null;
                options = showOptions ? new String[]{IDialogConstants.OK_LABEL, Messages.P4ConnectionManager_WorkOffline, Messages.P4ConnectionManager_EditSettings} : new String[]{IDialogConstants.OK_LABEL};
                MessageDialog errdlg = new MessageDialog(P4UIUtils.getDialogShell(), Messages.P4ConnectionManager_PerforceError, null, String.valueOf(Messages.P4ConnectionManager_ErrorHasOccurred) + exception.getLocalizedMessage(), 1, options, 0);
                int option = errdlg.open();
                if (showOptions) {
                    if (option == 1) {
                        P4ConnectionManager.this.goOffline(connection);
                    } else if (option == 2) {
                        P4ConnectionManager.this.editConnection(connection);
                    }
                }
            }
        });
    }

    private boolean suppressException(IP4Connection connection) {
        return this.connectionInvalid(connection) || this.suppressErrors;
    }

    public void displayException(IP4Connection connection, P4JavaException exception) {
        this.displayException(connection, exception, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean displayException(IP4Connection connection, P4JavaException exception, boolean handleLogin, boolean allowOffline) {
        boolean retry = false;
        if (this.suppressException(connection)) {
            return false;
        }
        long exceptionTime = System.currentTimeMillis();
        if (PerforceUIPlugin.isUIThread()) {
            retry = this.internalDisplay(connection, exception, handleLogin, allowOffline, exceptionTime);
        } else {
            P4ConnectionManager p4ConnectionManager = this;
            synchronized (p4ConnectionManager) {
                retry = this.internalDisplay(connection, exception, handleLogin, allowOffline, exceptionTime);
            }
        }
        return retry;
    }

    private boolean internalDisplay(IP4Connection connection, P4JavaException exception, boolean handleLogin, boolean allowOffline, long exceptionTime) {
        Retry returnCode = new Retry();
        if (!this.connectionInvalid(connection) && !this.suppressErrors) {
            String message = exception.getMessage();
            if (handleLogin && P4ConnectionManager.isLoginError(message)) {
                this.handleLoginError(connection, returnCode, allowOffline, exceptionTime);
            } else if (P4ConnectionManager.isClientNonExistentError(message)) {
                this.handleClientNonExistentError(connection, null, false);
            } else if (P4ConnectionManager.isServerNotSupportedError(exception)) {
                this.handleServerNotSupportedError(connection, exception, null, false);
            } else if (P4ConnectionManager.isTrustError(exception)) {
                this.handleTrustError(connection, (Exception)((Object)exception), returnCode);
            } else if (P4ConnectionManager.isConnectionError(exception)) {
                this.handleConnectionError(connection, (Exception)((Object)exception), null, false);
            } else if (P4ConnectionManager.isCommandLineError(exception)) {
                this.handleCommandLineError(connection, false);
            } else {
                this.handleStandardError(connection, exception, false);
            }
        }
        return returnCode.retry;
    }

    private boolean dispatchAndCheck(IP4Connection connection) {
        while (P4UIUtils.getDisplay().readAndDispatch()) {
        }
        return !this.connectionInvalid(connection);
    }

    private boolean internalRetry(IP4Connection connection, P4JavaException exception, long exceptionTime) {
        Retry returnCode = new Retry();
        String message = exception.getMessage();
        if (P4ConnectionManager.isLoginError(message)) {
            this.handleLoginError(connection, returnCode, true, exceptionTime);
        } else if (P4ConnectionManager.isLogin2Error(message)) {
            this.handleMFAError(connection);
        } else if (P4ConnectionManager.isClientNonExistentError(message)) {
            this.handleClientNonExistentError(connection, returnCode, true);
        } else if (P4ConnectionManager.isServerNotSupportedError(exception)) {
            this.handleServerNotSupportedError(connection, exception, returnCode, true);
        } else if (P4ConnectionManager.isTrustError(exception)) {
            this.handleTrustError(connection, (Exception)((Object)exception), returnCode);
        } else if (P4ConnectionManager.isConnectionError(exception)) {
            this.handleConnectionError(connection, (Exception)((Object)exception), returnCode, true);
        } else if (P4ConnectionManager.isCommandLineError(exception)) {
            this.handleCommandLineError(connection, true);
        } else {
            this.handleStandardError(connection, exception, true);
        }
        return returnCode.retry;
    }

    private void handleMFAError(final IP4Connection connection) {
        PerforceUIPlugin.syncExec(new Runnable(){

            @Override
            public void run() {
                MFAUtil.doMFA(P4UIUtils.getDialogShell(), true, connection);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldRetry(IP4Connection connection, P4JavaException exception) {
        if (this.suppressException(connection)) {
            return false;
        }
        boolean retry = false;
        long exceptionTime = System.currentTimeMillis();
        if (PerforceUIPlugin.isUIThread()) {
            retry = this.internalRetry(connection, exception, exceptionTime);
        } else {
            P4ConnectionManager p4ConnectionManager = this;
            synchronized (p4ConnectionManager) {
                retry = this.internalRetry(connection, exception, exceptionTime);
            }
        }
        return retry;
    }

    public void setSelection(IP4Connection connection) {
        this.selectedConnection = connection;
    }

    public IP4Connection getSelection(boolean checkStore) {
        IP4Connection connection = this.selectedConnection;
        if (checkStore && connection != null) {
            boolean exists = false;
            IP4Connection[] iP4ConnectionArray = this.getConnections();
            int n = iP4ConnectionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Connection storedConnection = iP4ConnectionArray[n2];
                if (connection.equals(storedConnection)) {
                    exists = true;
                    break;
                }
                ++n2;
            }
            if (!exists) {
                connection = null;
            }
        }
        return connection;
    }

    public IP4Connection getConnection(ConnectionParameters params) {
        IP4Connection connection = P4Workspace.getWorkspace().getConnection(params);
        if (!connection.isConnected() && !connection.isOffline()) {
            connection.connect();
        }
        return connection;
    }

    public IP4Connection getConnection(IProject project, boolean connect) {
        IP4Connection connection = P4Workspace.getWorkspace().getConnection(project);
        if (connection != null && connect && !connection.isConnected() && !connection.isOffline()) {
            connection.connect();
        }
        return connection;
    }

    public IP4Connection getConnection(IProject project) {
        return this.getConnection(project, true);
    }

    public void removeConnection(ConnectionParameters parameters) {
        try {
            P4Workspace.getWorkspace().removeConnection(parameters);
        }
        catch (ConnectionMappedException cme) {
            this.showMappedException(cme, parameters);
        }
    }

    public void add(ConnectionParameters parameters) {
        if (parameters != null) {
            if (!this.containsConnection(parameters)) {
                IP4Connection connection = P4Workspace.getWorkspace().getConnection(parameters);
                boolean showDeletedFiles = PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean("com.perforce.team.ui.depot.show_deleted_files");
                boolean filterClientFiles = PerforceUIPlugin.getPlugin().getPreferenceStore().getBoolean("com.perforce.team.ui.depot.filter_client_files");
                connection.setShowFoldersWIthOnlyDeletedFiles(showDeletedFiles);
                connection.setShowClientOnly(filterClientFiles);
                if (!connection.isOffline()) {
                    connection.login(parameters.getPassword());
                    connection.connect();
                }
            } else {
                P4UIUtils.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openInformation((Shell)P4UIUtils.getShell(), (String)Messages.P4ConnectionManager_ConnectionAlreadyExistsTitle, (String)Messages.P4ConnectionManager_ConnectionAlreadyExistsMessage);
                    }
                });
            }
        }
    }

    public void removeConnection(IP4Connection connection) {
        try {
            P4Workspace.getWorkspace().removeConnection(connection);
        }
        catch (ConnectionMappedException cme) {
            this.showMappedException(cme, connection.getParameters());
        }
    }

    private void showMappedException(final ConnectionMappedException cme, ConnectionParameters params) {
        final String message = MessageFormat.format(Messages.P4ConnectionManager_CantRemoveConnectionMessage, params.getDisplayString());
        P4UIUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.openError((Shell)P4UIUtils.getShell(), (String)Messages.P4ConnectionManager_CantRemoveConnectionTitle, (String)message, (IStatus)cme.getStatus());
            }
        });
    }

    public IP4Connection[] getConnections() {
        return P4Workspace.getWorkspace().getConnections();
    }

    public boolean containsConnection(ConnectionParameters parameters) {
        return P4Workspace.getWorkspace().containsConnection(parameters);
    }

    public void addListener(IP4Listener listener) {
        P4Workspace.getWorkspace().addListener(listener);
    }

    public void clearListeners() {
        P4Workspace.getWorkspace().clearListeners();
    }

    public void notifyListeners(P4Event event) {
        P4Workspace.getWorkspace().notifyListeners(event);
    }

    public void removeListener(IP4Listener listener) {
        P4Workspace.getWorkspace().removeListener(listener);
    }

    public void addListeners(IP4Listener[] listeners) {
        P4Workspace.getWorkspace().addListeners(listeners);
    }

    public IP4Resource asyncGetResource(IResource resource) {
        return P4Workspace.getWorkspace().asyncGetResource(resource);
    }

    public IP4Resource getResource(IResource resource) {
        return P4Workspace.getWorkspace().getResource(resource);
    }

    public void addCommandListener(IP4CommandListener listener) {
        P4Workspace.getWorkspace().addCommandListener(listener);
    }

    public void removeCommandListener(IP4CommandListener listener) {
        P4Workspace.getWorkspace().removeCommandListener(listener);
    }

    public void handleErrorSpecs(final IFileSpec[] specs) {
        if (!this.suppressErrors) {
            UIJob job = new UIJob(Messages.P4ConnectionManager_DisplayingPerforceErrors){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    while (this.getDisplay() != null && !this.getDisplay().isDisposed() && this.getDisplay().readAndDispatch()) {
                    }
                    PerforceErrorDialog.showErrors(P4UIUtils.getDialogShell(), specs);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        } else {
            P4LogUtils.logError((IFileSpec[])specs);
        }
    }

    public void editConnection(IP4Connection connection, ConnectionParameters newParameters) {
        IP4Connection newConnection = P4Workspace.getWorkspace().editConnection(connection, newParameters);
        if (newConnection != null && !newConnection.isConnected() && !newConnection.isOffline()) {
            newConnection.connect();
        }
    }

    public int size() {
        return P4Workspace.getWorkspace().size();
    }

    public static boolean retryAfterLogin(IP4Connection connection, AccessException exception) {
        if (connection == null || exception == null) {
            return false;
        }
        IErrorHandler handler = connection.getErrorHandler();
        if (handler == null) {
            handler = P4Workspace.getWorkspace().getErrorHandler();
        }
        if (handler != null) {
            return handler.shouldRetry(connection, (P4JavaException)exception);
        }
        return false;
    }

    private static class Retry {
        boolean retry = false;

        private Retry() {
        }
    }
}

