/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui;

import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.ui.Messages;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.connection.SelectConnectionWizardPage;
import com.perforce.team.ui.decorator.PerforceDecorator;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.team.ui.IConfigurationWizardExtension;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.ide.undo.MoveProjectOperation;

public class ConfigWizard
extends Wizard
implements IConfigurationWizard,
IConfigurationWizardExtension {
    protected IProject[] projects;
    protected SelectConnectionWizardPage connectionPage;

    public IProject[] getProjects() {
        return Arrays.copyOf(this.projects, this.projects.length);
    }

    public ConfigWizard() {
        this.setDialogSettings(PerforceUIPlugin.getPlugin().getDialogSettings());
        this.connectionPage = new SelectConnectionWizardPage("connectionPage");
        this.connectionPage.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.connectionPage);
        this.setWindowTitle(Messages.ConfigWizard_ShareProject);
        this.setNeedsProgressMonitor(true);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
    }

    public boolean performFinish() {
        ConnectionParameters params;
        Map<IProject, File> projectsNoMove;
        Map<IProject, File> projectsToMove;
        block5: {
            projectsToMove = this.connectionPage.getProjects(true);
            projectsNoMove = this.connectionPage.getProjects(false);
            params = this.connectionPage.getConnection().getParameters();
            Map<IProject, String> errorProjects = this.connectionPage.getInvalidProject(projectsToMove, this.connectionPage.getConnection());
            if (errorProjects.isEmpty()) break block5;
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<IProject, String> entry : errorProjects.entrySet()) {
                IProject prj = entry.getKey();
                sb.append(String.valueOf('[') + prj.getName() + ']' + "  " + entry.getValue());
                sb.append("\n");
            }
            sb.deleteCharAt(sb.length() - 1);
            MessageDialog.openError(null, (String)Messages.SharingWizard_Error, (String)(String.valueOf(Messages.SharingWizard_InvalidProjects) + sb.toString()));
            return false;
        }
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    PerforceDecorator decorator;
                    monitor.beginTask(Messages.ConfigWizard_ShareProjects, 40);
                    monitor.worked(10);
                    SubProgressMonitor sub1 = new SubProgressMonitor(monitor, 10);
                    sub1.beginTask(Messages.ConfigWizard_MovingProjects, projectsToMove.size() * 10);
                    for (Map.Entry entry : projectsToMove.entrySet()) {
                        IPath currentLocation;
                        IProject project = (IProject)entry.getKey();
                        Path targetLocation = new Path(((File)entry.getValue()).getPath());
                        if (targetLocation.equals((Object)(currentLocation = project.getLocation()))) continue;
                        MoveProjectOperation op = new MoveProjectOperation(project, ((File)entry.getValue()).toURI(), Messages.SharingWizard_MoveProjectActionLabel);
                        try {
                            IStatus result = op.execute((IProgressMonitor)sub1, null);
                            sub1.worked(10);
                            if (result.isOK()) continue;
                            throw new RuntimeException();
                        }
                        catch (ExecutionException e) {
                            if (e.getCause() != null) {
                                throw new InvocationTargetException(e.getCause());
                            }
                            throw new InvocationTargetException(e);
                        }
                    }
                    sub1.done();
                    HashMap managedProjects = new HashMap();
                    managedProjects.putAll(projectsToMove);
                    managedProjects.putAll(projectsNoMove);
                    SubProgressMonitor sub2 = new SubProgressMonitor(monitor, 10);
                    sub2.beginTask(Messages.ConfigWizard_SharingProjects, managedProjects.size() * 10);
                    ArrayList<IProject> managed = new ArrayList<IProject>();
                    try {
                        for (Map.Entry entry : managedProjects.entrySet()) {
                            IProject project = (IProject)entry.getKey();
                            project.refreshLocal(2, (IProgressMonitor)sub2);
                            sub2.worked(10);
                            if (!PerforceProviderPlugin.manageProject((IProject)project, (ConnectionParameters)params)) continue;
                            P4ConnectionManager.getManager().getConnection(project);
                            managed.add(project);
                        }
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                    sub2.done();
                    if (managed.size() > 0 && (decorator = PerforceDecorator.getActivePerforceDecorator()) != null) {
                        decorator.resourceStateChanged((IResource[])managed.toArray(new IProject[managed.size()]));
                    }
                    monitor.worked(10);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            PerforceUIPlugin.handleError(Messages.SharingWizard_failed, e.getCause(), true);
            return false;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    public void init(IWorkbench workbench, IProject project) {
        this.init(workbench, new IProject[]{project});
    }

    public SelectConnectionWizardPage getConnectionPage() {
        return this.connectionPage;
    }

    public void init(IWorkbench workbench, IProject[] projects) {
        this.projects = projects;
    }
}

