<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.2/2785633
 */

namespace Reviews\Filter;

use Application\Filter\FilterTrait;
use Application\InputFilter\DirectInput;
use Application\InputFilter\InputFilter;
use Application\Validator\IsArray;
use Interop\Container\ContainerInterface;
use Laminas\Filter\StringTrim;

/**
 * Defines filters for create review operation.
 * @package Reviews\Filter
 */
class CreateReview extends InputFilter implements ICreateReview
{
    use FilterTrait;

    /**
     * Construct the filter
     * @param ContainerInterface $services services
     * @param array|null $options
     */
    public function __construct(ContainerInterface $services, array $options = null)
    {
        $this->addInt(self::CHANGE, null, PHP_INT_MAX, true);
        $this->addDescriptionFilter();
        $this->addReviewersFilter();
        $this->addRequiredReviewersFilter();
        $this->addReviewerQuorumFilter();
    }

    /**
     * Add a filter for description field
     */
    private function addDescriptionFilter()
    {
        $input = new DirectInput(self::DESCRIPTION);
        $input->setRequired(false);
        $input->getFilterChain()->attach(new StringTrim());
        $this->add($input);
    }

    /**
     * Add a filter for reviewers field
     */
    private function addReviewersFilter()
    {
        $input = new DirectInput(self::REVIEWERS);
        $input->setRequired(false);
        $input->getValidatorChain()->attach(new IsArray());
        $this->add($input);
    }

    /**
     * Add a filter for required reviewers field
     */
    private function addRequiredReviewersFilter()
    {
        $input = new DirectInput(self::REQUIRED_REVIEWERS);
        $input->setRequired(false);
        $input->getValidatorChain()->attach(new IsArray());
        $this->add($input);
    }

    /**
     * Add a filter for reviewer quorum field
     */
    private function addReviewerQuorumFilter()
    {
        $input = new DirectInput(self::REVIEWER_QUORUM);
        $input->setRequired(false);
        $input->getValidatorChain()->attach(new IsArray());
        $this->add($input);
    }
}
