<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.2/2785633
 */

namespace Application\Filter;

use Laminas\Filter\AbstractFilter;
use Laminas\Filter\StringTrim;

class StringTrimFilter extends AbstractFilter
{
    /**
     * This filter makes use of StringTrim.php from laminas-filter package &
     * returns the string $value with characters stripped from the beginning and end.
     * This custom filter is specifically made to convert input values to `string` for the `trim` function.
     *
     * @param mixed $value
     * @return string
     */
    public function filter($value): string
    {
        $stringTrim = new StringTrim();
        return $stringTrim->filter((string)$value);
    }
}
