/*
 * Copyright 2023 Perforce Software.  All rights reserved.
 *
 * This file is part of Perforce - the FAST SCM System.
 *
 * Please check that each new entry matches what is in msgconfig.cc:
 *
 * Current high value is: 518
 */

# define NEED_SMARTHEAP

# include <stdhdrs.h>
# include <error.h>
# include <errornum.h>

# include "msgconfig.h"

# ifdef HAS_CPP11

# include "msgconfig.cc"

# else

// Debug levels
ErrorId MsgConfig::Db = { ErrorOf( ES_CONFIG, 435, E_INFO, EV_NONE, 0 ), "MsgConfig::Db placeholder." };
ErrorId MsgConfig::Diff = { ErrorOf( ES_CONFIG, 436, E_INFO, EV_NONE, 0 ), "MsgConfig::Diff placeholder." };
ErrorId MsgConfig::Dm = { ErrorOf( ES_CONFIG, 437, E_INFO, EV_NONE, 0 ), "MsgConfig::Dm placeholder." };
ErrorId MsgConfig::Dmc = { ErrorOf( ES_CONFIG, 438, E_INFO, EV_NONE, 0 ), "MsgConfig::Dmc placeholder." };
ErrorId MsgConfig::Ftp = { ErrorOf( ES_CONFIG, 439, E_INFO, EV_NONE, 0 ), "MsgConfig::Ftp placeholder." };
ErrorId MsgConfig::Handle = { ErrorOf( ES_CONFIG, 440, E_INFO, EV_NONE, 0 ), "MsgConfig::Handle placeholder." };
ErrorId MsgConfig::Lbr = { ErrorOf( ES_CONFIG, 441, E_INFO, EV_NONE, 0 ), "MsgConfig::Lbr placeholder." };
ErrorId MsgConfig::Map = { ErrorOf( ES_CONFIG, 442, E_INFO, EV_NONE, 0 ), "MsgConfig::Map placeholder." };
ErrorId MsgConfig::Net = { ErrorOf( ES_CONFIG, 443, E_INFO, EV_NONE, 0 ), "MsgConfig::Net placeholder." };
ErrorId MsgConfig::Options = { ErrorOf( ES_CONFIG, 444, E_INFO, EV_NONE, 0 ), "MsgConfig::Options placeholder." };
ErrorId MsgConfig::Peek = { ErrorOf( ES_CONFIG, 445, E_INFO, EV_NONE, 0 ), "MsgConfig::Peek placeholder." };
ErrorId MsgConfig::Rcs = { ErrorOf( ES_CONFIG, 446, E_INFO, EV_NONE, 0 ), "MsgConfig::Rcs placeholder." };
ErrorId MsgConfig::Records = { ErrorOf( ES_CONFIG, 447, E_INFO, EV_NONE, 0 ), "MsgConfig::Records placeholder." };
ErrorId MsgConfig::Rpc = { ErrorOf( ES_CONFIG, 448, E_INFO, EV_NONE, 0 ), "MsgConfig::Rpc placeholder." };
ErrorId MsgConfig::Server = { ErrorOf( ES_CONFIG, 449, E_INFO, EV_NONE, 0 ), "MsgConfig::Server placeholder." };
ErrorId MsgConfig::Spec = { ErrorOf( ES_CONFIG, 450, E_INFO, EV_NONE, 0 ), "MsgConfig::Spec placeholder." };
ErrorId MsgConfig::Track = { ErrorOf( ES_CONFIG, 451, E_INFO, EV_NONE, 0 ), "MsgConfig::Track placeholder." };
ErrorId MsgConfig::Ob = { ErrorOf( ES_CONFIG, 452, E_INFO, EV_NONE, 0 ), "MsgConfig::Ob placeholder." };
ErrorId MsgConfig::Viewgen = { ErrorOf( ES_CONFIG, 453, E_INFO, EV_NONE, 0 ), "MsgConfig::Viewgen placeholder." };
ErrorId MsgConfig::Rpl = { ErrorOf( ES_CONFIG, 454, E_INFO, EV_NONE, 0 ), "MsgConfig::Rpl placeholder." };
ErrorId MsgConfig::Ssl = { ErrorOf( ES_CONFIG, 455, E_INFO, EV_NONE, 0 ), "MsgConfig::Ssl placeholder." };
ErrorId MsgConfig::Time = { ErrorOf( ES_CONFIG, 456, E_INFO, EV_NONE, 0 ), "MsgConfig::Time placeholder." };
ErrorId MsgConfig::Cluster = { ErrorOf( ES_CONFIG, 457, E_INFO, EV_NONE, 0 ), "MsgConfig::Cluster placeholder." };
ErrorId MsgConfig::Zk = { ErrorOf( ES_CONFIG, 458, E_INFO, EV_NONE, 0 ), "MsgConfig::Zk placeholder." };
ErrorId MsgConfig::Ldap = { ErrorOf( ES_CONFIG, 459, E_INFO, EV_NONE, 0 ), "MsgConfig::Ldap placeholder." };
ErrorId MsgConfig::Dvcs = { ErrorOf( ES_CONFIG, 460, E_INFO, EV_NONE, 0 ), "MsgConfig::Dvcs placeholder." };
ErrorId MsgConfig::Graph = { ErrorOf( ES_CONFIG, 461, E_INFO, EV_NONE, 0 ), "MsgConfig::Graph placeholder." };
ErrorId MsgConfig::Gconn = { ErrorOf( ES_CONFIG, 462, E_INFO, EV_NONE, 0 ), "MsgConfig::Gconn placeholder." };
ErrorId MsgConfig::Fovr = { ErrorOf( ES_CONFIG, 463, E_INFO, EV_NONE, 0 ), "MsgConfig::Fovr placeholder." };
ErrorId MsgConfig::Script = { ErrorOf( ES_CONFIG, 464, E_INFO, EV_NONE, 0 ), "MsgConfig::Script placeholder." };
ErrorId MsgConfig::Stg = { ErrorOf( ES_CONFIG, 465, E_INFO, EV_NONE, 0 ), "MsgConfig::Stg placeholder." };
ErrorId MsgConfig::Thread = { ErrorOf( ES_CONFIG, 466, E_INFO, EV_NONE, 0 ), "MsgConfig::Thread placeholder." };
ErrorId MsgConfig::Exts = { ErrorOf( ES_CONFIG, 467, E_INFO, EV_NONE, 0 ), "MsgConfig::Exts placeholder." };
ErrorId MsgConfig::Protect = { ErrorOf( ES_CONFIG, 468, E_INFO, EV_NONE, 0 ), "MsgConfig::Protect placeholder." };
ErrorId MsgConfig::Heartbeat = { ErrorOf( ES_CONFIG, 469, E_INFO, EV_NONE, 0 ), "MsgConfig::Heartbeat placeholder." };
ErrorId MsgConfig::Shelve = { ErrorOf( ES_CONFIG, 470, E_INFO, EV_NONE, 0 ), "MsgConfig::Shelve placeholder." };
ErrorId MsgConfig::Sqw = { ErrorOf( ES_CONFIG, 471, E_INFO, EV_NONE, 0 ), "MsgConfig::Sqw placeholder." };
ErrorId MsgConfig::Stm = { ErrorOf( ES_CONFIG, 472, E_INFO, EV_NONE, 0 ), "MsgConfig::Stm placeholder." };
ErrorId MsgConfig::Pcheck = { ErrorOf( ES_CONFIG, 473, E_INFO, EV_NONE, 0 ), "MsgConfig::Pcheck placeholder." };
ErrorId MsgConfig::Topology = { ErrorOf( ES_CONFIG, 474, E_INFO, EV_NONE, 0 ), "MsgConfig::Topology placeholder." };
ErrorId MsgConfig::Resource = { ErrorOf( ES_CONFIG, 475, E_INFO, EV_NONE, 0 ), "MsgConfig::Resource placeholder." };
ErrorId MsgConfig::S3 = { ErrorOf( ES_CONFIG, 476, E_INFO, EV_NONE, 0 ), "MsgConfig::S3 placeholder." };
ErrorId MsgConfig::Suptool = { ErrorOf( ES_CONFIG, 483, E_INFO, EV_NONE, 0 ), "MsgConfig::Suptool placeholder." };
ErrorId MsgConfig::Elog = { ErrorOf( ES_CONFIG, 490, E_INFO, EV_NONE, 0 ), "MsgConfig::Elog placeholder." };
ErrorId MsgConfig::Dltxfer = { ErrorOf( ES_CONFIG, 495, E_INFO, EV_NONE, 0 ), "MsgConfig::Dltxfer placeholder." };
ErrorId MsgConfig::Perf = { ErrorOf( ES_CONFIG, 501, E_INFO, EV_NONE, 0 ), "MsgConfig::Perf placeholder." };

// Numeric tunables
ErrorId MsgConfig::ClusterJournalShared = { ErrorOf( ES_CONFIG, 1, E_INFO, EV_NONE, 0), "MsgConfig::ClusterJournalShared placeholder." };
ErrorId MsgConfig::DbCheckpointBufsize = { ErrorOf( ES_CONFIG, 2, E_INFO, EV_NONE, 0), "MsgConfig::DbCheckpointBufsize placeholder." };
ErrorId MsgConfig::DbCheckpointThreads = { ErrorOf( ES_CONFIG, 3, E_INFO, EV_NONE, 0), "MsgConfig::DbCheckpointThreads placeholder." };
ErrorId MsgConfig::DbCheckpointWorklevel = { ErrorOf( ES_CONFIG, 4, E_INFO, EV_NONE, 0), "MsgConfig::DbCheckpointWorklevel placeholder." };
ErrorId MsgConfig::DbCheckpointReqlevel = { ErrorOf( ES_CONFIG, 5, E_INFO, EV_NONE, 0), "MsgConfig::DbCheckpointReqlevel placeholder." };
ErrorId MsgConfig::DbCheckpointNumfiles = { ErrorOf( ES_CONFIG, 6, E_INFO, EV_NONE, 0), "MsgConfig::DbCheckpointNumfiles placeholder." };
ErrorId MsgConfig::DbExperimentalLogging = { ErrorOf( ES_CONFIG, 7, E_INFO, EV_NONE, 0), "MsgConfig::DbExperimentalLogging placeholder." };
ErrorId MsgConfig::DbInternalRepair = { ErrorOf( ES_CONFIG, 8, E_INFO, EV_NONE, 0), "MsgConfig::DbInternalRepair placeholder." };
ErrorId MsgConfig::DbIsalive = { ErrorOf( ES_CONFIG, 9, E_INFO, EV_NONE, 0), "MsgConfig::DbIsalive placeholder." };
ErrorId MsgConfig::DbJnlackShared = { ErrorOf( ES_CONFIG, 10, E_INFO, EV_NONE, 0), "MsgConfig::DbJnlackShared placeholder." };
ErrorId MsgConfig::DbJournalrotateWarnthresh = { ErrorOf( ES_CONFIG, 488, E_INFO, EV_NONE, 0), "MsgConfig::DbJournalrotateWarnthresh placeholder." };
ErrorId MsgConfig::DbMonitorAddthresh = { ErrorOf( ES_CONFIG, 11, E_INFO, EV_NONE, 0), "MsgConfig::DbMonitorAddthresh placeholder." };
ErrorId MsgConfig::DbMonitorInterval = { ErrorOf( ES_CONFIG, 12, E_INFO, EV_NONE, 0), "MsgConfig::DbMonitorInterval placeholder." };
ErrorId MsgConfig::DbMonitorMinruntime = { ErrorOf( ES_CONFIG, 13, E_INFO, EV_NONE, 0), "MsgConfig::DbMonitorMinruntime placeholder." };
ErrorId MsgConfig::DbMonitorTermallow = { ErrorOf( ES_CONFIG, 14, E_INFO, EV_NONE, 0), "MsgConfig::DbMonitorTermallow placeholder." };
ErrorId MsgConfig::DbMonitorShared = { ErrorOf( ES_CONFIG, 15, E_INFO, EV_NONE, 0), "MsgConfig::DbMonitorShared placeholder." };
ErrorId MsgConfig::DbPageMigrate = { ErrorOf( ES_CONFIG, 16, E_INFO, EV_NONE, 0), "MsgConfig::DbPageMigrate placeholder." };
ErrorId MsgConfig::DbPartitionDrop = { ErrorOf( ES_CONFIG, 486, E_INFO, EV_NONE, 0), "MsgConfig::DbPartitionDrop placeholder." };
ErrorId MsgConfig::DbPartitionVerify = { ErrorOf( ES_CONFIG, 485, E_INFO, EV_NONE, 0), "MsgConfig::DbPartitionVerify placeholder." };
ErrorId MsgConfig::DbPeeking = { ErrorOf( ES_CONFIG, 17, E_INFO, EV_NONE, 0), "MsgConfig::DbPeeking placeholder." };
ErrorId MsgConfig::DbPeekingUsemaxlock = { ErrorOf( ES_CONFIG, 18, E_INFO, EV_NONE, 0), "MsgConfig::DbPeekingUsemaxlock placeholder." };
ErrorId MsgConfig::DbReorgDisable = { ErrorOf( ES_CONFIG, 19, E_INFO, EV_NONE, 0), "MsgConfig::DbReorgDisable placeholder." };
ErrorId MsgConfig::DbReorgMisorder = { ErrorOf( ES_CONFIG, 20, E_INFO, EV_NONE, 0), "MsgConfig::DbReorgMisorder placeholder." };
ErrorId MsgConfig::DbReorgOccup = { ErrorOf( ES_CONFIG, 21, E_INFO, EV_NONE, 0), "MsgConfig::DbReorgOccup placeholder." };
ErrorId MsgConfig::DbRtIo = { ErrorOf( ES_CONFIG, 22, E_INFO, EV_NONE, 0), "MsgConfig::DbRtIo placeholder." };
ErrorId MsgConfig::DbTrylock = { ErrorOf( ES_CONFIG, 23, E_INFO, EV_NONE, 0), "MsgConfig::DbTrylock placeholder." };
ErrorId MsgConfig::DbarrayPutcheck = { ErrorOf( ES_CONFIG, 24, E_INFO, EV_NONE, 0), "MsgConfig::DbarrayPutcheck placeholder." };
ErrorId MsgConfig::DbarrayReserve = { ErrorOf( ES_CONFIG, 25, E_INFO, EV_NONE, 0), "MsgConfig::DbarrayReserve placeholder." };
ErrorId MsgConfig::DbjournalBufsize = { ErrorOf( ES_CONFIG, 26, E_INFO, EV_NONE, 0), "MsgConfig::DbjournalBufsize placeholder." };
ErrorId MsgConfig::DbjournalWordsize = { ErrorOf( ES_CONFIG, 27, E_INFO, EV_NONE, 0), "MsgConfig::DbjournalWordsize placeholder." };
ErrorId MsgConfig::DbopenCache = { ErrorOf( ES_CONFIG, 28, E_INFO, EV_NONE, 0), "MsgConfig::DbopenCache placeholder." };
ErrorId MsgConfig::DbopenCacheWide = { ErrorOf( ES_CONFIG, 29, E_INFO, EV_NONE, 0), "MsgConfig::DbopenCacheWide placeholder." };
ErrorId MsgConfig::DbopenFreepct = { ErrorOf( ES_CONFIG, 30, E_INFO, EV_NONE, 0), "MsgConfig::DbopenFreepct placeholder." };
ErrorId MsgConfig::DbopenMismatchDelay = { ErrorOf( ES_CONFIG, 31, E_INFO, EV_NONE, 0), "MsgConfig::DbopenMismatchDelay placeholder." };
ErrorId MsgConfig::DbopenNofsync = { ErrorOf( ES_CONFIG, 32, E_INFO, EV_NONE, 0), "MsgConfig::DbopenNofsync placeholder." };
ErrorId MsgConfig::DbopenPagesize = { ErrorOf( ES_CONFIG, 33, E_INFO, EV_NONE, 0), "MsgConfig::DbopenPagesize placeholder." };
ErrorId MsgConfig::DbopenRetry = { ErrorOf( ES_CONFIG, 34, E_INFO, EV_NONE, 0), "MsgConfig::DbopenRetry placeholder." };
ErrorId MsgConfig::DiffBinaryRcs = { ErrorOf( ES_CONFIG, 35, E_INFO, EV_NONE, 0), "MsgConfig::DiffBinaryRcs placeholder." };
ErrorId MsgConfig::DiffSlimit1 = { ErrorOf( ES_CONFIG, 36, E_INFO, EV_NONE, 0), "MsgConfig::DiffSlimit1 placeholder." };
ErrorId MsgConfig::DiffSlimit2 = { ErrorOf( ES_CONFIG, 37, E_INFO, EV_NONE, 0), "MsgConfig::DiffSlimit2 placeholder." };
ErrorId MsgConfig::DiffSthresh = { ErrorOf( ES_CONFIG, 38, E_INFO, EV_NONE, 0), "MsgConfig::DiffSthresh placeholder." };
ErrorId MsgConfig::DmAltsyncEnforce = { ErrorOf( ES_CONFIG, 39, E_INFO, EV_NONE, 0), "MsgConfig::DmAltsyncEnforce placeholder." };
ErrorId MsgConfig::DmAnnotateMaxsize = { ErrorOf( ES_CONFIG, 40, E_INFO, EV_NONE, 0), "MsgConfig::DmAnnotateMaxsize placeholder." };
ErrorId MsgConfig::DmBatchDomains = { ErrorOf( ES_CONFIG, 41, E_INFO, EV_NONE, 0), "MsgConfig::DmBatchDomains placeholder." };
ErrorId MsgConfig::DmBatchNet = { ErrorOf( ES_CONFIG, 42, E_INFO, EV_NONE, 0), "MsgConfig::DmBatchNet placeholder." };
ErrorId MsgConfig::DmChangeRestrictPending = { ErrorOf( ES_CONFIG, 43, E_INFO, EV_NONE, 0), "MsgConfig::DmChangeRestrictPending placeholder." };
ErrorId MsgConfig::DmChangeSkipkeyed = { ErrorOf( ES_CONFIG, 44, E_INFO, EV_NONE, 0), "MsgConfig::DmChangeSkipkeyed placeholder." };
ErrorId MsgConfig::DmChangesThresh1 = { ErrorOf( ES_CONFIG, 45, E_INFO, EV_NONE, 0), "MsgConfig::DmChangesThresh1 placeholder." };
ErrorId MsgConfig::DmChangesThresh2 = { ErrorOf( ES_CONFIG, 46, E_INFO, EV_NONE, 0), "MsgConfig::DmChangesThresh2 placeholder." };
ErrorId MsgConfig::DmChangeviewOpenable = { ErrorOf( ES_CONFIG, 47, E_INFO, EV_NONE, 0), "MsgConfig::DmChangeviewOpenable placeholder." };
ErrorId MsgConfig::DmClientInitroot = { ErrorOf( ES_CONFIG, 48, E_INFO, EV_NONE, 0), "MsgConfig::DmClientInitroot placeholder." };
ErrorId MsgConfig::DmClientLimitprotects = { ErrorOf( ES_CONFIG, 49, E_INFO, EV_NONE, 0), "MsgConfig::DmClientLimitprotects placeholder." };
ErrorId MsgConfig::DmConfigureCommentMandatory = { ErrorOf( ES_CONFIG, 481, E_INFO, EV_NONE, 0), "MsgConfig::DmConfigureCommentMandatory placeholder." };
ErrorId MsgConfig::DmCopyAttributes = { ErrorOf( ES_CONFIG, 518, E_INFO, EV_NONE, 0 ), "MsgConfig::DmCopyAttributes placeholder." };
ErrorId MsgConfig::DmCopyMovewarn = { ErrorOf( ES_CONFIG, 50, E_INFO, EV_NONE, 0), "MsgConfig::DmCopyMovewarn placeholder." };
ErrorId MsgConfig::DmDomainAccessupdate = { ErrorOf( ES_CONFIG, 51, E_INFO, EV_NONE, 0), "MsgConfig::DmDomainAccessupdate placeholder." };
ErrorId MsgConfig::DmDomainAccessforce = { ErrorOf( ES_CONFIG, 52, E_INFO, EV_NONE, 0), "MsgConfig::DmDomainAccessforce placeholder." };
ErrorId MsgConfig::DmFetchPreservechangenumbers = { ErrorOf( ES_CONFIG, 53, E_INFO, EV_NONE, 0), "MsgConfig::DmFetchPreservechangenumbers placeholder." };
ErrorId MsgConfig::DmFlushforce = { ErrorOf( ES_CONFIG, 54, E_INFO, EV_NONE, 0), "MsgConfig::DmFlushforce placeholder." };
ErrorId MsgConfig::DmFlushtry = { ErrorOf( ES_CONFIG, 55, E_INFO, EV_NONE, 0), "MsgConfig::DmFlushtry placeholder." };
ErrorId MsgConfig::DmFstatOutputthreshold = { ErrorOf( ES_CONFIG, 480, E_INFO, EV_NONE, 0), "MsgConfig::DmFstatOutputthreshold placeholder." };
ErrorId MsgConfig::DmFstatMaxcontent = { ErrorOf( ES_CONFIG, 56, E_INFO, EV_NONE, 0), "MsgConfig::DmFstatMaxcontent placeholder." };
ErrorId MsgConfig::DmGraphEnabled = { ErrorOf( ES_CONFIG, 57, E_INFO, EV_NONE, 0), "MsgConfig::DmGraphEnabled placeholder." };
ErrorId MsgConfig::DmGrepMaxlinelength = { ErrorOf( ES_CONFIG, 58, E_INFO, EV_NONE, 0), "MsgConfig::DmGrepMaxlinelength placeholder." };
ErrorId MsgConfig::DmGrepMaxrevs = { ErrorOf( ES_CONFIG, 59, E_INFO, EV_NONE, 0), "MsgConfig::DmGrepMaxrevs placeholder." };
ErrorId MsgConfig::DmGrepMaxcontext = { ErrorOf( ES_CONFIG, 60, E_INFO, EV_NONE, 0), "MsgConfig::DmGrepMaxcontext placeholder." };
ErrorId MsgConfig::DmHavePreload = { ErrorOf( ES_CONFIG, 508, E_INFO, EV_NONE, 0), "MsgConfig::DmHavePreload placeholder." };
ErrorId MsgConfig::DmInfoHide = { ErrorOf( ES_CONFIG, 61, E_INFO, EV_NONE, 0), "MsgConfig::DmInfoHide placeholder." };
ErrorId MsgConfig::DmIntegEngine = { ErrorOf( ES_CONFIG, 62, E_INFO, EV_NONE, 0), "MsgConfig::DmIntegEngine placeholder." };
ErrorId MsgConfig::DmIntegMaxact = { ErrorOf( ES_CONFIG, 63, E_INFO, EV_NONE, 0), "MsgConfig::DmIntegMaxact placeholder." };
ErrorId MsgConfig::DmIntegStreamAllowDepotFilespec = { ErrorOf( ES_CONFIG, 492, E_INFO, EV_NONE, 0 ), "MsgConfig::DmIntegStreamAllowDepotFilespec placeholder." };
ErrorId MsgConfig::DmIntegMaxbranch = { ErrorOf( ES_CONFIG, 64, E_INFO, EV_NONE, 0), "MsgConfig::DmIntegMaxbranch placeholder." };
ErrorId MsgConfig::DmIntegStreamspec = { ErrorOf( ES_CONFIG, 65, E_INFO, EV_NONE, 0), "MsgConfig::DmIntegStreamspec placeholder." };
ErrorId MsgConfig::DmIntegTweaks = { ErrorOf( ES_CONFIG, 66, E_INFO, EV_NONE, 0), "MsgConfig::DmIntegTweaks placeholder." };
ErrorId MsgConfig::DmIntegUndo = { ErrorOf( ES_CONFIG, 67, E_INFO, EV_NONE, 0), "MsgConfig::DmIntegUndo placeholder." };
ErrorId MsgConfig::DmIntegMultipleStreams = { ErrorOf( ES_CONFIG, 68, E_INFO, EV_NONE, 0), "MsgConfig::DmIntegMultipleStreams placeholder." };
ErrorId MsgConfig::DmIsalive = { ErrorOf( ES_CONFIG, 69, E_INFO, EV_NONE, 0), "MsgConfig::DmIsalive placeholder." };
ErrorId MsgConfig::DmKeysHide = { ErrorOf( ES_CONFIG, 70, E_INFO, EV_NONE, 0), "MsgConfig::DmKeysHide placeholder." };
ErrorId MsgConfig::DmLabelsSearchAutoreload = { ErrorOf( ES_CONFIG, 71, E_INFO, EV_NONE, 0), "MsgConfig::DmLabelsSearchAutoreload placeholder." };
ErrorId MsgConfig::DmLockBatch = { ErrorOf( ES_CONFIG, 72, E_INFO, EV_NONE, 0), "MsgConfig::DmLockBatch placeholder." };
ErrorId MsgConfig::DmLocksExclBatchNet = { ErrorOf( ES_CONFIG, 73, E_INFO, EV_NONE, 0), "MsgConfig::DmLocksExclBatchNet placeholder." };
ErrorId MsgConfig::DmLocksGlobalBatchNet = { ErrorOf( ES_CONFIG, 74, E_INFO, EV_NONE, 0), "MsgConfig::DmLocksGlobalBatchNet placeholder." };
ErrorId MsgConfig::DmLocksGlobalResultBatchNet = { ErrorOf( ES_CONFIG, 75, E_INFO, EV_NONE, 0), "MsgConfig::DmLocksGlobalResultBatchNet placeholder." };
ErrorId MsgConfig::DmMaxkey = { ErrorOf( ES_CONFIG, 76, E_INFO, EV_NONE, 0), "MsgConfig::DmMaxkey placeholder." };
ErrorId MsgConfig::DmOpenShowGloballocks = { ErrorOf( ES_CONFIG, 77, E_INFO, EV_NONE, 0), "MsgConfig::DmOpenShowGloballocks placeholder." };
ErrorId MsgConfig::DmPasswordMinlength = { ErrorOf( ES_CONFIG, 78, E_INFO, EV_NONE, 0), "MsgConfig::DmPasswordMinlength placeholder." };
ErrorId MsgConfig::DmPopulateSkipkeyed = { ErrorOf( ES_CONFIG, 79, E_INFO, EV_NONE, 0), "MsgConfig::DmPopulateSkipkeyed placeholder." };
ErrorId MsgConfig::DmProtectsAllowAdmin = { ErrorOf( ES_CONFIG, 80, E_INFO, EV_NONE, 0), "MsgConfig::DmProtectsAllowAdmin placeholder." };
ErrorId MsgConfig::DmProtectsExclusioncheck = { ErrorOf( ES_CONFIG, 81, E_INFO, EV_NONE, 0), "MsgConfig::DmProtectsExclusioncheck placeholder." };
ErrorId MsgConfig::DmProtectsHide = { ErrorOf( ES_CONFIG, 82, E_INFO, EV_NONE, 0), "MsgConfig::DmProtectsHide placeholder." };
ErrorId MsgConfig::DmProtectsStreamspec = { ErrorOf( ES_CONFIG, 83, E_INFO, EV_NONE, 0), "MsgConfig::DmProtectsStreamspec placeholder." };
ErrorId MsgConfig::DmProxyProtects = { ErrorOf( ES_CONFIG, 84, E_INFO, EV_NONE, 0), "MsgConfig::DmProxyProtects placeholder." };
ErrorId MsgConfig::DmQuickClients = { ErrorOf( ES_CONFIG, 85, E_INFO, EV_NONE, 0), "MsgConfig::DmQuickClients placeholder." };
ErrorId MsgConfig::DmQuickDomains = { ErrorOf( ES_CONFIG, 86, E_INFO, EV_NONE, 0), "MsgConfig::DmQuickDomains placeholder." };
ErrorId MsgConfig::DmQuickHave = { ErrorOf( ES_CONFIG, 87, E_INFO, EV_NONE, 0), "MsgConfig::DmQuickHave placeholder." };
ErrorId MsgConfig::DmQuickInteg = { ErrorOf( ES_CONFIG, 88, E_INFO, EV_NONE, 0), "MsgConfig::DmQuickInteg placeholder." };
ErrorId MsgConfig::DmQuickResolve = { ErrorOf( ES_CONFIG, 89, E_INFO, EV_NONE, 0), "MsgConfig::DmQuickResolve placeholder." };
ErrorId MsgConfig::DmQuickRev = { ErrorOf( ES_CONFIG, 90, E_INFO, EV_NONE, 0), "MsgConfig::DmQuickRev placeholder." };
ErrorId MsgConfig::DmQuickWorking = { ErrorOf( ES_CONFIG, 91, E_INFO, EV_NONE, 0), "MsgConfig::DmQuickWorking placeholder." };
ErrorId MsgConfig::DmRenameuserScanthresh = { ErrorOf( ES_CONFIG, 482, E_INFO, EV_NONE, 0), "MsgConfig::DmRenameuserScanthresh placeholder." };
ErrorId MsgConfig::DmRepoNoautocreate = { ErrorOf( ES_CONFIG, 92, E_INFO, EV_NONE, 0), "MsgConfig::DmRepoNoautocreate placeholder." };
ErrorId MsgConfig::DmRepoUnpack = { ErrorOf( ES_CONFIG, 93, E_INFO, EV_NONE, 0), "MsgConfig::DmRepoUnpack placeholder." };
ErrorId MsgConfig::DmResolveAttrib = { ErrorOf( ES_CONFIG, 94, E_INFO, EV_NONE, 0), "MsgConfig::DmResolveAttrib placeholder." };
ErrorId MsgConfig::DmResolveIgnoredeleted = { ErrorOf( ES_CONFIG, 95, E_INFO, EV_NONE, 0), "MsgConfig::DmResolveIgnoredeleted placeholder." };
ErrorId MsgConfig::DmRevScanThresh = { ErrorOf( ES_CONFIG, 96, E_INFO, EV_NONE, 0), "MsgConfig::DmRevScanThresh placeholder." };
ErrorId MsgConfig::DmRevcxThresh1 = { ErrorOf( ES_CONFIG, 97, E_INFO, EV_NONE, 0), "MsgConfig::DmRevcxThresh1 placeholder." };
ErrorId MsgConfig::DmRevcxThresh2 = { ErrorOf( ES_CONFIG, 98, E_INFO, EV_NONE, 0), "MsgConfig::DmRevcxThresh2 placeholder." };
ErrorId MsgConfig::DmRevertBatch = { ErrorOf( ES_CONFIG, 99, E_INFO, EV_NONE, 0), "MsgConfig::DmRevertBatch placeholder." };
ErrorId MsgConfig::DmRotatelogwithjnl = { ErrorOf( ES_CONFIG, 100, E_INFO, EV_NONE, 0), "MsgConfig::DmRotatelogwithjnl placeholder." };
ErrorId MsgConfig::DmShelveAccessupdate = { ErrorOf( ES_CONFIG, 101, E_INFO, EV_NONE, 0), "MsgConfig::DmShelveAccessupdate placeholder." };
ErrorId MsgConfig::DmShelveMaxfiles = { ErrorOf( ES_CONFIG, 102, E_INFO, EV_NONE, 0), "MsgConfig::DmShelveMaxfiles placeholder." };
ErrorId MsgConfig::DmShelveMaxsize = { ErrorOf( ES_CONFIG, 103, E_INFO, EV_NONE, 0), "MsgConfig::DmShelveMaxsize placeholder." };
ErrorId MsgConfig::DmShelvePromote = { ErrorOf( ES_CONFIG, 104, E_INFO, EV_NONE, 0), "MsgConfig::DmShelvePromote placeholder." };
ErrorId MsgConfig::DmStatusMatchlines = { ErrorOf( ES_CONFIG, 105, E_INFO, EV_NONE, 0), "MsgConfig::DmStatusMatchlines placeholder." };
ErrorId MsgConfig::DmStatusMatchsize = { ErrorOf( ES_CONFIG, 106, E_INFO, EV_NONE, 0), "MsgConfig::DmStatusMatchsize placeholder." };
ErrorId MsgConfig::DmStreamParentview = { ErrorOf( ES_CONFIG, 107, E_INFO, EV_NONE, 0), "MsgConfig::DmStreamParentview placeholder." };
ErrorId MsgConfig::DmStreamComponents = { ErrorOf( ES_CONFIG, 108, E_INFO, EV_NONE, 0), "MsgConfig::DmStreamComponents placeholder." };
ErrorId MsgConfig::DmStreamSparseBranchMax = { ErrorOf( ES_CONFIG, 433, E_INFO, EV_NONE, 0), "MsgConfig::DmStreamSparseBranchMax placeholder." };
ErrorId MsgConfig::DmSyncStreamChange = { ErrorOf( ES_CONFIG, 109, E_INFO, EV_NONE, 0), "MsgConfig::DmSyncStreamChange placeholder." };
ErrorId MsgConfig::DmSubprotectsGrantAdmin = { ErrorOf( ES_CONFIG, 110, E_INFO, EV_NONE, 0), "MsgConfig::DmSubprotectsGrantAdmin placeholder." };
ErrorId MsgConfig::DmTopologyLastseenupdate = { ErrorOf( ES_CONFIG, 111, E_INFO, EV_NONE, 0), "MsgConfig::DmTopologyLastseenupdate placeholder." };
ErrorId MsgConfig::DmUserAccessupdate = { ErrorOf( ES_CONFIG, 112, E_INFO, EV_NONE, 0), "MsgConfig::DmUserAccessupdate placeholder." };
ErrorId MsgConfig::DmUserAccessforce = { ErrorOf( ES_CONFIG, 113, E_INFO, EV_NONE, 0), "MsgConfig::DmUserAccessforce placeholder." };
ErrorId MsgConfig::DmUserAccessmode = { ErrorOf( ES_CONFIG, 505, E_INFO, EV_NONE, 0), "MsgConfig::DmUserAccessmode placeholder." };
ErrorId MsgConfig::DmUserAllowselfupdate = { ErrorOf( ES_CONFIG, 114, E_INFO, EV_NONE, 0), "MsgConfig::DmUserAllowselfupdate placeholder." };
ErrorId MsgConfig::DmUserHideinvalid = { ErrorOf(ES_CONFIG, 478, E_INFO, EV_NONE, 0), "MsgConfig::DmUserHideinvalid placeholder." };
ErrorId MsgConfig::DmUserInsecurelogin = { ErrorOf( ES_CONFIG, 115, E_INFO, EV_NONE, 0), "MsgConfig::DmUserInsecurelogin placeholder." };
ErrorId MsgConfig::DmUserLoginattempts = { ErrorOf( ES_CONFIG, 116, E_INFO, EV_NONE, 0), "MsgConfig::DmUserLoginattempts placeholder." };
ErrorId MsgConfig::DmUserNoautocreate = { ErrorOf( ES_CONFIG, 117, E_INFO, EV_NONE, 0), "MsgConfig::DmUserNoautocreate placeholder." };
ErrorId MsgConfig::DmUserNumeric = { ErrorOf( ES_CONFIG, 118, E_INFO, EV_NONE, 0), "MsgConfig::DmUserNumeric placeholder." };
ErrorId MsgConfig::DmUserResetpassword = { ErrorOf( ES_CONFIG, 119, E_INFO, EV_NONE, 0), "MsgConfig::DmUserResetpassword placeholder." };
ErrorId MsgConfig::DmUserSetinitialpasswd = { ErrorOf( ES_CONFIG, 120, E_INFO, EV_NONE, 0), "MsgConfig::DmUserSetinitialpasswd placeholder." };
ErrorId MsgConfig::FilesysAtomicRename = { ErrorOf( ES_CONFIG, 121, E_INFO, EV_NONE, 0), "MsgConfig::FilesysAtomicRename placeholder." };
ErrorId MsgConfig::FilesysBinaryscan = { ErrorOf( ES_CONFIG, 122, E_INFO, EV_NONE, 0), "MsgConfig::FilesysBinaryscan placeholder." };
ErrorId MsgConfig::FilesysBufsize = { ErrorOf( ES_CONFIG, 123, E_INFO, EV_NONE, 0), "MsgConfig::FilesysBufsize placeholder." };
ErrorId MsgConfig::FilesysCachehint = { ErrorOf( ES_CONFIG, 124, E_INFO, EV_NONE, 0), "MsgConfig::FilesysCachehint placeholder." };
ErrorId MsgConfig::FilesysChecklinks = { ErrorOf( ES_CONFIG, 125, E_INFO, EV_NONE, 0), "MsgConfig::FilesysChecklinks placeholder." };
ErrorId MsgConfig::FilesysDetectunicode = { ErrorOf( ES_CONFIG, 126, E_INFO, EV_NONE, 0), "MsgConfig::FilesysDetectunicode placeholder." };
ErrorId MsgConfig::FilesysDetectutf8 = { ErrorOf( ES_CONFIG, 127, E_INFO, EV_NONE, 0), "MsgConfig::FilesysDetectutf8 placeholder." };
ErrorId MsgConfig::FilesysLockdelay = { ErrorOf( ES_CONFIG, 128, E_INFO, EV_NONE, 0), "MsgConfig::FilesysLockdelay placeholder." };
ErrorId MsgConfig::FilesysLocktimeout = { ErrorOf( ES_CONFIG, 129, E_INFO, EV_NONE, 0), "MsgConfig::FilesysLocktimeout placeholder." };
ErrorId MsgConfig::FilesysLocktry = { ErrorOf( ES_CONFIG, 130, E_INFO, EV_NONE, 0), "MsgConfig::FilesysLocktry placeholder." };
ErrorId MsgConfig::FilesysMaketmp = { ErrorOf( ES_CONFIG, 131, E_INFO, EV_NONE, 0), "MsgConfig::FilesysMaketmp placeholder." };
ErrorId MsgConfig::FilesysMaxmap = { ErrorOf( ES_CONFIG, 132, E_INFO, EV_NONE, 0), "MsgConfig::FilesysMaxmap placeholder." };
ErrorId MsgConfig::FilesysMaxsymlink = { ErrorOf( ES_CONFIG, 133, E_INFO, EV_NONE, 0), "MsgConfig::FilesysMaxsymlink placeholder." };
ErrorId MsgConfig::FilesysMaxtmp = { ErrorOf( ES_CONFIG, 134, E_INFO, EV_NONE, 0), "MsgConfig::FilesysMaxtmp placeholder." };
ErrorId MsgConfig::FilesysRestrictsymlinks = { ErrorOf( ES_CONFIG, 135, E_INFO, EV_NONE, 0), "MsgConfig::FilesysRestrictsymlinks placeholder." };
ErrorId MsgConfig::FilesysUtf8Bom = { ErrorOf( ES_CONFIG, 136, E_INFO, EV_NONE, 0), "MsgConfig::FilesysUtf8Bom placeholder." };
ErrorId MsgConfig::FilesysExtendlowmark = { ErrorOf( ES_CONFIG, 137, E_INFO, EV_NONE, 0), "MsgConfig::FilesysExtendlowmark placeholder." };
ErrorId MsgConfig::FilesysWindowsLfn = { ErrorOf( ES_CONFIG, 138, E_INFO, EV_NONE, 0), "MsgConfig::FilesysWindowsLfn placeholder." };
ErrorId MsgConfig::FilesysClientNullsync = { ErrorOf( ES_CONFIG, 139, E_INFO, EV_NONE, 0), "MsgConfig::FilesysClientNullsync placeholder." };
ErrorId MsgConfig::IndexDomainOwner = { ErrorOf( ES_CONFIG, 140, E_INFO, EV_NONE, 0), "MsgConfig::IndexDomainOwner placeholder." };
ErrorId MsgConfig::LbrAutocompress = { ErrorOf( ES_CONFIG, 141, E_INFO, EV_NONE, 0), "MsgConfig::LbrAutocompress placeholder." };
ErrorId MsgConfig::LbrBufsize = { ErrorOf( ES_CONFIG, 142, E_INFO, EV_NONE, 0), "MsgConfig::LbrBufsize placeholder." };
ErrorId MsgConfig::LbrFabricate = { ErrorOf( ES_CONFIG, 143, E_INFO, EV_NONE, 0), "MsgConfig::LbrFabricate placeholder." };
ErrorId MsgConfig::LbrProxyCase = { ErrorOf( ES_CONFIG, 144, E_INFO, EV_NONE, 0), "MsgConfig::LbrProxyCase placeholder." };
ErrorId MsgConfig::LbrRcsExistcheck = { ErrorOf( ES_CONFIG, 145, E_INFO, EV_NONE, 0), "MsgConfig::LbrRcsExistcheck placeholder." };
ErrorId MsgConfig::LbrRcsMaxlen = { ErrorOf( ES_CONFIG, 146, E_INFO, EV_NONE, 0), "MsgConfig::LbrRcsMaxlen placeholder." };
ErrorId MsgConfig::LbrReplicaNotransfer = { ErrorOf( ES_CONFIG, 147, E_INFO, EV_NONE, 0), "MsgConfig::LbrReplicaNotransfer placeholder." };
ErrorId MsgConfig::LbrRetryMax = { ErrorOf( ES_CONFIG, 148, E_INFO, EV_NONE, 0), "MsgConfig::LbrRetryMax placeholder." };
ErrorId MsgConfig::LbrScanIgnore = { ErrorOf( ES_CONFIG, 499, E_INFO, EV_NONE, 0 ),"MsgConfig::LbrScanIgnore placeholder." };
ErrorId MsgConfig::LbrS3UploadRetries = { ErrorOf( ES_CONFIG, 494, E_INFO, EV_NONE, 0), "MsgConfig::LbrS3UploadRetries placeholder." };
ErrorId MsgConfig::LbrStatInterval = { ErrorOf( ES_CONFIG, 149, E_INFO, EV_NONE, 0), "MsgConfig::LbrStatInterval placeholder." };
ErrorId MsgConfig::LbrVerifyIn = { ErrorOf( ES_CONFIG, 150, E_INFO, EV_NONE, 0), "MsgConfig::LbrVerifyIn placeholder." };
ErrorId MsgConfig::LbrVerifyOut = { ErrorOf( ES_CONFIG, 151, E_INFO, EV_NONE, 0), "MsgConfig::LbrVerifyOut placeholder." };
ErrorId MsgConfig::LbrVerifyScriptOut = { ErrorOf( ES_CONFIG, 152, E_INFO, EV_NONE, 0), "MsgConfig::LbrVerifyScriptOut placeholder." };
ErrorId MsgConfig::LbrStorageDelay = { ErrorOf( ES_CONFIG, 153, E_INFO, EV_NONE, 0), "MsgConfig::LbrStorageDelay placeholder." };
ErrorId MsgConfig::LbrStorageAllowsymlink = { ErrorOf( ES_CONFIG, 154, E_INFO, EV_NONE, 0), "MsgConfig::LbrStorageAllowsymlink placeholder." };
ErrorId MsgConfig::LbrStorageSkipkeyed = { ErrorOf( ES_CONFIG, 155, E_INFO, EV_NONE, 0), "MsgConfig::LbrStorageSkipkeyed placeholder." };
ErrorId MsgConfig::LbrStorageThreads = { ErrorOf( ES_CONFIG, 156, E_INFO, EV_NONE, 0), "MsgConfig::LbrStorageThreads placeholder." };
ErrorId MsgConfig::LbrRcsLocking = { ErrorOf( ES_CONFIG, 157, E_INFO, EV_NONE, 0), "MsgConfig::LbrRcsLocking placeholder." };
ErrorId MsgConfig::LogGroupMaxlen = { ErrorOf( ES_CONFIG, 158, E_INFO, EV_NONE, 0), "MsgConfig::LogGroupMaxlen placeholder." };
ErrorId MsgConfig::LogOriginhost = { ErrorOf( ES_CONFIG, 159, E_INFO, EV_NONE, 0), "MsgConfig::LogOriginhost placeholder." };
ErrorId MsgConfig::MapJoinmax1 = { ErrorOf( ES_CONFIG, 160, E_INFO, EV_NONE, 0), "MsgConfig::MapJoinmax1 placeholder." };
ErrorId MsgConfig::MapJoinmax2 = { ErrorOf( ES_CONFIG, 161, E_INFO, EV_NONE, 0), "MsgConfig::MapJoinmax2 placeholder." };
ErrorId MsgConfig::MapLimitMaxlookback = { ErrorOf( ES_CONFIG, 477, E_INFO, EV_NONE, 0), "MsgConfig::MapLimitMaxlookback placeholder." };
ErrorId MsgConfig::MapMaxwild = { ErrorOf( ES_CONFIG, 162, E_INFO, EV_NONE, 0), "MsgConfig::MapMaxwild placeholder." };
ErrorId MsgConfig::MapOverlayLegacy = { ErrorOf( ES_CONFIG, 163, E_INFO, EV_NONE, 0), "MsgConfig::MapOverlayLegacy placeholder." };
ErrorId MsgConfig::MergeDlEndeol = { ErrorOf( ES_CONFIG, 164, E_INFO, EV_NONE, 0), "MsgConfig::MergeDlEndeol placeholder." };
ErrorId MsgConfig::NetAutotune = { ErrorOf( ES_CONFIG, 165, E_INFO, EV_NONE, 0), "MsgConfig::NetAutotune placeholder." };
ErrorId MsgConfig::NetBufsize = { ErrorOf( ES_CONFIG, 166, E_INFO, EV_NONE, 0), "MsgConfig::NetBufsize placeholder." };
ErrorId MsgConfig::NetDeltaRplMinsize = { ErrorOf( ES_CONFIG, 506, E_INFO, EV_NONE, 0), "MsgConfig::NetDeltaRplMinsize placeholder." };
ErrorId MsgConfig::NetDeltaRplThreshold = { ErrorOf( ES_CONFIG, 507, E_INFO, EV_NONE, 0), "MsgConfig::NetDeltaRplThreshold placeholder." };
ErrorId MsgConfig::NetDeltaTransferMinsize = { ErrorOf( ES_CONFIG, 487, E_INFO, EV_NONE, 0), "MsgConfig::NetDeltaTransferMinsize placeholder." };
ErrorId MsgConfig::NetDeltaTransferThreshold = { ErrorOf( ES_CONFIG, 489, E_INFO, EV_NONE, 0), "MsgConfig::NetDeltaTransferThreshold placeholder." };
ErrorId MsgConfig::NetKeepaliveDisable = { ErrorOf( ES_CONFIG, 167, E_INFO, EV_NONE, 0), "MsgConfig::NetKeepaliveDisable placeholder." };
ErrorId MsgConfig::NetKeepaliveIdle = { ErrorOf( ES_CONFIG, 168, E_INFO, EV_NONE, 0), "MsgConfig::NetKeepaliveIdle placeholder." };
ErrorId MsgConfig::NetKeepaliveInterval = { ErrorOf( ES_CONFIG, 169, E_INFO, EV_NONE, 0), "MsgConfig::NetKeepaliveInterval placeholder." };
ErrorId MsgConfig::NetKeepaliveCount = { ErrorOf( ES_CONFIG, 170, E_INFO, EV_NONE, 0), "MsgConfig::NetKeepaliveCount placeholder." };
ErrorId MsgConfig::NetHeartbeatInterval = { ErrorOf( ES_CONFIG, 171, E_INFO, EV_NONE, 0), "MsgConfig::NetHeartbeatInterval placeholder." };
ErrorId MsgConfig::NetHeartbeatWait = { ErrorOf( ES_CONFIG, 172, E_INFO, EV_NONE, 0), "MsgConfig::NetHeartbeatWait placeholder." };
ErrorId MsgConfig::NetHeartbeatMissingInterval = { ErrorOf( ES_CONFIG, 173, E_INFO, EV_NONE, 0), "MsgConfig::NetHeartbeatMissingInterval placeholder." };
ErrorId MsgConfig::NetHeartbeatMissingWait = { ErrorOf( ES_CONFIG, 174, E_INFO, EV_NONE, 0), "MsgConfig::NetHeartbeatMissingWait placeholder." };
ErrorId MsgConfig::NetHeartbeatMissingCount = { ErrorOf( ES_CONFIG, 175, E_INFO, EV_NONE, 0), "MsgConfig::NetHeartbeatMissingCount placeholder." };
ErrorId MsgConfig::NetMaxFaultPub = { ErrorOf( ES_CONFIG, 176, E_INFO, EV_NONE, 0), "MsgConfig::NetMaxFaultPub placeholder." };
ErrorId MsgConfig::NetMaxclosewait = { ErrorOf( ES_CONFIG, 177, E_INFO, EV_NONE, 0), "MsgConfig::NetMaxclosewait placeholder." };
ErrorId MsgConfig::NetMaxwait = { ErrorOf( ES_CONFIG, 178, E_INFO, EV_NONE, 0), "MsgConfig::NetMaxwait placeholder." };
ErrorId MsgConfig::NetNagle = { ErrorOf( ES_CONFIG, 509, E_INFO, EV_NONE, 0), "MsgConfig::NetNagle placeholder." };
ErrorId MsgConfig::NetParallelMax = { ErrorOf( ES_CONFIG, 179, E_INFO, EV_NONE, 0), "MsgConfig::NetParallelMax placeholder." };
ErrorId MsgConfig::NetParallelThreads = { ErrorOf( ES_CONFIG, 180, E_INFO, EV_NONE, 0), "MsgConfig::NetParallelThreads placeholder." };
ErrorId MsgConfig::NetParallelBatch = { ErrorOf( ES_CONFIG, 181, E_INFO, EV_NONE, 0), "MsgConfig::NetParallelBatch placeholder." };
ErrorId MsgConfig::NetParallelBatchsize = { ErrorOf( ES_CONFIG, 182, E_INFO, EV_NONE, 0), "MsgConfig::NetParallelBatchsize placeholder." };
ErrorId MsgConfig::NetParallelMin = { ErrorOf( ES_CONFIG, 183, E_INFO, EV_NONE, 0), "MsgConfig::NetParallelMin placeholder." };
ErrorId MsgConfig::NetParallelMinsize = { ErrorOf( ES_CONFIG, 184, E_INFO, EV_NONE, 0), "MsgConfig::NetParallelMinsize placeholder." };
ErrorId MsgConfig::NetParallelShelveThreads = { ErrorOf( ES_CONFIG, 185, E_INFO, EV_NONE, 0), "MsgConfig::NetParallelShelveThreads placeholder." };
ErrorId MsgConfig::NetParallelShelveBatch = { ErrorOf( ES_CONFIG, 186, E_INFO, EV_NONE, 0), "MsgConfig::NetParallelShelveBatch placeholder." };
ErrorId MsgConfig::NetParallelShelveMin = { ErrorOf( ES_CONFIG, 187, E_INFO, EV_NONE, 0), "MsgConfig::NetParallelShelveMin placeholder." };
ErrorId MsgConfig::NetParallelSubmitThreads = { ErrorOf( ES_CONFIG, 188, E_INFO, EV_NONE, 0), "MsgConfig::NetParallelSubmitThreads placeholder." };
ErrorId MsgConfig::NetParallelSubmitBatch = { ErrorOf( ES_CONFIG, 189, E_INFO, EV_NONE, 0), "MsgConfig::NetParallelSubmitBatch placeholder." };
ErrorId MsgConfig::NetParallelSubmitMin = { ErrorOf( ES_CONFIG, 190, E_INFO, EV_NONE, 0), "MsgConfig::NetParallelSubmitMin placeholder." };
ErrorId MsgConfig::NetParallelSyncSvrthreads = { ErrorOf( ES_CONFIG, 191, E_INFO, EV_NONE, 0), "MsgConfig::NetParallelSyncSvrthreads placeholder." };
ErrorId MsgConfig::NetQuickAck = { ErrorOf( ES_CONFIG, 510, E_INFO, EV_NONE, 0), "MsgConfig::NetQuickAck placeholder." };
ErrorId MsgConfig::NetRcvbuflowmark = { ErrorOf( ES_CONFIG, 192, E_INFO, EV_NONE, 0), "MsgConfig::NetRcvbuflowmark placeholder." };
ErrorId MsgConfig::NetRcvbufmaxsize = { ErrorOf( ES_CONFIG, 193, E_INFO, EV_NONE, 0), "MsgConfig::NetRcvbufmaxsize placeholder." };
ErrorId MsgConfig::NetRcvbufsize = { ErrorOf( ES_CONFIG, 194, E_INFO, EV_NONE, 0), "MsgConfig::NetRcvbufsize placeholder." };
ErrorId MsgConfig::NetReuseport = { ErrorOf( ES_CONFIG, 195, E_INFO, EV_NONE, 0), "MsgConfig::NetReuseport placeholder." };
ErrorId MsgConfig::NetRfc3484 = { ErrorOf( ES_CONFIG, 196, E_INFO, EV_NONE, 0), "MsgConfig::NetRfc3484 placeholder." };
ErrorId MsgConfig::NetSendlimit = { ErrorOf( ES_CONFIG, 197, E_INFO, EV_NONE, 0), "MsgConfig::NetSendlimit placeholder." };
ErrorId MsgConfig::NetTcpsize = { ErrorOf( ES_CONFIG, 198, E_INFO, EV_NONE, 0), "MsgConfig::NetTcpsize placeholder." };
ErrorId MsgConfig::NetBacklog = { ErrorOf( ES_CONFIG, 199, E_INFO, EV_NONE, 0), "MsgConfig::NetBacklog placeholder." };
ErrorId MsgConfig::NetX3Minsize = { ErrorOf( ES_CONFIG, 200, E_INFO, EV_NONE, 0), "MsgConfig::NetX3Minsize placeholder." };
ErrorId MsgConfig::ProxyDeliverFix = { ErrorOf( ES_CONFIG, 201, E_INFO, EV_NONE, 0), "MsgConfig::ProxyDeliverFix placeholder." };
ErrorId MsgConfig::ProxyMonitorInterval = { ErrorOf( ES_CONFIG, 202, E_INFO, EV_NONE, 0), "MsgConfig::ProxyMonitorInterval placeholder." };
ErrorId MsgConfig::ProxyMonitorLevel = { ErrorOf( ES_CONFIG, 203, E_INFO, EV_NONE, 0), "MsgConfig::ProxyMonitorLevel placeholder." };
ErrorId MsgConfig::ProxyClearcachethresh = { ErrorOf( ES_CONFIG, 204, E_INFO, EV_NONE, 0), "MsgConfig::ProxyClearcachethresh placeholder." };
ErrorId MsgConfig::ProxySuppresswarnings = { ErrorOf( ES_CONFIG, 491, E_INFO, EV_NONE, 0), "MsgConfig::ProxySuppresswarnings placeholder." };
ErrorId MsgConfig::RcsMaxinsert = { ErrorOf( ES_CONFIG, 205, E_INFO, EV_NONE, 0), "MsgConfig::RcsMaxinsert placeholder." };
ErrorId MsgConfig::RcsNofsync = { ErrorOf( ES_CONFIG, 206, E_INFO, EV_NONE, 0), "MsgConfig::RcsNofsync placeholder." };
ErrorId MsgConfig::RmtAllowRemoteUser = { ErrorOf( ES_CONFIG, 511, E_INFO, EV_NONE, 0 ), "MsgConfig::RmtAllowRemoteUser placeholder." };
ErrorId MsgConfig::RpcDelay = { ErrorOf( ES_CONFIG, 207, E_INFO, EV_NONE, 0), "MsgConfig::RpcDelay placeholder." };
ErrorId MsgConfig::RpcDurablewait = { ErrorOf( ES_CONFIG, 208, E_INFO, EV_NONE, 0), "MsgConfig::RpcDurablewait placeholder." };
ErrorId MsgConfig::RpcHimark = { ErrorOf( ES_CONFIG, 209, E_INFO, EV_NONE, 0), "MsgConfig::RpcHimark placeholder." };
ErrorId MsgConfig::RpcLowmark = { ErrorOf( ES_CONFIG, 210, E_INFO, EV_NONE, 0), "MsgConfig::RpcLowmark placeholder." };
ErrorId MsgConfig::RpcIpaddrMismatch = { ErrorOf( ES_CONFIG, 211, E_INFO, EV_NONE, 0), "MsgConfig::RpcIpaddrMismatch placeholder." };
ErrorId MsgConfig::RplArchiveGraph = { ErrorOf( ES_CONFIG, 212, E_INFO, EV_NONE, 0), "MsgConfig::RplArchiveGraph placeholder." };
ErrorId MsgConfig::RplAwaitjnlCount = { ErrorOf( ES_CONFIG, 213, E_INFO, EV_NONE, 0), "MsgConfig::RplAwaitjnlCount placeholder." };
ErrorId MsgConfig::RplAwaitjnlInterval = { ErrorOf( ES_CONFIG, 214, E_INFO, EV_NONE, 0), "MsgConfig::RplAwaitjnlInterval placeholder." };
ErrorId MsgConfig::RplBufferRelease = { ErrorOf( ES_CONFIG, 215, E_INFO, EV_NONE, 0), "MsgConfig::RplBufferRelease placeholder." };
ErrorId MsgConfig::RplChecksumAuto = { ErrorOf( ES_CONFIG, 216, E_INFO, EV_NONE, 0), "MsgConfig::RplChecksumAuto placeholder." };
ErrorId MsgConfig::RplChecksumChange = { ErrorOf( ES_CONFIG, 217, E_INFO, EV_NONE, 0), "MsgConfig::RplChecksumChange placeholder." };
ErrorId MsgConfig::RplChecksumTable = { ErrorOf( ES_CONFIG, 218, E_INFO, EV_NONE, 0), "MsgConfig::RplChecksumTable placeholder." };
ErrorId MsgConfig::RplCompress = { ErrorOf( ES_CONFIG, 219, E_INFO, EV_NONE, 0), "MsgConfig::RplCompress placeholder." };
ErrorId MsgConfig::RplCounterHook = { ErrorOf( ES_CONFIG, 220, E_INFO, EV_NONE, 0), "MsgConfig::RplCounterHook placeholder." };
ErrorId MsgConfig::RplDeferredSends = { ErrorOf( ES_CONFIG, 221, E_INFO, EV_NONE, 0), "MsgConfig::RplDeferredSends placeholder." };
ErrorId MsgConfig::RplJnlBatchSize = { ErrorOf( ES_CONFIG, 222, E_INFO, EV_NONE, 0), "MsgConfig::RplJnlBatchSize placeholder." };
ErrorId MsgConfig::RplJnlwaitAdjust = { ErrorOf( ES_CONFIG, 223, E_INFO, EV_NONE, 0), "MsgConfig::RplJnlwaitAdjust placeholder." };
ErrorId MsgConfig::RplJnlwaitInterval = { ErrorOf( ES_CONFIG, 224, E_INFO, EV_NONE, 0), "MsgConfig::RplJnlwaitInterval placeholder." };
ErrorId MsgConfig::RplJnlwaitMax = { ErrorOf( ES_CONFIG, 225, E_INFO, EV_NONE, 0), "MsgConfig::RplJnlwaitMax placeholder." };
ErrorId MsgConfig::RplJournalAck = { ErrorOf( ES_CONFIG, 226, E_INFO, EV_NONE, 0), "MsgConfig::RplJournalAck placeholder." };
ErrorId MsgConfig::RplJournalAckMin = { ErrorOf( ES_CONFIG, 227, E_INFO, EV_NONE, 0), "MsgConfig::RplJournalAckMin placeholder." };
ErrorId MsgConfig::RplJournalcopyLocation = { ErrorOf( ES_CONFIG, 228, E_INFO, EV_NONE, 0), "MsgConfig::RplJournalcopyLocation placeholder." };
ErrorId MsgConfig::RplLabelsGlobal = { ErrorOf( ES_CONFIG, 229, E_INFO, EV_NONE, 0), "MsgConfig::RplLabelsGlobal placeholder." };
ErrorId MsgConfig::RplReplayUserrp = { ErrorOf( ES_CONFIG, 230, E_INFO, EV_NONE, 0), "MsgConfig::RplReplayUserrp placeholder." };
ErrorId MsgConfig::RplTrackBehind = { ErrorOf( ES_CONFIG, 231, E_INFO, EV_NONE, 0), "MsgConfig::RplTrackBehind placeholder." };
ErrorId MsgConfig::RplTrackBehindInterval = { ErrorOf( ES_CONFIG, 232, E_INFO, EV_NONE, 0), "MsgConfig::RplTrackBehindInterval placeholder." };
ErrorId MsgConfig::RplVerifyCache = { ErrorOf( ES_CONFIG, 233, E_INFO, EV_NONE, 0), "MsgConfig::RplVerifyCache placeholder." };
ErrorId MsgConfig::RplVerifyShared = { ErrorOf( ES_CONFIG, 234, E_INFO, EV_NONE, 0), "MsgConfig::RplVerifyShared placeholder." };
ErrorId MsgConfig::RplPullArchivedepots = { ErrorOf( ES_CONFIG, 235, E_INFO, EV_NONE, 0), "MsgConfig::RplPullArchivedepots placeholder." };
ErrorId MsgConfig::RunClientextsAllow = { ErrorOf( ES_CONFIG, 236, E_INFO, EV_NONE, 0), "MsgConfig::RunClientextsAllow placeholder." };
ErrorId MsgConfig::RunMoveAllow = { ErrorOf( ES_CONFIG, 237, E_INFO, EV_NONE, 0), "MsgConfig::RunMoveAllow placeholder." };
ErrorId MsgConfig::RunObliterateAllow = { ErrorOf( ES_CONFIG, 238, E_INFO, EV_NONE, 0), "MsgConfig::RunObliterateAllow placeholder." };
ErrorId MsgConfig::RunPruneAllow = { ErrorOf( ES_CONFIG, 239, E_INFO, EV_NONE, 0), "MsgConfig::RunPruneAllow placeholder." };
ErrorId MsgConfig::RunRenameclientAllow = { ErrorOf( ES_CONFIG, 240, E_INFO, EV_NONE, 0), "MsgConfig::RunRenameclientAllow placeholder." };
ErrorId MsgConfig::RunUnzipUserAllow = { ErrorOf( ES_CONFIG, 241, E_INFO, EV_NONE, 0), "MsgConfig::RunUnzipUserAllow placeholder." };
ErrorId MsgConfig::RunUsersAuthorize = { ErrorOf( ES_CONFIG, 242, E_INFO, EV_NONE, 0), "MsgConfig::RunUsersAuthorize placeholder." };
ErrorId MsgConfig::ServerCommandlimits = { ErrorOf( ES_CONFIG, 243, E_INFO, EV_NONE, 0), "MsgConfig::ServerCommandlimits placeholder." };
ErrorId MsgConfig::ServerCtrlcFilecleanup = { ErrorOf( ES_CONFIG, 244, E_INFO, EV_NONE, 0), "MsgConfig::ServerCtrlcFilecleanup placeholder." };
ErrorId MsgConfig::ServerExtsAllowAdmin = { ErrorOf( ES_CONFIG, 245, E_INFO, EV_NONE, 0), "MsgConfig::ServerExtsAllowAdmin placeholder." };
ErrorId MsgConfig::ServerExtsAllowUnsigned = { ErrorOf( ES_CONFIG, 246, E_INFO, EV_NONE, 0), "MsgConfig::ServerExtsAllowUnsigned placeholder." };
ErrorId MsgConfig::ServerFilecharset = { ErrorOf( ES_CONFIG, 247, E_INFO, EV_NONE, 0), "MsgConfig::ServerFilecharset placeholder." };
ErrorId MsgConfig::ServerLocksArchive = { ErrorOf( ES_CONFIG, 248, E_INFO, EV_NONE, 0), "MsgConfig::ServerLocksArchive placeholder." };
ErrorId MsgConfig::ServerLocksSync = { ErrorOf( ES_CONFIG, 249, E_INFO, EV_NONE, 0), "MsgConfig::ServerLocksSync placeholder." };
ErrorId MsgConfig::ServerLocksGlobal = { ErrorOf( ES_CONFIG, 250, E_INFO, EV_NONE, 0), "MsgConfig::ServerLocksGlobal placeholder." };
ErrorId MsgConfig::ServerAllowfetch = { ErrorOf( ES_CONFIG, 251, E_INFO, EV_NONE, 0), "MsgConfig::ServerAllowfetch placeholder." };
ErrorId MsgConfig::ServerAllowpush = { ErrorOf( ES_CONFIG, 252, E_INFO, EV_NONE, 0), "MsgConfig::ServerAllowpush placeholder." };
ErrorId MsgConfig::ServerAllowremotelocking = { ErrorOf( ES_CONFIG, 253, E_INFO, EV_NONE, 0), "MsgConfig::ServerAllowremotelocking placeholder." };
ErrorId MsgConfig::ServerAllowrewrite = { ErrorOf( ES_CONFIG, 254, E_INFO, EV_NONE, 0), "MsgConfig::ServerAllowrewrite placeholder." };
ErrorId MsgConfig::DmDvcsAllowcasemismatch = { ErrorOf( ES_CONFIG, 500, E_INFO, EV_NONE, 0), "MsgConfig::DmDvcsAllowcasemismatch placeholder." };
ErrorId MsgConfig::ServerGlobalClientViews = { ErrorOf( ES_CONFIG, 255, E_INFO, EV_NONE, 0), "MsgConfig::ServerGlobalClientViews placeholder." };
ErrorId MsgConfig::ServerOomAdjScore = { ErrorOf( ES_CONFIG, 256, E_INFO, EV_NONE, 0), "MsgConfig::ServerOomAdjScore placeholder." };
ErrorId MsgConfig::ServerMaxcommands = { ErrorOf( ES_CONFIG, 257, E_INFO, EV_NONE, 0), "MsgConfig::ServerMaxcommands placeholder." };
ErrorId MsgConfig::ServerMaxcommandsAllow = { ErrorOf( ES_CONFIG, 258, E_INFO, EV_NONE, 0), "MsgConfig::ServerMaxcommandsAllow placeholder." };
ErrorId MsgConfig::ServerStartUnlicensed = { ErrorOf( ES_CONFIG, 259, E_INFO, EV_NONE, 0), "MsgConfig::ServerStartUnlicensed placeholder." };
ErrorId MsgConfig::FiletypeBypasslock = { ErrorOf( ES_CONFIG, 260, E_INFO, EV_NONE, 0), "MsgConfig::FiletypeBypasslock placeholder." };
ErrorId MsgConfig::FiletypeMaxtextsize = { ErrorOf( ES_CONFIG, 261, E_INFO, EV_NONE, 0), "MsgConfig::FiletypeMaxtextsize placeholder." };
ErrorId MsgConfig::SpecHashbuckets = { ErrorOf( ES_CONFIG, 262, E_INFO, EV_NONE, 0), "MsgConfig::SpecHashbuckets placeholder." };
ErrorId MsgConfig::SpecCustom = { ErrorOf( ES_CONFIG, 263, E_INFO, EV_NONE, 0), "MsgConfig::SpecCustom placeholder." };
ErrorId MsgConfig::StreamviewDotsLow = { ErrorOf( ES_CONFIG, 264, E_INFO, EV_NONE, 0), "MsgConfig::StreamviewDotsLow placeholder." };
ErrorId MsgConfig::StreamviewSortRemap = { ErrorOf( ES_CONFIG, 265, E_INFO, EV_NONE, 0), "MsgConfig::StreamviewSortRemap placeholder." };
ErrorId MsgConfig::SubmitCollisioncheck = { ErrorOf( ES_CONFIG, 266, E_INFO, EV_NONE, 0), "MsgConfig::SubmitCollisioncheck placeholder." };
ErrorId MsgConfig::SubmitForcenoretransfer = { ErrorOf( ES_CONFIG, 267, E_INFO, EV_NONE, 0), "MsgConfig::SubmitForcenoretransfer placeholder." };
ErrorId MsgConfig::SubmitNoretransfer = { ErrorOf( ES_CONFIG, 268, E_INFO, EV_NONE, 0), "MsgConfig::SubmitNoretransfer placeholder." };
ErrorId MsgConfig::SubmitAllowbgtransfer = { ErrorOf( ES_CONFIG, 269, E_INFO, EV_NONE, 0), "MsgConfig::SubmitAllowbgtransfer placeholder." };
ErrorId MsgConfig::SubmitAutobgtransfer = { ErrorOf( ES_CONFIG, 270, E_INFO, EV_NONE, 0), "MsgConfig::SubmitAutobgtransfer placeholder." };
ErrorId MsgConfig::SubmitUnlockLocked = { ErrorOf( ES_CONFIG, 271, E_INFO, EV_NONE, 0), "MsgConfig::SubmitUnlockLocked placeholder." };
ErrorId MsgConfig::SubmitStoragefields = { ErrorOf( ES_CONFIG, 272, E_INFO, EV_NONE, 0), "MsgConfig::SubmitStoragefields placeholder." };
ErrorId MsgConfig::TraitStoredepot = { ErrorOf( ES_CONFIG, 273, E_INFO, EV_NONE, 0), "MsgConfig::TraitStoredepot placeholder." };
ErrorId MsgConfig::SwitchStreamUnrelated = { ErrorOf( ES_CONFIG, 274, E_INFO, EV_NONE, 0), "MsgConfig::SwitchStreamUnrelated placeholder." };
ErrorId MsgConfig::PushUnlockLocked = { ErrorOf( ES_CONFIG, 275, E_INFO, EV_NONE, 0), "MsgConfig::PushUnlockLocked placeholder." };
ErrorId MsgConfig::SysMemoryPoolfree = { ErrorOf( ES_CONFIG, 276, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryPoolfree placeholder." };
ErrorId MsgConfig::SysMemoryProcfree = { ErrorOf( ES_CONFIG, 277, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryProcfree placeholder." };
ErrorId MsgConfig::SysMemoryPoolgrowinc = { ErrorOf( ES_CONFIG, 278, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryPoolgrowinc placeholder." };
ErrorId MsgConfig::SysMemoryProcgrowinc = { ErrorOf( ES_CONFIG, 279, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryProcgrowinc placeholder." };
ErrorId MsgConfig::SysMemorySubpools = { ErrorOf( ES_CONFIG, 280, E_INFO, EV_NONE, 0), "MsgConfig::SysMemorySubpools placeholder." };
ErrorId MsgConfig::SysMemoryLimit = { ErrorOf( ES_CONFIG, 281, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryLimit placeholder." };
ErrorId MsgConfig::SysMemoryDebug = { ErrorOf( ES_CONFIG, 282, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryDebug placeholder." };
ErrorId MsgConfig::CmdMemoryPoolfree = { ErrorOf( ES_CONFIG, 283, E_INFO, EV_NONE, 0), "MsgConfig::CmdMemoryPoolfree placeholder." };
ErrorId MsgConfig::CmdMemoryProcfree = { ErrorOf( ES_CONFIG, 284, E_INFO, EV_NONE, 0), "MsgConfig::CmdMemoryProcfree placeholder." };
ErrorId MsgConfig::CmdMemoryLimit = { ErrorOf( ES_CONFIG, 285, E_INFO, EV_NONE, 0), "MsgConfig::CmdMemoryLimit placeholder." };
ErrorId MsgConfig::CmdMemoryFlushpool = { ErrorOf( ES_CONFIG, 286, E_INFO, EV_NONE, 0), "MsgConfig::CmdMemoryFlushpool placeholder." };
ErrorId MsgConfig::CmdMemoryListpools = { ErrorOf( ES_CONFIG, 287, E_INFO, EV_NONE, 0), "MsgConfig::CmdMemoryListpools placeholder." };
ErrorId MsgConfig::CmdMemoryChkpt = { ErrorOf( ES_CONFIG, 288, E_INFO, EV_NONE, 0), "MsgConfig::CmdMemoryChkpt placeholder." };
ErrorId MsgConfig::SysMemoryMiShowerrors = { ErrorOf( ES_CONFIG, 289, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryMiShowerrors placeholder." };
ErrorId MsgConfig::SysMemoryMiShowstats = { ErrorOf( ES_CONFIG, 290, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryMiShowstats placeholder." };
ErrorId MsgConfig::SysMemoryMiVerbose = { ErrorOf( ES_CONFIG, 291, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryMiVerbose placeholder." };
ErrorId MsgConfig::SysMemoryMiEagercommit = { ErrorOf( ES_CONFIG, 292, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryMiEagercommit placeholder." };
ErrorId MsgConfig::SysMemoryMiArenaeagercommit = { ErrorOf( ES_CONFIG, 293, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryMiArenaeagercommit placeholder." };
ErrorId MsgConfig::SysMemoryMiPurgedecommits = { ErrorOf( ES_CONFIG, 294, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryMiPurgedecommits placeholder." };
ErrorId MsgConfig::SysMemoryMiAllowlargeospages = { ErrorOf( ES_CONFIG, 295, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryMiAllowlargeospages placeholder." };
ErrorId MsgConfig::SysMemoryMiReservehugeospages = { ErrorOf( ES_CONFIG, 296, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryMiReservehugeospages placeholder." };
ErrorId MsgConfig::SysMemoryMiReservehugeospagesat = { ErrorOf( ES_CONFIG, 297, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryMiReservehugeospagesat placeholder." };
ErrorId MsgConfig::SysMemoryMiReserveosmemory = { ErrorOf( ES_CONFIG, 298, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryMiReserveosmemory placeholder." };
ErrorId MsgConfig::SysMemoryMiSegmentcache = { ErrorOf( ES_CONFIG, 299, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryMiSegmentcache placeholder." };
ErrorId MsgConfig::SysMemoryMiDeprecatedpagereset = { ErrorOf( ES_CONFIG, 300, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryMiDeprecatedpagereset placeholder." };
ErrorId MsgConfig::SysMemoryMiAbandonedpagepurge = { ErrorOf( ES_CONFIG, 301, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryMiAbandonedpagepurge placeholder." };
ErrorId MsgConfig::SysMemoryMiDeprecatedsegmentreset = { ErrorOf( ES_CONFIG, 302, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryMiDeprecatedsegmentreset placeholder." };
ErrorId MsgConfig::SysMemoryMiEagercommitdelay = { ErrorOf( ES_CONFIG, 303, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryMiEagercommitdelay placeholder." };
ErrorId MsgConfig::SysMemoryMiPurgeDelay = { ErrorOf( ES_CONFIG, 304, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryMiPurgeDelay placeholder." };
ErrorId MsgConfig::SysMemoryMiUsenumanodes = { ErrorOf( ES_CONFIG, 305, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryMiUsenumanodes placeholder." };
ErrorId MsgConfig::SysMemoryMiLimitosalloc = { ErrorOf( ES_CONFIG, 306, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryMiLimitosalloc placeholder." };
ErrorId MsgConfig::SysMemoryMiOstag = { ErrorOf( ES_CONFIG, 307, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryMiOstag placeholder." };
ErrorId MsgConfig::SysMemoryMiMaxerrors = { ErrorOf( ES_CONFIG, 308, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryMiMaxerrors placeholder." };
ErrorId MsgConfig::SysMemoryMiMaxwarnings = { ErrorOf( ES_CONFIG, 309, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryMiMaxwarnings placeholder." };
ErrorId MsgConfig::SysMemoryMiMaxsegmentreclaim = { ErrorOf( ES_CONFIG, 310, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryMiMaxsegmentreclaim placeholder." };
ErrorId MsgConfig::SysMemoryMiAllowdecommit = { ErrorOf( ES_CONFIG, 311, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryMiAllowdecommit placeholder." };
ErrorId MsgConfig::SysMemoryMiSegmentdecommitdelay = { ErrorOf( ES_CONFIG, 312, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryMiSegmentdecommitdelay placeholder." };
ErrorId MsgConfig::SysMemoryMiDestroyonexit = { ErrorOf( ES_CONFIG, 484, E_INFO, EV_NONE, 0 ), "MsgConfig::SysMemoryMiDestroyonexit placeholder." };
ErrorId MsgConfig::SysMemoryMiArenareserve = { ErrorOf( ES_CONFIG, 502, E_INFO, EV_NONE, 0 ), "MsgConfig::SysMemoryMiArenareserve placeholder." };
ErrorId MsgConfig::SysMemoryMiArenapurgemult = { ErrorOf( ES_CONFIG, 503, E_INFO, EV_NONE, 0 ), "MsgConfig::SysMemoryMiArenapurgemult placeholder." };
ErrorId MsgConfig::SysMemoryMiPurgeextenddelay = { ErrorOf( ES_CONFIG, 313, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryMiPurgeextenddelay placeholder." };
ErrorId MsgConfig::SysMemoryStacksize = { ErrorOf( ES_CONFIG, 314, E_INFO, EV_NONE, 0), "MsgConfig::SysMemoryStacksize placeholder." };
ErrorId MsgConfig::SysPressureMaxPauseTime = { ErrorOf( ES_CONFIG, 315, E_INFO, EV_NONE, 0), "MsgConfig::SysPressureMaxPauseTime placeholder." };
ErrorId MsgConfig::SysPressureMaxPaused = { ErrorOf( ES_CONFIG, 316, E_INFO, EV_NONE, 0), "MsgConfig::SysPressureMaxPaused placeholder." };
ErrorId MsgConfig::SysPressureMemHigh = { ErrorOf( ES_CONFIG, 317, E_INFO, EV_NONE, 0), "MsgConfig::SysPressureMemHigh placeholder." };
ErrorId MsgConfig::SysPressureMemHighDuration = { ErrorOf( ES_CONFIG, 318, E_INFO, EV_NONE, 0), "MsgConfig::SysPressureMemHighDuration placeholder." };
ErrorId MsgConfig::SysPressureMemMedium = { ErrorOf( ES_CONFIG, 319, E_INFO, EV_NONE, 0), "MsgConfig::SysPressureMemMedium placeholder." };
ErrorId MsgConfig::SysPressureMemMediumDuration = { ErrorOf( ES_CONFIG, 320, E_INFO, EV_NONE, 0), "MsgConfig::SysPressureMemMediumDuration placeholder." };
ErrorId MsgConfig::SysPressureOsCpuHigh = { ErrorOf( ES_CONFIG, 321, E_INFO, EV_NONE, 0), "MsgConfig::SysPressureOsCpuHigh placeholder." };
ErrorId MsgConfig::SysPressureOsCpuHighDuration = { ErrorOf( ES_CONFIG, 322, E_INFO, EV_NONE, 0), "MsgConfig::SysPressureOsCpuHighDuration placeholder." };
ErrorId MsgConfig::SysPressureOsMemHigh = { ErrorOf( ES_CONFIG, 323, E_INFO, EV_NONE, 0), "MsgConfig::SysPressureOsMemHigh placeholder." };
ErrorId MsgConfig::SysPressureOsMemHighDuration = { ErrorOf( ES_CONFIG, 324, E_INFO, EV_NONE, 0), "MsgConfig::SysPressureOsMemHighDuration placeholder." };
ErrorId MsgConfig::SysPressureOsMemMedium = { ErrorOf( ES_CONFIG, 325, E_INFO, EV_NONE, 0), "MsgConfig::SysPressureOsMemMedium placeholder." };
ErrorId MsgConfig::SysPressureOsMemMediumDuration = { ErrorOf( ES_CONFIG, 326, E_INFO, EV_NONE, 0), "MsgConfig::SysPressureOsMemMediumDuration placeholder." };
ErrorId MsgConfig::SysRenameMax = { ErrorOf( ES_CONFIG, 327, E_INFO, EV_NONE, 0), "MsgConfig::SysRenameMax placeholder." };
ErrorId MsgConfig::SysRenameWait = { ErrorOf( ES_CONFIG, 328, E_INFO, EV_NONE, 0), "MsgConfig::SysRenameWait placeholder." };
ErrorId MsgConfig::SysThreadingGroups = { ErrorOf( ES_CONFIG, 329, E_INFO, EV_NONE, 0), "MsgConfig::SysThreadingGroups placeholder." };
ErrorId MsgConfig::SysTypesAllow64 = { ErrorOf( ES_CONFIG, 330, E_INFO, EV_NONE, 0), "MsgConfig::SysTypesAllow64 placeholder." };
ErrorId MsgConfig::RplForwardAll = { ErrorOf( ES_CONFIG, 331, E_INFO, EV_NONE, 0), "MsgConfig::RplForwardAll placeholder." };
ErrorId MsgConfig::RplForwardLogin = { ErrorOf( ES_CONFIG, 332, E_INFO, EV_NONE, 0), "MsgConfig::RplForwardLogin placeholder." };
ErrorId MsgConfig::RplPullPosition = { ErrorOf( ES_CONFIG, 333, E_INFO, EV_NONE, 0), "MsgConfig::RplPullPosition placeholder." };
ErrorId MsgConfig::RplPullReload = { ErrorOf( ES_CONFIG, 334, E_INFO, EV_NONE, 0), "MsgConfig::RplPullReload placeholder." };
ErrorId MsgConfig::SslSecondarySuite = { ErrorOf( ES_CONFIG, 335, E_INFO, EV_NONE, 0), "MsgConfig::SslSecondarySuite placeholder." };
ErrorId MsgConfig::SslClientTimeout = { ErrorOf( ES_CONFIG, 336, E_INFO, EV_NONE, 0), "MsgConfig::SslClientTimeout placeholder." };
ErrorId MsgConfig::SslClientTlsVersionMin = { ErrorOf( ES_CONFIG, 337, E_INFO, EV_NONE, 0), "MsgConfig::SslClientTlsVersionMin placeholder." };
ErrorId MsgConfig::SslClientTlsVersionMax = { ErrorOf( ES_CONFIG, 338, E_INFO, EV_NONE, 0), "MsgConfig::SslClientTlsVersionMax placeholder." };
ErrorId MsgConfig::SslClientTrustName = { ErrorOf( ES_CONFIG, 339, E_INFO, EV_NONE, 0), "MsgConfig::SslClientTrustName placeholder." };
ErrorId MsgConfig::SslClientCertValidate = { ErrorOf( ES_CONFIG, 340, E_INFO, EV_NONE, 0), "MsgConfig::SslClientCertValidate placeholder." };
ErrorId MsgConfig::SslTlsVersionMin = { ErrorOf( ES_CONFIG, 341, E_INFO, EV_NONE, 0), "MsgConfig::SslTlsVersionMin placeholder." };
ErrorId MsgConfig::SslTlsVersionMax = { ErrorOf( ES_CONFIG, 342, E_INFO, EV_NONE, 0), "MsgConfig::SslTlsVersionMax placeholder." };
ErrorId MsgConfig::SslEnableEtm = { ErrorOf( ES_CONFIG, 343, E_INFO, EV_NONE, 0), "MsgConfig::SslEnableEtm placeholder." };
ErrorId MsgConfig::SslHandshakeBlocking = { ErrorOf( ES_CONFIG, 344, E_INFO, EV_NONE, 0), "MsgConfig::SslHandshakeBlocking placeholder." };
ErrorId MsgConfig::TriggersIo = { ErrorOf( ES_CONFIG, 345, E_INFO, EV_NONE, 0), "MsgConfig::TriggersIo placeholder." };
ErrorId MsgConfig::IstatMimicIchanges = { ErrorOf( ES_CONFIG, 346, E_INFO, EV_NONE, 0), "MsgConfig::IstatMimicIchanges placeholder." };
ErrorId MsgConfig::InfoP4AuthUsercheck = { ErrorOf( ES_CONFIG, 347, E_INFO, EV_NONE, 0), "MsgConfig::InfoP4AuthUsercheck placeholder." };
ErrorId MsgConfig::AuthAutologinprompt = { ErrorOf( ES_CONFIG, 348, E_INFO, EV_NONE, 0), "MsgConfig::AuthAutologinPrompt placeholder." };
ErrorId MsgConfig::RplSubmitNocopy = { ErrorOf( ES_CONFIG, 349, E_INFO, EV_NONE, 0), "MsgConfig::RplSubmitNocopy placeholder." };
ErrorId MsgConfig::Auth2FaPersist = { ErrorOf( ES_CONFIG, 350, E_INFO, EV_NONE, 0), "MsgConfig::Auth2FaPersist placeholder." };
ErrorId MsgConfig::AuthTicketsNounlocked = { ErrorOf( ES_CONFIG, 351, E_INFO, EV_NONE, 0), "MsgConfig::AuthTicketsNounlocked placeholder." };
ErrorId MsgConfig::AuthLicenseexpiryWarn = { ErrorOf( ES_CONFIG, 352, E_INFO, EV_NONE, 0), "MsgConfig::AuthLicenseexpiryWarn placeholder." };
ErrorId MsgConfig::AuthLicenseexpiryWarnthreshold = { ErrorOf( ES_CONFIG, 353, E_INFO, EV_NONE, 0), "MsgConfig::AuthLicenseexpiryWarnthreshold placeholder." };
ErrorId MsgConfig::AuthSsoAllowPasswd = { ErrorOf( ES_CONFIG, 354, E_INFO, EV_NONE, 0), "MsgConfig::AuthSsoAllowPasswd placeholder." };
ErrorId MsgConfig::AuthSsoNonldap = { ErrorOf( ES_CONFIG, 355, E_INFO, EV_NONE, 0), "MsgConfig::AuthSsoNonldap placeholder." };
ErrorId MsgConfig::ZlibCompressionLevel = { ErrorOf( ES_CONFIG, 356, E_INFO, EV_NONE, 0), "MsgConfig::ZlibCompressionLevel placeholder." };
ErrorId MsgConfig::ZlibDisableOptim = { ErrorOf( ES_CONFIG, 357, E_INFO, EV_NONE, 0), "MsgConfig::ZlibDisableOptim placeholder." };

// String tunables
ErrorId MsgConfig::SecurityDigest = { ErrorOf( ES_CONFIG, 493, E_INFO, EV_NONE, 0 ), "MsgConfig::SecurityDigest placeholder." };
ErrorId MsgConfig::SSLClientCAPath = { ErrorOf( ES_CONFIG, 358, E_INFO, EV_NONE, 0 ), "MsgConfig::SSLClientCAPath placeholder." };
ErrorId MsgConfig::SslClientCipherList = { ErrorOf( ES_CONFIG, 497, E_INFO, EV_NONE, 0 ), "MsgConfig::SslClientCipherList placeholder." };
ErrorId MsgConfig::SslClientCipherSuites = { ErrorOf( ES_CONFIG, 498, E_INFO, EV_NONE, 0 ), "MsgConfig::SslClientCipherSuites placeholder." };
ErrorId MsgConfig::SslCipherList = { ErrorOf( ES_CONFIG, 431, E_INFO, EV_NONE, 0 ), "MsgConfig::SslCipherList placeholder." };
ErrorId MsgConfig::SslCipherSuites = { ErrorOf( ES_CONFIG, 432, E_INFO, EV_NONE, 0 ), "MsgConfig::SslCipherSuites placeholder." };
ErrorId MsgConfig::SSLKeylogFile = { ErrorOf( ES_CONFIG, 479, E_INFO, EV_NONE, 0 ), "MsgConfig::SSLKeylogFile placeholder." };

// Configurables
ErrorId MsgConfig::P4ROOT = { ErrorOf( ES_CONFIG, 359, E_INFO, EV_NONE, 0 ), "MsgConfig::P4ROOT placeholder." };
ErrorId MsgConfig::P4PORT = { ErrorOf( ES_CONFIG, 360, E_INFO, EV_NONE, 0 ), "MsgConfig::P4PORT placeholder." };
ErrorId MsgConfig::P4JOURNAL = { ErrorOf( ES_CONFIG, 361, E_INFO, EV_NONE, 0 ), "MsgConfig::P4JOURNAL placeholder." };
ErrorId MsgConfig::P4NAME = { ErrorOf( ES_CONFIG, 362, E_INFO, EV_NONE, 0 ), "MsgConfig::P4NAME placeholder." };
ErrorId MsgConfig::P4DEBUG = { ErrorOf( ES_CONFIG, 363, E_INFO, EV_NONE, 0 ), "MsgConfig::P4DEBUG placeholder." };
ErrorId MsgConfig::P4DESCRIPTION = { ErrorOf( ES_CONFIG, 364, E_INFO, EV_NONE, 0 ), "MsgConfig::P4DESCRIPTION placeholder." };
ErrorId MsgConfig::P4LOG = { ErrorOf( ES_CONFIG, 365, E_INFO, EV_NONE, 0 ), "MsgConfig::P4LOG placeholder." };
ErrorId MsgConfig::P4AUDIT = { ErrorOf( ES_CONFIG, 366, E_INFO, EV_NONE, 0 ), "MsgConfig::P4AUDIT placeholder." };
ErrorId MsgConfig::P4AUTH = { ErrorOf( ES_CONFIG, 367, E_INFO, EV_NONE, 0 ), "MsgConfig::P4AUTH placeholder." };
ErrorId MsgConfig::P4CHANGE = { ErrorOf( ES_CONFIG, 368, E_INFO, EV_NONE, 0 ), "MsgConfig::P4CHANGE placeholder." };
ErrorId MsgConfig::P4TICKETS = { ErrorOf( ES_CONFIG, 369, E_INFO, EV_NONE, 0 ), "MsgConfig::P4TICKETS placeholder." };
ErrorId MsgConfig::P4TRUST = { ErrorOf( ES_CONFIG, 370, E_INFO, EV_NONE, 0 ), "MsgConfig::P4TRUST placeholder." };
ErrorId MsgConfig::ServiceUser = { ErrorOf( ES_CONFIG, 371, E_INFO, EV_NONE, 0 ), "MsgConfig::ServiceUser placeholder." };
ErrorId MsgConfig::Threadingmode = { ErrorOf( ES_CONFIG, 372, E_INFO, EV_NONE, 0 ), "MsgConfig::Threadingmode placeholder." };
ErrorId MsgConfig::P4TARGET = { ErrorOf( ES_CONFIG, 373, E_INFO, EV_NONE, 0 ), "MsgConfig::P4TARGET placeholder." };
ErrorId MsgConfig::Security = { ErrorOf( ES_CONFIG, 374, E_INFO, EV_NONE, 0 ), "MsgConfig::Security placeholder." };
ErrorId MsgConfig::Unicode = { ErrorOf( ES_CONFIG, 375, E_INFO, EV_NONE, 0 ), "MsgConfig::Unicode placeholder." };
ErrorId MsgConfig::Monitor = { ErrorOf( ES_CONFIG, 376, E_INFO, EV_NONE, 0 ), "MsgConfig::Monitor placeholder." };
ErrorId MsgConfig::MinClient = { ErrorOf( ES_CONFIG, 377, E_INFO, EV_NONE, 0 ), "MsgConfig::MinClient placeholder." };
ErrorId MsgConfig::MinClientMessage = { ErrorOf( ES_CONFIG, 378, E_INFO, EV_NONE, 0 ), "MsgConfig::MinClientMessage placeholder." };
ErrorId MsgConfig::NetMimcheck = { ErrorOf( ES_CONFIG, 379, E_INFO, EV_NONE, 0 ), "MsgConfig::NetMimcheck placeholder." };
ErrorId MsgConfig::StartupN = { ErrorOf( ES_CONFIG, 380, E_INFO, EV_NONE, 0 ), "MsgConfig::StartupN placeholder." };
ErrorId MsgConfig::DbReplication = { ErrorOf( ES_CONFIG, 381, E_INFO, EV_NONE, 0 ), "MsgConfig::DbReplication placeholder." };
ErrorId MsgConfig::LbrReplication = { ErrorOf( ES_CONFIG, 382, E_INFO, EV_NONE, 0 ), "MsgConfig::LbrReplication placeholder." };
ErrorId MsgConfig::Statefile = { ErrorOf( ES_CONFIG, 383, E_INFO, EV_NONE, 0 ), "MsgConfig::Statefile placeholder." };
ErrorId MsgConfig::JournalPrefix = { ErrorOf( ES_CONFIG, 384, E_INFO, EV_NONE, 0 ), "MsgConfig::JournalPrefix placeholder." };
ErrorId MsgConfig::JournalPrefixBackup = { ErrorOf( ES_CONFIG, 385, E_INFO, EV_NONE, 0 ), "MsgConfig::JournalPrefixBackup placeholder." };
ErrorId MsgConfig::FilesysP4ROOTMin = { ErrorOf( ES_CONFIG, 386, E_INFO, EV_NONE, 0 ), "MsgConfig::FilesysP4ROOTMin placeholder." };
ErrorId MsgConfig::FilesysP4JOURNALMin = { ErrorOf( ES_CONFIG, 387, E_INFO, EV_NONE, 0 ), "MsgConfig::FilesysP4JOURNALMin placeholder." };
ErrorId MsgConfig::FilesysP4LOGMin = { ErrorOf( ES_CONFIG, 388, E_INFO, EV_NONE, 0 ), "MsgConfig::FilesysP4LOGMin placeholder." };
ErrorId MsgConfig::FilesysDepotMin = { ErrorOf( ES_CONFIG, 389, E_INFO, EV_NONE, 0 ), "MsgConfig::FilesysDepotMin placeholder." };
ErrorId MsgConfig::ServerDepotRoot = { ErrorOf( ES_CONFIG, 390, E_INFO, EV_NONE, 0 ), "MsgConfig::ServerDepotRoot placeholder." };
ErrorId MsgConfig::ServerExtensionsDir = { ErrorOf( ES_CONFIG, 391, E_INFO, EV_NONE, 0 ), "MsgConfig::ServerExtensionsDir placeholder." };
ErrorId MsgConfig::ServerLocksDir = { ErrorOf( ES_CONFIG, 392, E_INFO, EV_NONE, 0 ), "MsgConfig::ServerLocksDir placeholder." };
ErrorId MsgConfig::ServerlogCounterN = { ErrorOf( ES_CONFIG, 393, E_INFO, EV_NONE, 0 ), "MsgConfig::ServerlogCounterN placeholder." };
ErrorId MsgConfig::ServerlogFileN = { ErrorOf( ES_CONFIG, 394, E_INFO, EV_NONE, 0 ), "MsgConfig::ServerlogFileN placeholder." };
ErrorId MsgConfig::ServerlogEventsN = { ErrorOf( ES_CONFIG, 395, E_INFO, EV_NONE, 0 ), "MsgConfig::ServerlogEventsN placeholder." };
ErrorId MsgConfig::ServerlogFormatN = { ErrorOf( ES_CONFIG, 396, E_INFO, EV_NONE, 0 ), "MsgConfig::ServerlogFormatN placeholder." };
ErrorId MsgConfig::ServerlogMaxmbN = { ErrorOf( ES_CONFIG, 397, E_INFO, EV_NONE, 0 ), "MsgConfig::ServerlogMaxmbN placeholder." };
ErrorId MsgConfig::ServerlogNameN = { ErrorOf( ES_CONFIG, 398, E_INFO, EV_NONE, 0 ), "MsgConfig::ServerlogNameN placeholder." };
ErrorId MsgConfig::ServerlogRetainN = { ErrorOf( ES_CONFIG, 399, E_INFO, EV_NONE, 0 ), "MsgConfig::ServerlogRetainN placeholder." };
ErrorId MsgConfig::ServerlogVersionN = { ErrorOf( ES_CONFIG, 400, E_INFO, EV_NONE, 0 ), "MsgConfig::ServerlogVersionN placeholder." };
ErrorId MsgConfig::ServerlogBufszN = { ErrorOf( ES_CONFIG, 401, E_INFO, EV_NONE, 0 ), "MsgConfig::ServerlogBufszN placeholder." };
ErrorId MsgConfig::ServerRolechecks = { ErrorOf( ES_CONFIG, 402, E_INFO, EV_NONE, 0 ), "MsgConfig::ServerRolechecks placeholder." };
ErrorId MsgConfig::SubmitIdentity = { ErrorOf( ES_CONFIG, 403, E_INFO, EV_NONE, 0 ), "MsgConfig::SubmitIdentity placeholder." };
ErrorId MsgConfig::TemplateClient = { ErrorOf( ES_CONFIG, 404, E_INFO, EV_NONE, 0 ), "MsgConfig::TemplateClient placeholder." };
ErrorId MsgConfig::TemplateLabel = { ErrorOf( ES_CONFIG, 405, E_INFO, EV_NONE, 0 ), "MsgConfig::TemplateLabel placeholder." };
ErrorId MsgConfig::DefaultChangeType = { ErrorOf( ES_CONFIG, 406, E_INFO, EV_NONE, 0 ), "MsgConfig::DefaultChangeType placeholder." };
ErrorId MsgConfig::ZerosyncPrefix = { ErrorOf( ES_CONFIG, 407, E_INFO, EV_NONE, 0 ), "MsgConfig::ZerosyncPrefix placeholder." };
ErrorId MsgConfig::RejectList = { ErrorOf( ES_CONFIG, 408, E_INFO, EV_NONE, 0 ), "MsgConfig::RejectList placeholder." };
ErrorId MsgConfig::ClusterId = { ErrorOf( ES_CONFIG, 409, E_INFO, EV_NONE, 0 ), "MsgConfig::ClusterId placeholder." };
ErrorId MsgConfig::P4UtilsDir = { ErrorOf( ES_CONFIG, 410, E_INFO, EV_NONE, 0 ), "MsgConfig::P4UtilsDir placeholder." };
ErrorId MsgConfig::ZkHostPortPairs = { ErrorOf( ES_CONFIG, 411, E_INFO, EV_NONE, 0 ), "MsgConfig::ZkHostPortPairs placeholder." };
ErrorId MsgConfig::P4zkLogFile = { ErrorOf( ES_CONFIG, 412, E_INFO, EV_NONE, 0 ), "MsgConfig::P4zkLogFile placeholder." };
ErrorId MsgConfig::MonitorLsof = { ErrorOf( ES_CONFIG, 413, E_INFO, EV_NONE, 0 ), "MsgConfig::MonitorLsof placeholder." };
ErrorId MsgConfig::AuthDefaultMethod = { ErrorOf( ES_CONFIG, 414, E_INFO, EV_NONE, 0 ), "MsgConfig::AuthDefaultMethod placeholder." };
ErrorId MsgConfig::AuthId = { ErrorOf( ES_CONFIG, 415, E_INFO, EV_NONE, 0 ), "MsgConfig::AuthId placeholder." };
ErrorId MsgConfig::AuthLdapCafile = { ErrorOf( ES_CONFIG, 416, E_INFO, EV_NONE, 0 ), "MsgConfig::AuthLdapCafile placeholder." };
ErrorId MsgConfig::AuthLdapOrderN = { ErrorOf( ES_CONFIG, 417, E_INFO, EV_NONE, 0 ), "MsgConfig::AuthLdapOrderN placeholder." };
ErrorId MsgConfig::AuthLdapSslciphers = { ErrorOf( ES_CONFIG, 418, E_INFO, EV_NONE, 0 ), "MsgConfig::AuthLdapSslciphers placeholder." };
ErrorId MsgConfig::AuthLdapPagesize = { ErrorOf( ES_CONFIG, 419, E_INFO, EV_NONE, 0 ), "MsgConfig::AuthLdapPagesize placeholder." };
ErrorId MsgConfig::AuthLdapSsllevel = { ErrorOf( ES_CONFIG, 420, E_INFO, EV_NONE, 0 ), "MsgConfig::AuthLdapSsllevel placeholder." };
ErrorId MsgConfig::AuthLdapTimeout = { ErrorOf( ES_CONFIG, 421, E_INFO, EV_NONE, 0 ), "MsgConfig::AuthLdapTimeout placeholder." };
ErrorId MsgConfig::AuthLdapUserautocreate = { ErrorOf( ES_CONFIG, 422, E_INFO, EV_NONE, 0 ), "MsgConfig::AuthLdapUserautocreate placeholder." };
ErrorId MsgConfig::AuthSsoArgs = { ErrorOf( ES_CONFIG, 423, E_INFO, EV_NONE, 0 ), "MsgConfig::AuthSsoArgs placeholder." };
ErrorId MsgConfig::ZkConnectTimeout = { ErrorOf( ES_CONFIG, 424, E_INFO, EV_NONE, 0 ), "MsgConfig::ZkConnectTimeout placeholder." };
ErrorId MsgConfig::ClientReadonlyDir = { ErrorOf( ES_CONFIG, 425, E_INFO, EV_NONE, 0 ), "MsgConfig::ClientReadonlyDir placeholder." };
ErrorId MsgConfig::ClientSendqDir = { ErrorOf( ES_CONFIG, 426, E_INFO, EV_NONE, 0 ), "MsgConfig::ClientSendqDir placeholder." };
ErrorId MsgConfig::ClientBackupInterval = { ErrorOf( ES_CONFIG, 427, E_INFO, EV_NONE, 0 ), "MsgConfig::ClientBackupInterval placeholder." };
ErrorId MsgConfig::IdleUnloadInterval = { ErrorOf( ES_CONFIG, 428, E_INFO, EV_NONE, 0 ), "MsgConfig::IdleUnloadInterval placeholder." };
ErrorId MsgConfig::RtMonitorfile = { ErrorOf( ES_CONFIG, 429, E_INFO, EV_NONE, 0 ), "MsgConfig::RtMonitorfile placeholder." };
ErrorId MsgConfig::PullTriggerDir = { ErrorOf( ES_CONFIG, 430, E_INFO, EV_NONE, 0 ), "MsgConfig::PullTriggerDir placeholder." };
ErrorId MsgConfig::SysTypesTextStorageBehavior = { ErrorOf( ES_CONFIG, 496, E_INFO, EV_NONE, 0 ), "MsgConfig::SysTypesTextStorageBehavior placeholder." };
ErrorId MsgConfig::ServerStartupAutoRestart = { ErrorOf( ES_CONFIG, 504, E_INFO, EV_NONE, 0 ), "MsgConfig::ServerStartupAutoRestart placeholder." };
# endif
