/*
 * Copyright 1995, 2000 Perforce Software.  All rights reserved.
 *
 * This file is part of Perforce - the FAST SCM System.
 */

/*
 * msgsupp.h - definitions of errors for misc supporting libraries
 */

class MsgSupp {

    public:

	static ErrorId NoTransVar;

	static ErrorId InvalidDate;
	static ErrorId InvalidCharset;

	static ErrorId TooMany;
	static ErrorId MissingCmd;
	static ErrorId Invalid;
	static ErrorId NeedsArg;
	static ErrorId Needs2Arg;
	static ErrorId NeedsNonNegArg;
	static ErrorId ExtraArg;
	static ErrorId WrongArg;
	static ErrorId Usage;
	static ErrorId OptionData;

	static ErrorId NoParm;

	static ErrorId CodeNotFound;
	static ErrorId BadListIndex;

	static ErrorId NoUnixReg;
	static ErrorId NoSuchVariable;
	static ErrorId HidesVar;
	static ErrorId NoP4Config;
	static ErrorId VariableData;

	static ErrorId PartialChar;
	static ErrorId NoTrans;
	static ErrorId ConvertFailed;

	static ErrorId BadMangleParams;
	static ErrorId BadOS;

	static ErrorId Deflate;
	static ErrorId DeflateEnd;
	static ErrorId DeflateInit;
	static ErrorId Inflate;
	static ErrorId InflateInit;
	static ErrorId MagicHeader;
	static ErrorId DigestInitFailed;

	static ErrorId RegexError;

	static ErrorId TracerNoSupport;
	static ErrorId TracerNotConfigured;
	static ErrorId TracerWrongPid;
	static ErrorId TracerNoFlush;

	static ErrorId UnknownTunable;
	static ErrorId TunableValueTooLow;
	static ErrorId TunableValueTooHigh;

	static ErrorId OptionChange;
	static ErrorId OptionPort;
	static ErrorId OptionUser;
	static ErrorId OptionClient;
	static ErrorId OptionPreview;
	static ErrorId OptionDelete;
	static ErrorId OptionForce;
	static ErrorId OptionAdded;
	static ErrorId OptionInput;
	static ErrorId OptionOutput;
	static ErrorId OptionMax;
	static ErrorId OptionQuiet;
	static ErrorId OptionShort;
	static ErrorId OptionLong;
	static ErrorId OptionAll;
	static ErrorId OptionFiletype;
	static ErrorId OptionStream;
	static ErrorId OptionParent;
	static ErrorId OptionClientName;
	static ErrorId OptionHost;
	static ErrorId OptionPassword;
	static ErrorId OptionCharset;
	static ErrorId OptionCmdCharset;
	static ErrorId OptionVariable;
	static ErrorId OptionHelp;
	static ErrorId OptionVersion;
	static ErrorId OptionBatchsize;
	static ErrorId OptionMessageType;
	static ErrorId OptionXargs;
	static ErrorId OptionExclusive;
	static ErrorId OptionProgress;
	static ErrorId OptionDowngrade;
	static ErrorId OptionDirectory;
	static ErrorId OptionRetries;
	static ErrorId OptionNoIgnore;
	static ErrorId OptionCentralUsers;
	static ErrorId OptionReplicaUsers;
	static ErrorId OptionFullBranch;
	static ErrorId OptionSpecFixStatus;
	static ErrorId OptionChangeType;
	static ErrorId OptionChangeUpdate;
	static ErrorId OptionChangeUser;
	static ErrorId OptionOriginal;
	static ErrorId OptionTemplate;
	static ErrorId OptionSwitch;
	static ErrorId OptionTemporary;
	static ErrorId OptionOwner;
	static ErrorId OptionAdministrator;
	static ErrorId OptionGlobal;
	static ErrorId OptionStreamType;
	static ErrorId OptionVirtualStream;
	static ErrorId OptionSwitchStreamUnrelated;
	static ErrorId OptionBrief;
	static ErrorId OptionInherited;
	static ErrorId OptionChangeStatus;
	static ErrorId OptionShowTime;
	static ErrorId OptionLimitClient;
	static ErrorId OptionLabelName;
	static ErrorId OptionRunOnMaster;
	static ErrorId OptionArchive;
	static ErrorId OptionBlocksize;
	static ErrorId OptionHuman1024;
	static ErrorId OptionHuman1000;
	static ErrorId OptionSummary;
	static ErrorId OptionShelved;
	static ErrorId OptionUnload;
	static ErrorId OptionUnloadLimit;
	static ErrorId OptionOmitLazy;
	static ErrorId OptionLeaveKeywords;
	static ErrorId OptionLeaveKeywords2;
	static ErrorId OptionOutputFile;
	static ErrorId OptionExists;
	static ErrorId OptionContent;
	static ErrorId OptionOmitPromoted;
	static ErrorId OptionOmitMoved;
	static ErrorId OptionKeepClient;
	static ErrorId OptionFileCharset;
	static ErrorId OptionVirtual;
	static ErrorId OptionGenerate;
	static ErrorId OptionConfigure;
	static ErrorId OptionUsage;
	static ErrorId OptionTags;
	static ErrorId OptionFilter;
	static ErrorId OptionJob;
	static ErrorId OptionExpression;
	static ErrorId OptionNoCaseExpr;
	static ErrorId OptionIncrement;
	static ErrorId OptionDiffFlags;
	static ErrorId OptionFixStatus;
	static ErrorId OptionShelf;
	static ErrorId OptionReplace;
	static ErrorId OptionShelveOpts;
	static ErrorId OptionBranch;
	static ErrorId OptionSubmitShelf;
	static ErrorId OptionSubmitOpts;
	static ErrorId OptionReopen;
	static ErrorId OptionDescription;
	static ErrorId OptionTamper;
	static ErrorId OptionBackgroundXfer;
	static ErrorId OptionCompress;
	static ErrorId OptionDate;
	static ErrorId OptionStreamName;
	static ErrorId OptionReverse;
	static ErrorId OptionWipe;
	static ErrorId OptionUnchanged;
	static ErrorId OptionDepot;
	static ErrorId OptionDepot2;
	static ErrorId OptionDepotType;
	static ErrorId OptionClientType;
	static ErrorId OptionKeepHead;
	static ErrorId OptionPurge;
	static ErrorId OptionForceText;
	static ErrorId OptionBinaryAsText;
	static ErrorId OptionBypassFlow;
	static ErrorId OptionShowChange;
	static ErrorId OptionFollowBranch;
	static ErrorId OptionFollowInteg;
	static ErrorId OptionSourceFile;
	static ErrorId OptionOutputFlags;
	static ErrorId OptionShowFlags;
	static ErrorId OptionForceFlag;
	static ErrorId OptionResolveFlags;
	static ErrorId OptionAcceptFlags;
	static ErrorId OptionIntegFlags;
	static ErrorId OptionDeleteFlags;
	static ErrorId OptionRestrictFlags;
	static ErrorId OptionSortFlags;
	static ErrorId OptionUseList;
	static ErrorId OptionPublish;
	static ErrorId OptionSafe;
	static ErrorId OptionIsGroup;
	static ErrorId OptionIsUser;
	static ErrorId OptionIsOwner;
	static ErrorId OptionVerbose;
	static ErrorId OptionLineNumber;
	static ErrorId OptionInvertMatch;
	static ErrorId OptionFilesWithMatches;
	static ErrorId OptionFilesWithoutMatch;
	static ErrorId OptionNoMessages;
	static ErrorId OptionFixedStrings;
	static ErrorId OptionBasicRegexp;
	static ErrorId OptionExtendedRegexp;
	static ErrorId OptionPerlRegexp;
	static ErrorId OptionRegexp;
	static ErrorId OptionAfterContext;
	static ErrorId OptionBeforeContext;
	static ErrorId OptionContext;
	static ErrorId OptionIgnoreCase;
	static ErrorId OptionJournalPrefix;
	static ErrorId OptionRepeat;
	static ErrorId OptionBackoff;
	static ErrorId OptionArchiveData;
	static ErrorId OptionStatus;
	static ErrorId OptionJournalPosition;
	static ErrorId OptionPullServerid;
	static ErrorId OptionExcludeTables;
	static ErrorId OptionFile;
	static ErrorId OptionRevision;
	static ErrorId OptionLocalJournal;
	static ErrorId OptionNoRejournal;
	static ErrorId OptionAppend;
	static ErrorId OptionSequence;
	static ErrorId OptionCounter;
	static ErrorId OptionHostName;
	static ErrorId OptionPrint;
	static ErrorId OptionStartPosition;
	static ErrorId OptionEncoded;
	static ErrorId OptionLogName;
	static ErrorId OptionLoginStatus;
	static ErrorId OptionCompressCkp;
	static ErrorId OptionSpecType;
	static ErrorId OptionMaxAccess;
	static ErrorId OptionGroupName;
	static ErrorId OptionShowFiles;
	static ErrorId OptionName;
	static ErrorId OptionValue;
	static ErrorId OptionPropagating;
	static ErrorId OptionOpenAdd;
	static ErrorId OptionOpenEdit;
	static ErrorId OptionOpenDelete;
	static ErrorId OptionOpenType;
	static ErrorId OptionUseModTime;
	static ErrorId OptionLocal;
	static ErrorId OptionMatchMoves;
	static ErrorId OptionOutputBase;
	static ErrorId OptionSystem;
	static ErrorId OptionService;
	static ErrorId OptionHistogram;
	static ErrorId OptionTableNotUnlocked;
	static ErrorId OptionTableName;
	static ErrorId OptionAllClients;
	static ErrorId OptionCheckSize;
	static ErrorId OptionTransfer;
	static ErrorId OptionUpdate;
	static ErrorId OptionVerify;
	static ErrorId OptionNoArchive;
	static ErrorId OptionServerid;
	static ErrorId OptionUnified;
	static ErrorId OptionPreviewNC;
	static ErrorId OptionEstimates;
	static ErrorId OptionLocked;
	static ErrorId OptionUnloadAll;
	static ErrorId OptionKeepHave;
	static ErrorId OptionYes;
	static ErrorId OptionNo;
	static ErrorId OptionInputValue;
	static ErrorId OptionReplacement;
	static ErrorId OptionFrom;
	static ErrorId OptionTo;
	static ErrorId OptionRebuild;
	static ErrorId OptionEqual;
	static ErrorId OptionAttrPattern;
	static ErrorId OptionDiffListFlag;
	static ErrorId OptionArguments;
	static ErrorId OptionEnvironment;
	static ErrorId OptionTaskStatus;
	static ErrorId OptionAllUsers;
	static ErrorId OptionParallel;
	static ErrorId OptionParallelSubmit;
	static ErrorId OptionPromote;
	static ErrorId OptionInputFile;
	static ErrorId OptionPidFile;
	static ErrorId OptionTest;
	static ErrorId OptionActive;
	static ErrorId OptionNoRetransfer;
	static ErrorId OptionForceNoRetransfer;
	static ErrorId OptionDurableOnly;
	static ErrorId OptionNonAcknowledging;
	static ErrorId OptionReplicationStatus;
	static ErrorId OptionGroupMode;
	static ErrorId OptionUserMode;
	static ErrorId OptionUserModeCreate;
	static ErrorId OptionUserModeCreateStrict;
	static ErrorId OptionUserModeUpdate;
	static ErrorId OptionUserModeDelete;
	static ErrorId OptionBypassExlusiveLock;
	static ErrorId OptionCreate;
	static ErrorId OptionList;
	static ErrorId OptionMainline;
	static ErrorId OptionMoveChanges;
	static ErrorId OptionRetainLbrRevisions;
	static ErrorId OptionJavaProtocol;
	static ErrorId OptionPullBatch;
	static ErrorId OptionGlobalLock;
	static ErrorId OptionEnableDVCSTriggers;
	static ErrorId OptionUsers;
	static ErrorId OptionConvertAdminComments;
	static ErrorId OptionRemoteSpec;
	static ErrorId OptionP4UserUser;
	static ErrorId OptionAliases;
	static ErrorId OptionField;
	static ErrorId OptionTab;
	static ErrorId OptionForceDelete;
	static ErrorId OptionStorageType;
	static ErrorId OptionAtomicPush;
	static ErrorId OptionColor;
	static ErrorId OptionChangeFiles;
	static ErrorId OptionDiscardArchives;
	static ErrorId OptionLicenseInfo;
	static ErrorId OptionRemoteUser;
	static ErrorId OptionRename;
	static ErrorId OptionIgnoreCMap;
	static ErrorId OptionMirror;
	static ErrorId OptionDaemonSafe;
	static ErrorId OptionTrigger;
	static ErrorId OptionIgnoreHave;
	static ErrorId OptionGraphOnly;
	static ErrorId OptionNoGraph;
	static ErrorId OptionMinSize;
	static ErrorId OptionMaxSize;
	static ErrorId OptionNameOnly;
	static ErrorId OptionNoFastForward;
	static ErrorId OptionFastForwardOnly;
	static ErrorId OptionMustExist;
	static ErrorId OptionRepoName;
	static ErrorId OptionTargetBranch;
	static ErrorId OptionByUser;
	static ErrorId OptionByOwner;
	static ErrorId OptionSquash;
	static ErrorId OptionAllowEmpty;
	static ErrorId OptionCreateIndex;
	static ErrorId OptionDropIndex;
	static ErrorId OptionRepoName2;
	static ErrorId OptionRetry;
	static ErrorId OptionReference;
	static ErrorId OptionPerm;
	static ErrorId OptionFirstParent;
	static ErrorId OptionIndex;
	static ErrorId OptionGraph;
	static ErrorId OptionOneParent;
	static ErrorId OptionOneline;
	static ErrorId OptionNoAbbrev;
	static ErrorId OptionMerges;
	static ErrorId OptionForceFailover;
	static ErrorId OptionIgnoreMaster;
	static ErrorId OptionRequireMaster;
	static ErrorId OptionFailoverYes;
	static ErrorId OptionFailoverid;
	static ErrorId OptionFailoverQuiesce;
	static ErrorId OptionFailoverVerification;
	static ErrorId OptionFailbackYes;
	static ErrorId OptionFailbackQuiesce;
	static ErrorId OptionPreFailback;
	static ErrorId OptionPostFailback;
	static ErrorId OptionInstall;
	static ErrorId OptionCreateSampleExt;
	static ErrorId OptionUndo;
	static ErrorId OptionParentNumber;
	static ErrorId OptionPkgExtension;
	static ErrorId OptionPath;
	static ErrorId OptionSign;
	static ErrorId OptionCert;
	static ErrorId OptionComment;
	static ErrorId OptionAllowUnsigned;
	static ErrorId OptionNoSync;
	static ErrorId OptionNoScript;
	static ErrorId OptionScriptLang;
	static ErrorId OptionScriptLangVersion;
	static ErrorId OptionChangeStart;
	static ErrorId OptionIntoOnly;
	static ErrorId OptionScriptAPIVersion;
	static ErrorId OptionRunExtensionCmd;
	static ErrorId OptionShowMemInfo;
	static ErrorId OptionRepair;
	static ErrorId OptionDeleteItem;
	static ErrorId OptionTarget;
	static ErrorId OptionInterval;
	static ErrorId OptionWait;
	static ErrorId OptionMissingInterval;
	static ErrorId OptionMissingWait;
	static ErrorId OptionMissingCount;
	static ErrorId OptionSSInherit;
	static ErrorId OptionSSNoInherit;
	static ErrorId OptionSSSourceComments;
	static ErrorId OptionSSParentView;
	static ErrorId OptionLocalLicense;
	static ErrorId OptionAutoReload;

	static ErrorId TooManyLockTrys;

	static ErrorId JsmnBadType;
	static ErrorId JsmnBadParent;
	static ErrorId JsmnBadMem;
	static ErrorId JsmnBadSyn;
	static ErrorId JsmnTooFew;
	static ErrorId JsmnKeyNotFound;

	static ErrorId ManifestKeyNotFound;
	static ErrorId ManifestValueEmpty;
	static ErrorId ManifestValueTypeInvalid;
	static ErrorId ManifestParseError;
	static ErrorId InvalidIntegerRange;

	static ErrorId CurlPerformFailed;
	static ErrorId AwsRejected;
	static ErrorId XmlParseFailed;
	static ErrorId InvalidUrl;
	static ErrorId OTLPInitFailed;
	static ErrorId AwsRoleFetchFailed;
	static ErrorId AwsProfileFailedAccess;
	static ErrorId AwsProfileFailedLoad;

	static ErrorId FatalLockError;
	static ErrorId MissingKeyCert;
	static ErrorId InternalSSLerror;
	static ErrorId InvalidFormatSigFile;
	static ErrorId ExtSignatureFailure;
	static ErrorId ExtensionPackingSuccess;
	static ErrorId OptionOnly;
	static ErrorId OptionShowRealtime;
	static ErrorId RenameTempFailed;
	static ErrorId RenameMkdirFailed;
	static ErrorId RenameRmdirFailed;
	static ErrorId RenameDirSearchFailed;
	static ErrorId RenameDirNotEmpty;
	static ErrorId OptionCleanPurge;
	static ErrorId OptionViewMatch;
	static ErrorId OptionObliterate;
	static ErrorId OptionOffset;
	static ErrorId OptionSize;
	static ErrorId OptionCompressed;
	static ErrorId OptionStreamViews;
	static ErrorId OptionUseStreamChange;
	static ErrorId OptionHasStream;
	static ErrorId OptionNoStream;
	static ErrorId OptionPreserveChangeNumbers;
	static ErrorId OptionLimit;
	static ErrorId OptionType;
	static ErrorId OptionResult;
	static ErrorId OptionJNum;
	static ErrorId OptionJField;
	static ErrorId OptionIntervalMillis;
	static ErrorId OptionThreshold;
	static ErrorId OptionDatedEarlier;
	static ErrorId OptionDeleteMarker;
	static ErrorId OptionDeletePurge;
	static ErrorId OptionMoveTopology;
	static ErrorId OptionServerAddress;
	static ErrorId OptionServerID;
	static ErrorId OptionTargetAddress;
	static ErrorId OptionNewServerAddress;
	static ErrorId OptionNewServerID;
	static ErrorId OptionNewTargetAddress;
	static ErrorId OptionCreationDate;
	static ErrorId OptionLastSeenDate;
	static ErrorId OptionTraitStorage;
	static ErrorId OptionIteration;
	static ErrorId OptionListAddresses;
	static ErrorId OptionTrait;
	static ErrorId OptionTraitFile;
	static ErrorId DigestAlgNotFound;
	static ErrorId DigestAlgWeak;
	static ErrorId OptionFileSizeLimit;
	static ErrorId OptionLsof;
	static ErrorId OptionStrace;
	static ErrorId OptionUserCaseInsensitive;
	static ErrorId OptionClientCaseInsensitive;
	static ErrorId OptionNonLbr;
	static ErrorId OptionStraceRuntime;
	static ErrorId AmbiguousArgs;
	static ErrorId OptionSyncTime;

	// Retired ErrorIds. We need to keep these so that clients 
	// built with newer apis can commnunicate with older servers 
	// still sending these.

	static ErrorId ZCLoadLibFailed; // DEPRECATED 2013.1 removed ZeroConf
	static ErrorId ZCInvalidName; // DEPRECATED 2013.1 removed ZeroConf
	static ErrorId ZCRequireName; // DEPRECATED 2013.1 removed ZeroConf
	static ErrorId ZCNameConflict; // DEPRECATED 2013.1 removed ZeroConf
	static ErrorId ZCRegistryFailed; // DEPRECATED 2013.1 removed ZeroConf
	static ErrorId ZCBrowseFailed; // DEPRECATED 2013.1 removed ZeroConf
	static ErrorId OptionReport;        
} ;

