<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.1/2745343
 */

use Api\Controller\AbstractRestfulController;
use Api\IRequest;
use Application\Config\IConfigDefinition as IDef;
use Application\Controller\IndexControllerFactory;
use Laminas\Router\Http\Literal;
use Laminas\Router\Http\Method;
use Laminas\Router\Http\Segment;
use Search\Controller\SearchApi;
use Laminas\Http\Request;
use Application\Factory\InvokableServiceFactory;
use Search\Filter\Search;
use Search\Filter\ISearch;
use Search\Service\FileSearch;
use Search\Service\IFileSearch;

return [
    IDef::SEARCH => [
        IDef::P4_SEARCH_HOST => null,
        IDef::P4_SEARCH_API_PATH => '/api/v1.2/search/raw',
    ],
    'controllers' => [
        'factories' => [
            SearchApi::class => IndexControllerFactory::class,
        ]
    ],
    'service_manager' => [
        'aliases' => [
            ISearch::SEARCH_FILTER => Search::class,
            IFileSearch::FILE_SEARCH_SERVICE => FileSearch::class
        ],
        'factories' => array_fill_keys(
            [
                Search::class,
                FileSearch::class
            ],
            InvokableServiceFactory::class
        )
    ],
    'router' => [
        'routes' => [
            'api' => [
                'type' => Literal::class,
                'options' => [
                    'route' => AbstractRestfulController::API_BASE,
                ],
                'may_terminate' => false,
                'child_routes' => [
                    'searchApi' => [
                        'type' => Segment::class,
                        'options' => [
                            'route' => '/:version/search',
                            'constraints' => [IRequest::VERSION => "v1[0-1]"],
                        ],
                        'child_routes' => [
                            'search' => [
                                'type' => Method::class,
                                'options' => [
                                    'verb' => Request::METHOD_GET,
                                    'defaults' => [
                                        'controller' => SearchApi::class,
                                        'action'     => 'search'
                                    ],
                                ],
                            ],
                        ],
                    ],
                ],
            ],
        ],
    ]
];
