<?php
/**
 * Perforce Swarm
 *
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.1/2745343
 */
namespace Groups\Service;

use P4\Connection\CommandResult;
use P4\Connection\ConnectionInterface;
use P4\Connection\Exception\CommandException;

/**
 * Interface for the group service to run P4 commands
 */
interface IGroup
{
    const GROUP_SERVICE = 'groupCommand';
    const GROUP_COMMAND = 'group';

    /**
     * Check for the existence of a group by running 'p4 group --exists -o <groupId>'. This is more efficient than
     * relying on 'groups -v' with a maximum result of 1
     * @param ConnectionInterface $connection p4 connection to use
     * @param string $groupId group id to check
     * @param array $options
     * @return CommandResult with the group data if it exists
     * @throws CommandException if the group does not exist
     */
    public function exists(ConnectionInterface $connection, string $groupId, array $options = []) : CommandResult;
}
