<?php
namespace Comments\Filter;

use Laminas\Filter\AbstractFilter;
use Comments\Validator\TaskState as TaskStateValidator;

class TaskState extends AbstractFilter
{
    private $tasksOnly = false;

    public function __construct(?array $options = [])
    {
        if (isset($options[TaskStateValidator::TASKS_ONLY])) {
            $this->tasksOnly = $options[TaskStateValidator::TASKS_ONLY]
                && $options[TaskStateValidator::TASKS_ONLY] === 'true';
        }
    }

    public function filter($value)
    {
        if (!$value) {
            if ($this->tasksOnly) {
                return TaskStateValidator::VALID_TASKS_ONLY_STATES;
            }

            return TaskStateValidator::VALID_TASK_STATES;
        }

        return $value;
    }
}
