<?php
/**
 * @copyright   2013-2025 Perforce Software. All rights reserved.
 * @license     Please see LICENSE.txt in top-level readme folder of this distribution.
 * @version     2025.1/2745343
 */

namespace AiAnalysis\Helper;

/**
 * Interface IHelper describing the responsibilities of a service to help with aiAnalysis
 * @package AiAnalysis\Api
 */
interface IAiAnalysisHelper
{
    const HELPER_NAME            = 'aiAnalysisHelper';
    const SESSION                = 'session';
    const USERNAME               = 'username';
    const USER                   = 'user';
    const PASSWORD               = 'password';
    const ADAPTER                = 'adapter';
    const ERROR                  = 'error';
    const IS_VALID               = 'isValid';
    const AUTH_USER              = 'authUser';
    const UNAUTHORIZED           = 'Unauthorized';
    const AI_PACKAGE             = 'aiPackage';
    const AI_PACKAGE_ID          = 'aiPackageId';
    const CONTENT_TO_ANALYZE     = 'ContentToAnalyze';
    const CONTENT_GENERATED      = 'content_generated';
    const CODE_OPEN_AI_EXCEPTION = 'open AI error';
}
