"use strict";

async function runOnLoad() {
  try {
    var user = await p4vjs.getUser();
    var apiver = await p4vjs.getApiVersion();
    var generalInfoHtmlText = '<p>Welcome ' + user + '!<br/><br/>' +
      'p4vjs api version: <i>' + apiver + '</i><br/>' +
      'Below is the table displaying the Perforce built-in images.</br>' +
      'This will give developers the ability to maintain an integrated look when creating new custom applications.</p>';

    var generalInfo = document.getElementById("generalInfo");
    generalInfo.innerHTML = generalInfoHtmlText;
    var p4vimages = await p4vjs.getImageNames();
    var imageNames = p4vimages["imageNames"];
    imageNames.sort();
    var imageTable = document.getElementById("imageTable");
    for (var i = 0; i < imageNames.length; i++) {
      var row = imageTable.insertRow(i + 1);

      // left cell
      var cellLeft = row.insertCell(0);
      var textNode = document.createTextNode(imageNames[i]);
      cellLeft.appendChild(textNode);

      // right cell
      var cellRight = row.insertCell(1);
      var elem = document.createElement("img");
      var image = await p4vjs.getImage(imageNames[i]);
      elem.setAttribute("src", image);
      cellRight.appendChild(elem);
    }
  }
  catch (e) {
    alert(e);
  }
}
